/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TextFieldListEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_342;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
public class LongListEntry
extends TextFieldListEntry<Long> {
    private static final Function<String, String> stripCharacters = s -> {
        StringBuilder stringBuilder_1 = new StringBuilder();
        char[] var2 = s.toCharArray();
        int var3 = var2.length;
        for (char c : var2) {
            if (!Character.isDigit(c) && c != '-') continue;
            stringBuilder_1.append(c);
        }
        return stringBuilder_1.toString();
    };
    private long minimum = -9223372036854775807L;
    private long maximum = Long.MAX_VALUE;
    private final Consumer<Long> saveConsumer;

    @Deprecated
    @ApiStatus.Internal
    public LongListEntry(class_2561 fieldName, Long value, class_2561 resetButtonKey, Supplier<Long> defaultValue, Consumer<Long> saveConsumer) {
        super(fieldName, value, resetButtonKey, defaultValue);
        this.saveConsumer = saveConsumer;
    }

    @Deprecated
    @ApiStatus.Internal
    public LongListEntry(class_2561 fieldName, Long value, class_2561 resetButtonKey, Supplier<Long> defaultValue, Consumer<Long> saveConsumer, Supplier<Optional<class_2561[]>> tooltipSupplier) {
        this(fieldName, value, resetButtonKey, defaultValue, saveConsumer, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public LongListEntry(class_2561 fieldName, Long value, class_2561 resetButtonKey, Supplier<Long> defaultValue, Consumer<Long> saveConsumer, Supplier<Optional<class_2561[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, value, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        this.saveConsumer = saveConsumer;
    }

    @Override
    protected String stripAddText(String s) {
        return stripCharacters.apply(s);
    }

    @Override
    protected void textFieldPreRender(class_342 widget) {
        try {
            double i = Long.parseLong(this.textFieldWidget.method_1882());
            if (i < (double)this.minimum || i > (double)this.maximum) {
                widget.method_1868(0xFF5555);
            } else {
                widget.method_1868(0xE0E0E0);
            }
        }
        catch (NumberFormatException ex) {
            widget.method_1868(0xFF5555);
        }
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    @Override
    protected boolean isMatchDefault(String text) {
        return this.getDefaultValue().isPresent() && text.equals(((Long)this.defaultValue.get()).toString());
    }

    public LongListEntry setMinimum(long minimum) {
        this.minimum = minimum;
        return this;
    }

    public LongListEntry setMaximum(long maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public Long getValue() {
        try {
            return Long.valueOf(this.textFieldWidget.method_1882());
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public Optional<class_2561> getError() {
        try {
            long i = Long.parseLong(this.textFieldWidget.method_1882());
            if (i > this.maximum) {
                return Optional.of(class_2561.method_43469((String)"text.cloth-config.error.too_large", (Object[])new Object[]{this.maximum}));
            }
            if (i < this.minimum) {
                return Optional.of(class_2561.method_43469((String)"text.cloth-config.error.too_small", (Object[])new Object[]{this.minimum}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(class_2561.method_43471((String)"text.cloth-config.error.not_valid_number_long"));
        }
        return super.getError();
    }
}

