/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.mixin;

import com.google.common.collect.ImmutableSet;
import java.util.function.Supplier;
import ladysnake.illuminations.client.Illuminations;
import ladysnake.illuminations.client.config.Config;
import ladysnake.illuminations.client.data.IlluminationData;
import ladysnake.illuminations.client.enums.BiomeCategory;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3695;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_638.class})
public abstract class ClientWorldMixin
extends class_1937 {
    protected ClientWorldMixin(class_5269 properties, class_5321<class_1937> registryRef, class_6880<class_2874> dimension, Supplier<class_3695> profiler, boolean isClient, boolean debugWorld, long seed, int maxChainedNeighborUpdates) {
        super(properties, registryRef, dimension, profiler, isClient, debugWorld, seed, maxChainedNeighborUpdates);
    }

    @Inject(method={"randomBlockDisplayTick"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/biome/Biome;getParticleConfig()Ljava/util/Optional;"))}, at={@At(value="INVOKE", target="Ljava/util/Optional;ifPresent(Ljava/util/function/Consumer;)V", ordinal=0, shift=At.Shift.AFTER)})
    private void randomBlockDisplayTick(int centerX, int centerY, int centerZ, int radius, class_5819 random, @Coerce Object blockParticle, class_2338.class_2339 blockPos, CallbackInfo ci) {
        class_2338.class_2339 pos = blockPos.method_10080(this.field_9229.method_43059() * 50.0, this.field_9229.method_43059() * 25.0, this.field_9229.method_43059() * 50.0).method_25503();
        class_6880 b = this.method_23753((class_2338)pos);
        class_2960 biome = this.method_30349().method_30530(class_2378.field_25114).method_10221((Object)((class_1959)b.comp_349()));
        b.method_40228().filter(biomeTagKey -> biomeTagKey.comp_327().method_12836().equals("c")).forEach(biomeTagKey -> {
            BiomeCategory biomeCategory = BiomeCategory.find(biome, (class_6862<class_1959>)biomeTagKey);
            this.spawnParticles(pos, (ImmutableSet<IlluminationData>)((ImmutableSet)Illuminations.ILLUMINATIONS_BIOME_CATEGORIES.get((Object)biomeCategory)));
        });
        if (Illuminations.ILLUMINATIONS_BIOMES.containsKey((Object)biome)) {
            ImmutableSet illuminationDataSet = (ImmutableSet)Illuminations.ILLUMINATIONS_BIOMES.get((Object)biome);
            this.spawnParticles(pos, (ImmutableSet<IlluminationData>)illuminationDataSet);
        }
        if (Illuminations.EYES_LOCATION_PREDICATE.test(this, (class_2338)pos) && random.method_43057() <= Config.getEyesInTheDarkSpawnRate().spawnRate) {
            this.method_8406((class_2394)Illuminations.EYES, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    private void spawnParticles(class_2338.class_2339 pos, ImmutableSet<IlluminationData> illuminationDataSet) {
        for (IlluminationData illuminationData : illuminationDataSet) {
            if (!illuminationData.locationSpawnPredicate().test(this, (class_2338)pos) || !illuminationData.shouldAddParticle(this.field_9229)) continue;
            this.method_8406((class_2394)illuminationData.illuminationType(), pos.method_10263(), pos.method_10264(), pos.method_10260(), 0.0, 0.0, 0.0);
        }
    }

    @Inject(method={"addPlayer"}, at={@At(value="RETURN")})
    public void addPlayer(int id, class_742 player, CallbackInfo ci) {
        Illuminations.loadPlayerCosmetics();
    }
}

