/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client.particle;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import ladysnake.illuminations.client.Illuminations;
import ladysnake.illuminations.client.config.Config;
import ladysnake.illuminations.client.enums.BiomeCategory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_703;
import net.minecraft.class_707;

public class FireflyParticle
extends class_4003 {
    protected static final float BLINK_STEP = 0.05f;
    private final class_4002 spriteProvider;
    private final boolean isAttractedByLight = true;
    protected float nextAlphaGoal = 0.0f;
    protected double xTarget;
    protected double yTarget;
    protected double zTarget;
    protected int targetChangeCooldown = 0;
    protected int maxHeight;
    private class_2338 lightTarget;

    public FireflyParticle(class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, class_4002 spriteProvider) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        Color c;
        this.spriteProvider = spriteProvider;
        this.field_17867 *= 0.25f + this.field_3840.method_43057() * 0.5f;
        this.field_3847 = ThreadLocalRandom.current().nextInt(400, 1201);
        this.maxHeight = 4;
        this.field_3862 = true;
        this.method_18142(spriteProvider);
        this.field_3841 = 0.0f;
        if (Config.getFireflyRainbow()) {
            c = Color.getHSBColor(this.field_3840.method_43057(), 1.0f, 1.0f);
        } else {
            class_6880 b = world.method_23753(new class_2338(x, y, z));
            class_2960 biome = world.method_30349().method_30530(class_2378.field_25114).method_10221((Object)((class_1959)b.comp_349()));
            BiomeCategory biomeCategory = BiomeCategory.find(biome, (class_6862<class_1959>)((class_6862)b.method_40228().findFirst().get()));
            int rgb = Config.getBiomeSettings(biomeCategory).fireflyColor();
            float[] hsb = Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, null);
            hsb[0] = hsb[0] + (this.field_3840.method_43057() - 0.5f) * 30.0f / 360.0f;
            c = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        }
        this.field_3861 = (float)c.getRed() / 255.0f;
        this.field_3842 = (float)c.getGreen() / 255.0f;
        this.field_3859 = (float)c.getBlue() / 255.0f;
    }

    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        class_1158 quaternion2;
        class_243 vec3d = camera.method_19326();
        float f = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3858, (double)this.field_3874) - vec3d.method_10216());
        float g = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3838, (double)this.field_3854) - vec3d.method_10214());
        float h = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3856, (double)this.field_3871) - vec3d.method_10215());
        if (this.field_3839 == 0.0f) {
            quaternion2 = camera.method_23767();
        } else {
            quaternion2 = new class_1158(camera.method_23767());
            float i = class_3532.method_16439((float)tickDelta, (float)this.field_3857, (float)this.field_3839);
            quaternion2.method_4925(class_1160.field_20707.method_23626(i));
        }
        class_1160 Vec3f = new class_1160(-1.0f, -1.0f, 0.0f);
        Vec3f.method_19262(quaternion2);
        class_1160[] Vec3fs = new class_1160[]{new class_1160(-1.0f, -1.0f, 0.0f), new class_1160(-1.0f, 1.0f, 0.0f), new class_1160(1.0f, 1.0f, 0.0f), new class_1160(1.0f, -1.0f, 0.0f)};
        float j = this.method_18132(tickDelta);
        for (int k = 0; k < 4; ++k) {
            class_1160 Vec3f2 = Vec3fs[k];
            Vec3f2.method_19262(quaternion2);
            Vec3f2.method_4942(j);
            Vec3f2.method_4948(f, g, h);
        }
        float minU = this.method_18133();
        float maxU = this.method_18134();
        float minV = this.method_18135();
        float maxV = this.method_18136();
        int l = 0xF000F0;
        float a = Math.min(1.0f, Math.max(0.0f, this.field_3841));
        vertexConsumer.method_22912((double)Vec3fs[0].method_4943(), (double)Vec3fs[0].method_4945(), (double)Vec3fs[0].method_4947()).method_22913(maxU, minV + (maxV - minV) / 2.0f).method_22915(this.field_3861, this.field_3842, this.field_3859, a).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[1].method_4943(), (double)Vec3fs[1].method_4945(), (double)Vec3fs[1].method_4947()).method_22913(maxU, minV).method_22915(this.field_3861, this.field_3842, this.field_3859, a).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[2].method_4943(), (double)Vec3fs[2].method_4945(), (double)Vec3fs[2].method_4947()).method_22913(minU, minV).method_22915(this.field_3861, this.field_3842, this.field_3859, a).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[3].method_4943(), (double)Vec3fs[3].method_4945(), (double)Vec3fs[3].method_4947()).method_22913(minU, minV + (maxV - minV) / 2.0f).method_22915(this.field_3861, this.field_3842, this.field_3859, a).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[0].method_4943(), (double)Vec3fs[0].method_4945(), (double)Vec3fs[0].method_4947()).method_22913(maxU, maxV).method_22915(1.0f, 1.0f, 1.0f, a * (float)Config.getFireflyWhiteAlpha() / 100.0f).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[1].method_4943(), (double)Vec3fs[1].method_4945(), (double)Vec3fs[1].method_4947()).method_22913(maxU, minV + (maxV - minV) / 2.0f).method_22915(1.0f, 1.0f, 1.0f, a * (float)Config.getFireflyWhiteAlpha() / 100.0f).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[2].method_4943(), (double)Vec3fs[2].method_4945(), (double)Vec3fs[2].method_4947()).method_22913(minU, minV + (maxV - minV) / 2.0f).method_22915(1.0f, 1.0f, 1.0f, a * (float)Config.getFireflyWhiteAlpha() / 100.0f).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[3].method_4943(), (double)Vec3fs[3].method_4945(), (double)Vec3fs[3].method_4947()).method_22913(minU, maxV).method_22915(1.0f, 1.0f, 1.0f, a * (float)Config.getFireflyWhiteAlpha() / 100.0f).method_22916(l).method_1344();
    }

    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (!Config.doesFireflySpawnAlways() && !this.field_3851.method_8597().method_29960() && !Illuminations.isNightTime((class_1937)this.field_3851) || this.field_3866++ >= this.field_3847) {
            this.nextAlphaGoal = 0.0f;
            if (this.field_3841 < 0.0f) {
                this.method_3085();
            }
        }
        if (this.field_3841 > this.nextAlphaGoal - 0.05f && this.field_3841 < this.nextAlphaGoal + 0.05f) {
            this.nextAlphaGoal = this.field_3840.method_43057();
        } else if (this.nextAlphaGoal > this.field_3841) {
            this.field_3841 = Math.min(this.field_3841 + 0.05f, 1.0f);
        } else if (this.nextAlphaGoal < this.field_3841) {
            this.field_3841 = Math.max(this.field_3841 - 0.05f, 0.0f);
        }
        this.targetChangeCooldown -= new class_243(this.field_3874, this.field_3854, this.field_3871).method_1028(this.field_3858, this.field_3838, this.field_3856) < 0.0125 ? 10 : 1;
        if (this.field_3851.method_8510() % 20L == 0L && (this.xTarget == 0.0 && this.yTarget == 0.0 && this.zTarget == 0.0 || new class_243(this.field_3874, this.field_3854, this.field_3871).method_1028(this.xTarget, this.yTarget, this.zTarget) < 9.0 || this.targetChangeCooldown <= 0)) {
            this.selectBlockTarget();
        }
        class_243 targetVector = new class_243(this.xTarget - this.field_3874, this.yTarget - this.field_3854, this.zTarget - this.field_3871);
        double length = targetVector.method_1033();
        targetVector = targetVector.method_1021(0.1 / length);
        if (!this.field_3851.method_8320(new class_2338(this.field_3874, this.field_3854 - 0.1, this.field_3871)).method_26204().method_9538()) {
            this.field_3852 = 0.9 * this.field_3852 + 0.1 * targetVector.field_1352;
            this.field_3869 = 0.05;
            this.field_3850 = 0.9 * this.field_3850 + 0.1 * targetVector.field_1350;
        } else {
            this.field_3852 = 0.9 * this.field_3852 + 0.1 * targetVector.field_1352;
            this.field_3869 = 0.9 * this.field_3869 + 0.1 * targetVector.field_1351;
            this.field_3850 = 0.9 * this.field_3850 + 0.1 * targetVector.field_1350;
        }
        if (!new class_2338(this.field_3874, this.field_3854, this.field_3871).equals((Object)this.getTargetPosition())) {
            this.method_3069(this.field_3852, this.field_3869, this.field_3850);
        }
    }

    private void selectBlockTarget() {
        if (this.lightTarget == null) {
            double groundLevel = 0.0;
            for (int i = 0; i < 20; ++i) {
                class_2680 checkedBlock = this.field_3851.method_8320(new class_2338(this.field_3874, this.field_3854 - (double)i, this.field_3871));
                if (!checkedBlock.method_26204().method_9538()) {
                    groundLevel = this.field_3854 - (double)i;
                }
                if (groundLevel != 0.0) break;
            }
            this.xTarget = this.field_3874 + this.field_3840.method_43059() * 10.0;
            this.yTarget = Math.min(Math.max(this.field_3854 + this.field_3840.method_43059() * 2.0, groundLevel), groundLevel + (double)this.maxHeight);
            this.zTarget = this.field_3871 + this.field_3840.method_43059() * 10.0;
            class_2338 targetPos = new class_2338(this.xTarget, this.yTarget, this.zTarget);
            if (this.field_3851.method_8320(targetPos).method_26234((class_1922)this.field_3851, targetPos) && this.field_3851.method_8320(targetPos).method_26212((class_1922)this.field_3851, targetPos)) {
                this.yTarget += 1.0;
            }
            Objects.requireNonNull(this);
            this.lightTarget = this.getMostLitBlockAround();
        } else {
            this.xTarget = (double)this.lightTarget.method_10263() + this.field_3840.method_43059();
            this.yTarget = (double)this.lightTarget.method_10264() + this.field_3840.method_43059();
            this.zTarget = (double)this.lightTarget.method_10260() + this.field_3840.method_43059();
            this.field_3874 = this.lightTarget.method_10263();
            this.field_3854 = this.lightTarget.method_10264() + 1;
            this.field_3871 = this.lightTarget.method_10260();
            this.lightTarget = this.field_3851.method_8314(class_1944.field_9282, new class_2338(this.field_3874, this.field_3854, this.field_3871)) > 0 && !this.field_3851.method_8530() ? this.getMostLitBlockAround() : null;
        }
        this.targetChangeCooldown = this.field_3840.method_43054() % 100;
    }

    public class_2338 getTargetPosition() {
        return new class_2338(this.xTarget, this.yTarget + 0.5, this.zTarget);
    }

    private class_2338 getMostLitBlockAround() {
        HashMap<class_2338, Integer> randBlocks = new HashMap<class_2338, Integer>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    class_2338 bp = new class_2338(this.field_3874 + (double)x, this.field_3854 + (double)y, this.field_3871 + (double)z);
                    randBlocks.put(bp, this.field_3851.method_8314(class_1944.field_9282, bp));
                }
            }
        }
        for (int i = 0; i < 15; ++i) {
            class_2338 randBP = new class_2338(this.field_3874 + this.field_3840.method_43059() * 10.0, this.field_3854 + this.field_3840.method_43059() * 10.0, this.field_3871 + this.field_3840.method_43059() * 10.0);
            randBlocks.put(randBP, this.field_3851.method_8314(class_1944.field_9282, randBP));
        }
        return (class_2338)((Map.Entry)randBlocks.entrySet().stream().max((entry1, entry2) -> (Integer)entry1.getValue() > (Integer)entry2.getValue() ? 1 : -1).get()).getKey();
    }

    @Environment(value=EnvType.CLIENT)
    public static class DefaultFactory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;

        public DefaultFactory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public class_703 createParticle(class_2400 defaultParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            return new FireflyParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

