/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client.enums;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

public enum BiomeCategory {
    FOREST("minecraft:overworld", (class_6862<class_1959>)ConventionalBiomeTags.FOREST, "minecraft:forest", "minecraft:wooded_hills", "minecraft:flower_forest", "minecraft:birch_forest", "minecraft:birch_forest_hills", "minecraft:tall_birch_forest", "minecraft:tall_birch_hills", "minecraft:dark_forest", "minecraft:dark_forest_hills"),
    TAIGA("minecraft:overworld", (class_6862<class_1959>)ConventionalBiomeTags.TAIGA, "minecraft:taiga", "minecraft:taiga_hills", "minecraft:taiga_mountains", "minecraft:giant_tree_taiga", "minecraft:giant_tree_taiga_hills", "minecraft:giant_spruce_taiga", "minecraft:giant_spruce_taiga_hills"),
    SNOWY("minecraft:overworld", (class_6862<class_1959>)ConventionalBiomeTags.ICY, "minecraft:snowy_tundra", "minecraft:snowy_mountains", "minecraft:ice_spikes", "minecraft:snowy_taiga", "minecraft:snowy_taiga_hills", "minecraft:snowy_taiga_mountains", "minecraft:frozen_river", "minecraft:frozen_ocean", "minecraft:deep_frozen_ocean"),
    PLAINS("minecraft:overworld", (class_6862<class_1959>)ConventionalBiomeTags.PLAINS, "minecraft:plains", "minecraft:sunflower_plains"),
    DESERT("minecraft:overworld", (class_6862<class_1959>)ConventionalBiomeTags.DESERT, "minecraft:desert", "minecraft:desert_hills", "minecraft:desert_lakes"),
    SAVANNA("minecraft:overworld", (class_6862<class_1959>)ConventionalBiomeTags.SAVANNA, "minecraft:savanna", "minecraft:savanna_plateau", "minecraft:shattered_savanna", "minecraft:shattered_savanna_plateau"),
    JUNGLE("minecraft:overworld", (class_6862<class_1959>)ConventionalBiomeTags.JUNGLE, "minecraft:jungle", "minecraft:jungle_hills", "minecraft:modified_jungle", "minecraft:jungle_edge", "minecraft:modified_jungle_edge", "minecraft:bamboo_jungle", "minecraft:bamboo_jungle_hills"),
    BEACH("minecraft:overworld", (class_6862<class_1959>)ConventionalBiomeTags.BEACH, "minecraft:beach", "minecraft:stone_shore"),
    SWAMP("minecraft:overworld", (class_6862<class_1959>)ConventionalBiomeTags.SWAMP, "minecraft:swamp", "minecraft:swamp_hills", "minecraft:mangrove_swamp"),
    RIVER("minecraft:overworld", (class_6862<class_1959>)ConventionalBiomeTags.RIVER, "minecraft:river"),
    OCEAN("minecraft:overworld", (class_6862<class_1959>)ConventionalBiomeTags.OCEAN, "minecraft:ocean", "minecraft:deep_ocean", "minecraft:cold_ocean", "minecraft:deep_cold_ocean"),
    WARM_OCEAN("minecraft:overworld", null, "minecraft:lukewarm_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:warm_ocean", "minecraft:deep_warm_ocean"),
    BADLANDS("minecraft:overworld", (class_6862<class_1959>)ConventionalBiomeTags.MESA, "minecraft:badlands", "minecraft:badlands_plateau", "minecraft:modified_badlands_plateau", "minecraft:wooded_badlands_plateau", "minecraft:modified_wooded_badlands_plateau", "minecraft:eroded_badlands"),
    MOUNTAINS("minecraft:overworld", (class_6862<class_1959>)ConventionalBiomeTags.EXTREME_HILLS, "minecraft:mountains", "minecraft:wooded_mountains", "minecraft:gravelly_mountains", "minecraft:modified_gravelly_mountains", "minecraft:mountain_edge"),
    DRIPSTONE_CAVES("minecraft:overworld", (class_6862<class_1959>)ConventionalBiomeTags.UNDERGROUND, "minecraft:dripstone_caves"),
    LUSH_CAVES("minecraft:overworld", null, "minecraft:lush_caves"),
    MUSHROOM("minecraft:overworld", (class_6862<class_1959>)ConventionalBiomeTags.MUSHROOM, "minecraft:mushroom_fields", "minecraft:mushroom_field_shore"),
    THE_VOID("minecraft:overworld", null, "minecraft:the_void"),
    NETHER_WASTES("minecraft:the_nether", (class_6862<class_1959>)ConventionalBiomeTags.IN_NETHER, "minecraft:nether_wastes"),
    CRIMSON_FOREST("minecraft:the_nether", null, "minecraft:crimson_forest"),
    WARPED_FOREST("minecraft:the_nether", null, "minecraft:warped_forest"),
    SOUL_SAND_VALLEY("minecraft:the_nether", null, "minecraft:soul_sand_valley"),
    BASALT_DELTAS("minecraft:the_nether", null, "minecraft:basalt_deltas"),
    THE_END("minecraft:the_end", (class_6862<class_1959>)ConventionalBiomeTags.IN_THE_END, "minecraft:the_end"),
    SMALL_END_ISLANDS("minecraft:the_end", null, "minecraft:small_end_islands"),
    END_MIDLANDS("minecraft:the_end", null, "minecraft:end_midlands"),
    END_HIGHLANDS("minecraft:the_end", null, "minecraft:end_highlands"),
    END_BARRENS("minecraft:the_end", null, "minecraft:end_barrens"),
    OTHER("minecraft:other", (class_6862<class_1959>)ConventionalBiomeTags.IN_OVERWORLD, new String[0]);

    private static final Set<class_2960> dimensions;
    private static final Map<class_2960, BiomeCategory> lookUp;
    private static final Map<class_6862<class_1959>, BiomeCategory> fallbackLookUp;
    private final class_2960 dimension;
    private final class_6862<class_1959> fallback;
    private final class_2960[] biomes;

    private BiomeCategory(String dimension, class_6862<class_1959> fallback, String ... biomes) {
        this.dimension = new class_2960(dimension);
        this.fallback = fallback;
        this.biomes = new class_2960[biomes.length];
        for (int i = 0; i < biomes.length; ++i) {
            this.biomes[i] = new class_2960(biomes[i]);
        }
    }

    public static Set<class_2960> getDimensions() {
        return dimensions;
    }

    private static Set<class_2960> initializeDimensions() {
        LinkedHashSet<class_2960> dimensions = new LinkedHashSet<class_2960>();
        for (BiomeCategory category : BiomeCategory.values()) {
            dimensions.add(category.dimension);
        }
        return dimensions;
    }

    private static Map<class_2960, BiomeCategory> initializeLookUp() {
        HashMap<class_2960, BiomeCategory> lookUp = new HashMap<class_2960, BiomeCategory>();
        for (BiomeCategory category : BiomeCategory.values()) {
            for (class_2960 biome : category.biomes) {
                lookUp.put(biome, category);
            }
        }
        return lookUp;
    }

    private static Map<class_6862<class_1959>, BiomeCategory> initializeFallbackLookUp() {
        HashMap<class_6862<class_1959>, BiomeCategory> lookUp = new HashMap<class_6862<class_1959>, BiomeCategory>();
        for (BiomeCategory category : BiomeCategory.values()) {
            if (category.fallback == null) continue;
            lookUp.put(category.fallback, category);
        }
        return lookUp;
    }

    public static BiomeCategory find(class_2960 biome, class_6862<class_1959> biomeCategory) {
        return lookUp.containsKey(biome) ? lookUp.get(biome) : fallbackLookUp.getOrDefault(biomeCategory, OTHER);
    }

    public class_2960 getDimension() {
        return this.dimension;
    }

    public class_2960[] getBiomes() {
        return this.biomes;
    }

    static {
        dimensions = Collections.unmodifiableSet(BiomeCategory.initializeDimensions());
        lookUp = Collections.unmodifiableMap(BiomeCategory.initializeLookUp());
        fallbackLookUp = Collections.unmodifiableMap(BiomeCategory.initializeFallbackLookUp());
    }
}

