/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client.config;

import com.google.common.base.CaseFormat;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import ladysnake.illuminations.client.config.DefaultConfig;
import ladysnake.illuminations.client.data.BiomeSettings;
import ladysnake.illuminations.client.enums.BiomeCategory;
import ladysnake.illuminations.client.enums.EyesInTheDarkSpawnRate;
import ladysnake.illuminations.client.enums.FireflySpawnRate;
import ladysnake.illuminations.client.enums.GlowwormSpawnRate;
import ladysnake.illuminations.client.enums.HalloweenFeatures;
import ladysnake.illuminations.client.enums.PlanktonSpawnRate;
import ladysnake.illuminations.client.enums.WillOWispsSpawnRate;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

public class Config {
    public static final Path PROPERTIES_PATH = FabricLoader.getInstance().getConfigDir().resolve("illuminations.properties");
    private static final Properties config = new Properties(){

        @Override
        @NotNull
        public Set<Map.Entry<Object, Object>> entrySet() {
            Iterator iterator = super.entrySet().stream().sorted(Comparator.comparing(o -> o.getKey().toString())).iterator();
            LinkedHashSet<Map.Entry<Object, Object>> temp = new LinkedHashSet<Map.Entry<Object, Object>>(super.entrySet().size());
            while (iterator.hasNext()) {
                temp.add((Map.Entry)iterator.next());
            }
            return temp;
        }
    };
    private static HalloweenFeatures halloweenFeatures;
    private static EyesInTheDarkSpawnRate eyesInTheDarkSpawnRate;
    private static WillOWispsSpawnRate willOWispsSpawnRate;
    private static int chorusPetalsSpawnMultiplier;
    private static int density;
    private static boolean fireflySpawnAlways;
    private static boolean fireflySpawnUnderground;
    private static int fireflyWhiteAlpha;
    private static boolean fireflyRainbow;
    private static boolean viewAurasFP;
    private static boolean debugMode;
    private static boolean displayCosmetics;
    private static boolean displayDonationToast;
    private static HashMap<BiomeCategory, BiomeSettings> biomeSettings;

    public static void load() {
        if (Files.isRegularFile(PROPERTIES_PATH, new LinkOption[0])) {
            try {
                config.load(Files.newBufferedReader(PROPERTIES_PATH));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Config.setHalloweenFeatures(DefaultConfig.HALLOWEEN_FEATURES);
            Config.setEyesInTheDarkSpawnRate(DefaultConfig.EYES_IN_THE_DARK_SPAWN_RATE);
            Config.setWillOWispsSpawnRate(DefaultConfig.WILL_O_WISPS_SPAWN_RATE);
            Config.setChorusPetalsSpawnMultiplier(1);
            Config.setDensity(100);
            Config.setFireflySpawnAlways(false);
            Config.setFireflySpawnUnderground(false);
            Config.setFireflyWhiteAlpha(100);
            Config.setDisplayCosmetics(true);
            Config.setViewAurasFP(false);
            Config.setDisplayDonationToast(true);
            biomeSettings = new HashMap();
            DefaultConfig.BIOME_SETTINGS.forEach(Config::setBiomeSettings);
            Config.save();
            return;
        }
        Config.parseProperty("halloween-features", Config::setHalloweenFeatures, DefaultConfig.HALLOWEEN_FEATURES);
        Config.parseProperty("eyes-in-the-dark-spawn-rate", Config::setEyesInTheDarkSpawnRate, DefaultConfig.EYES_IN_THE_DARK_SPAWN_RATE);
        Config.parseProperty("will-o-wisps-spawn-rate", Config::setWillOWispsSpawnRate, DefaultConfig.WILL_O_WISPS_SPAWN_RATE);
        Config.parseProperty("chorus-petal-spawn-multiplier", Config::setChorusPetalsSpawnMultiplier, 1);
        Config.parseProperty("density", Config::setDensity, 100);
        Config.parseProperty("firefly-spawn-always", Config::setFireflySpawnAlways, false);
        Config.parseProperty("firefly-spawn-underground", Config::setFireflySpawnUnderground, false);
        Config.parseProperty("firefly-white-alpha", Config::setFireflyWhiteAlpha, 100);
        Config.parseProperty("firefly-rainbow", Config::setFireflyRainbow, false);
        Config.parseProperty("display-cosmetics", Config::setDisplayCosmetics, true);
        Config.parseProperty("debug-mode", Config::setDebugMode, false);
        Config.parseProperty("view-auras-fp", Config::setViewAurasFP, false);
        Config.parseProperty("display-donation-toast", Config::setDisplayDonationToast, true);
        biomeSettings = new HashMap();
        DefaultConfig.BIOME_SETTINGS.forEach((biome, defaultValue) -> Config.parseProperty(biome.name(), (BiomeSettings x) -> Config.setBiomeSettings(biome, x), defaultValue));
        Config.save();
    }

    private static <T extends Enum<T>> void parseProperty(String property, Consumer<T> setter, T defaultValue) {
        try {
            setter.accept(Enum.valueOf(defaultValue.getDeclaringClass(), config.getProperty(property)));
        }
        catch (Exception e) {
            setter.accept(defaultValue);
        }
    }

    private static void parseProperty(String property, Consumer<Boolean> setter, Boolean defaultValue) {
        try {
            setter.accept(Boolean.parseBoolean(config.getProperty(property)));
        }
        catch (Exception e) {
            setter.accept(defaultValue);
        }
    }

    private static void parseProperty(String property, Consumer<Integer> setter, Integer defaultValue) {
        try {
            setter.accept(Integer.parseInt(config.getProperty(property)));
        }
        catch (Exception e) {
            setter.accept(defaultValue);
        }
    }

    private static void parseProperty(String biome, Consumer<BiomeSettings> setter, BiomeSettings defaultValue) {
        try {
            String name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, biome);
            FireflySpawnRate fireflySpawnRate = FireflySpawnRate.valueOf(config.getProperty(name + "-firefly-spawn-rate"));
            GlowwormSpawnRate glowwormSpawnRate = defaultValue.glowwormSpawnRate() == null ? null : GlowwormSpawnRate.valueOf(config.getProperty(name + "-glowworm-spawn-rate"));
            PlanktonSpawnRate planktonSpawnRate = defaultValue.planktonSpawnRate() == null ? null : PlanktonSpawnRate.valueOf(config.getProperty(name + "-plankton-spawn-rate"));
            int fireflyColor = Integer.parseInt(config.getProperty(name + "-firefly-color"), 16);
            setter.accept(new BiomeSettings(fireflySpawnRate, fireflyColor, glowwormSpawnRate, planktonSpawnRate));
        }
        catch (Exception e) {
            setter.accept(defaultValue);
        }
    }

    public static void save() {
        try {
            config.store(Files.newBufferedWriter(PROPERTIES_PATH, new OpenOption[0]), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static HalloweenFeatures getHalloweenFeatures() {
        return halloweenFeatures;
    }

    public static void setHalloweenFeatures(HalloweenFeatures value) {
        halloweenFeatures = value;
        config.setProperty("halloween-features", value.toString());
    }

    public static EyesInTheDarkSpawnRate getEyesInTheDarkSpawnRate() {
        return eyesInTheDarkSpawnRate;
    }

    public static void setEyesInTheDarkSpawnRate(EyesInTheDarkSpawnRate value) {
        eyesInTheDarkSpawnRate = value;
        config.setProperty("eyes-in-the-dark-spawn-rate", value.name());
    }

    public static WillOWispsSpawnRate getWillOWispsSpawnRate() {
        return willOWispsSpawnRate;
    }

    public static void setWillOWispsSpawnRate(WillOWispsSpawnRate value) {
        willOWispsSpawnRate = value;
        config.setProperty("will-o-wisps-spawn-rate", value.name());
    }

    public static int getChorusPetalsSpawnMultiplier() {
        return chorusPetalsSpawnMultiplier;
    }

    public static void setChorusPetalsSpawnMultiplier(int value) {
        chorusPetalsSpawnMultiplier = value;
        config.setProperty("chorus-petal-spawn-multiplier", Integer.toString(value));
    }

    public static int getDensity() {
        return density;
    }

    public static void setDensity(int value) {
        density = value;
        config.setProperty("density", Integer.toString(value));
    }

    public static boolean doesFireflySpawnAlways() {
        return fireflySpawnAlways;
    }

    public static void setFireflySpawnAlways(boolean value) {
        fireflySpawnAlways = value;
        config.setProperty("firefly-spawn-always", Boolean.toString(value));
    }

    public static boolean doesFireflySpawnUnderground() {
        return fireflySpawnUnderground;
    }

    public static void setFireflySpawnUnderground(boolean value) {
        fireflySpawnUnderground = value;
        config.setProperty("firefly-spawn-underground", Boolean.toString(value));
    }

    public static int getFireflyWhiteAlpha() {
        return fireflyWhiteAlpha;
    }

    public static void setFireflyWhiteAlpha(int value) {
        fireflyWhiteAlpha = value;
        config.setProperty("firefly-white-alpha", Integer.toString(value));
    }

    public static boolean getFireflyRainbow() {
        return fireflyRainbow;
    }

    public static void setFireflyRainbow(boolean value) {
        fireflyRainbow = value;
        config.setProperty("firefly-rainbow", Boolean.toString(value));
    }

    public static boolean getViewAurasFP() {
        return viewAurasFP;
    }

    public static void setViewAurasFP(boolean value) {
        viewAurasFP = value;
        config.setProperty("view-auras-fp", Boolean.toString(value));
    }

    public static boolean shouldDisplayCosmetics() {
        return displayCosmetics;
    }

    public static void setDisplayCosmetics(boolean value) {
        displayCosmetics = value;
        config.setProperty("display-cosmetics", Boolean.toString(value));
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(boolean value) {
        debugMode = value;
        config.setProperty("debug-mode", Boolean.toString(value));
    }

    public static boolean shouldDisplayDonationToast() {
        return displayDonationToast;
    }

    public static void setDisplayDonationToast(boolean value) {
        displayDonationToast = value;
        config.setProperty("display-donation-toast", Boolean.toString(value));
    }

    public static Map<BiomeCategory, BiomeSettings> getBiomeSettings() {
        return biomeSettings;
    }

    public static BiomeSettings getBiomeSettings(BiomeCategory biome) {
        return biomeSettings.get((Object)biome);
    }

    public static void setBiomeSettings(BiomeCategory biome, BiomeSettings settings) {
        biomeSettings.put(biome, settings);
        String name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, biome.name());
        config.setProperty(name + "-firefly-spawn-rate", settings.fireflySpawnRate().name());
        config.setProperty(name + "-firefly-color", Integer.toString(settings.fireflyColor(), 16));
        if (settings.glowwormSpawnRate() != null) {
            config.setProperty(name + "-glowworm-spawn-rate", settings.glowwormSpawnRate().name());
        }
        if (settings.planktonSpawnRate() != null) {
            config.setProperty(name + "-plankton-spawn-rate", settings.planktonSpawnRate().name());
        }
    }

    public static void setFireflySettings(BiomeCategory biome, FireflySpawnRate value) {
        BiomeSettings settings = biomeSettings.get((Object)biome);
        biomeSettings.put(biome, settings.withFireflySpawnRate(value));
        String name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, biome.name());
        config.setProperty(name + "-firefly-spawn-rate", value.name());
    }

    public static void setFireflyColorSettings(BiomeCategory biome, int color) {
        BiomeSettings settings = biomeSettings.get((Object)biome);
        biomeSettings.put(biome, settings.withFireflyColor(color));
        String name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, biome.name());
        config.setProperty(name + "-firefly-color", Integer.toString(color, 16));
    }

    public static void setGlowwormSettings(BiomeCategory biome, GlowwormSpawnRate value) {
        BiomeSettings settings = biomeSettings.get((Object)biome);
        biomeSettings.put(biome, settings.withGlowwormSpawnRate(value));
        String name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, biome.name());
        config.setProperty(name + "-glowworm-spawn-rate", value.name());
    }

    public static void setPlanktonSettings(BiomeCategory biome, PlanktonSpawnRate value) {
        BiomeSettings settings = biomeSettings.get((Object)biome);
        biomeSettings.put(biome, settings.withPlanktonSpawnRate(value));
        String name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, biome.name());
        config.setProperty(name + "-plankton-spawn-rate", value.name());
    }
}

