/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.recipe;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import wraith.alloyforgery.AlloyForgery;
import wraith.alloyforgery.block.ForgeControllerBlockEntity;
import wraith.alloyforgery.forges.UnifiedInventoryView;
import wraith.alloyforgery.recipe.AlloyForgeRecipeSerializer;

public class AlloyForgeRecipe
implements class_1860<class_1263> {
    private final class_2960 id;
    private final Map<class_1856, Integer> inputs;
    private final class_1799 output;
    private final int minForgeTier;
    private final int fuelPerTick;
    private final ImmutableMap<OverrideRange, class_1799> tierOverrides;

    public AlloyForgeRecipe(class_2960 id, Map<class_1856, Integer> inputs, class_1799 output, int minForgeTier, int fuelPerTick, ImmutableMap<OverrideRange, class_1799> overrides) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.minForgeTier = minForgeTier;
        this.fuelPerTick = fuelPerTick;
        this.tierOverrides = overrides;
    }

    public boolean method_8118() {
        return true;
    }

    public boolean method_8115(class_1263 inventory, class_1937 world) {
        int matchedIngredients = 0;
        UnifiedInventoryView unifiedView = ((ForgeControllerBlockEntity)inventory).asUnifiedView();
        if (unifiedView.getUnifiedInventory().size() != this.inputs.size()) {
            return false;
        }
        ArrayList<Map.Entry<class_1856, Integer>> localInputs = new ArrayList<Map.Entry<class_1856, Integer>>(this.inputs.entrySet());
        for (Map.Entry<class_1792, Integer> invEntry : unifiedView.getUnifiedInventory().entrySet()) {
            boolean isValidIngredient = false;
            for (int i = 0; i < localInputs.size(); ++i) {
                Map.Entry<class_1856, Integer> inputEntry = localInputs.get(i);
                if (invEntry.getValue() - inputEntry.getValue() < 0 || !inputEntry.getKey().method_8093(invEntry.getKey().method_7854())) continue;
                isValidIngredient = true;
                ++matchedIngredients;
                localInputs.remove(i);
                break;
            }
            if (isValidIngredient) continue;
            return false;
        }
        return matchedIngredients == this.inputs.size();
    }

    public class_2371<class_1856> method_8117() {
        ArrayList<class_1856> allIngredients = new ArrayList<class_1856>();
        for (Map.Entry<class_1856, Integer> entry : this.inputs.entrySet()) {
            for (int i = 0; i < entry.getValue(); ++i) {
                allIngredients.add(entry.getKey());
            }
        }
        return class_2371.method_10212((Object)class_1856.field_9017, (Object[])((class_1856[])allIngredients.toArray(class_1856[]::new)));
    }

    public Map<class_1856, Integer> getIngredientsMap() {
        return this.inputs;
    }

    public class_1799 method_8116(class_1263 inventory) {
        return class_1799.field_8037;
    }

    public void consumeNeededIngredients(class_1263 inventory) {
        UnifiedInventoryView unifiedView = ((ForgeControllerBlockEntity)inventory).asUnifiedView();
        for (class_1792 item : new HashSet<class_1792>(unifiedView.getUnifiedInventory().keySet())) {
            this.inputs.forEach((input, inputCount) -> {
                if (input.method_8093(item.method_7854())) {
                    unifiedView.removeItems(item, (int)inputCount);
                }
            });
        }
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    @Deprecated
    public class_1799 method_8110() {
        return this.output.method_7972();
    }

    public class_1799 getOutput(int forgeTier) {
        return ((class_1799)this.tierOverrides.getOrDefault(this.tierOverrides.keySet().stream().filter(overrideRange -> overrideRange.test(forgeTier)).findAny().orElse(null), (Object)this.output)).method_7972();
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return AlloyForgeRecipeSerializer.INSTANCE;
    }

    public class_3956<?> method_17716() {
        return Type.INSTANCE;
    }

    public int getMinForgeTier() {
        return this.minForgeTier;
    }

    public int getFuelPerTick() {
        return this.fuelPerTick;
    }

    public ImmutableMap<OverrideRange, class_1799> getTierOverrides() {
        return this.tierOverrides;
    }

    public static class Type
    implements class_3956<AlloyForgeRecipe> {
        public static final class_2960 ID = AlloyForgery.id("forging");
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }

    public record OverrideRange(int lowerBound, int upperBound) {
        public OverrideRange(int lowerBound) {
            this(lowerBound, -1);
        }

        public boolean test(int value) {
            return value >= this.lowerBound && (this.upperBound == -1 || value <= this.upperBound);
        }

        @Override
        public String toString() {
            String outString = String.valueOf(this.lowerBound);
            List<Character> chars = outString.chars().mapToObj(value -> Character.valueOf((char)value)).collect(Collectors.toList());
            if (this.upperBound != this.lowerBound) {
                if (this.upperBound == -1) {
                    chars.add(Character.valueOf('+'));
                } else {
                    List<Character> to = " to ".chars().mapToObj(value -> Character.valueOf((char)value)).collect(Collectors.toList());
                    to.forEach(character -> chars.add((Character)character));
                    List<Character> bound = String.valueOf(this.upperBound).chars().mapToObj(value -> Character.valueOf((char)value)).collect(Collectors.toList());
                    bound.forEach(character -> chars.add((Character)character));
                }
            }
            StringBuilder output = new StringBuilder();
            chars.forEach(character -> output.append(character));
            return output.toString();
        }
    }
}

