/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.forges;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public class UnifiedInventoryView {
    private final class_1263 mainInventory;
    private final int beginIndex;
    private final int endIndex;
    private final Map<class_1792, Integer> unifiedInv = new HashMap<class_1792, Integer>();
    private boolean isDirty = false;

    public UnifiedInventoryView(class_1263 inventory) {
        this(inventory, 0, inventory.method_5439() - 1);
    }

    public UnifiedInventoryView(class_1263 inventory, int beginIndex, int endIndex) {
        this.mainInventory = inventory;
        if (beginIndex >= inventory.method_5439() || beginIndex < 0) {
            throw new IndexOutOfBoundsException("The Beginning Index is out of Bounds for the given Inventory!");
        }
        if (endIndex >= inventory.method_5439() || endIndex < 0) {
            throw new IndexOutOfBoundsException("The Ending Index is out of Bounds for the given Inventory!");
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException("The beginning index must be less than the ending index!");
        }
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.markDirty();
    }

    public Map<class_1792, Integer> getUnifiedInventory() {
        if (this.isDirty) {
            this.unifiedInv.clear();
            for (int i = this.beginIndex; i <= this.endIndex; ++i) {
                class_1799 stack = this.mainInventory.method_5438(i);
                if (stack.method_7960()) continue;
                class_1792 item = stack.method_7909();
                if (this.unifiedInv.containsKey(item)) {
                    this.unifiedInv.replace(item, this.unifiedInv.get(item) + stack.method_7947());
                    continue;
                }
                this.unifiedInv.put(item, stack.method_7947());
            }
            this.isDirty = false;
        }
        return this.unifiedInv;
    }

    public boolean removeItems(class_1792 item, int removalAmount) {
        boolean hasRemovedGivenCount = false;
        if (item != class_1802.field_8162 && this.getUnifiedInventory().containsKey(item)) {
            int currentItemCount = this.getUnifiedInventory().get(item);
            int remainder = currentItemCount - removalAmount;
            if (remainder > 0) {
                this.getUnifiedInventory().replace(item, remainder);
                int leftToRemove = removalAmount;
                for (int i = this.beginIndex; i <= this.endIndex; ++i) {
                    class_1799 stack = this.mainInventory.method_5438(i);
                    if (!stack.method_31574(item)) continue;
                    if (leftToRemove - stack.method_7947() < 0) {
                        stack.method_7939(stack.method_7947() - leftToRemove);
                        break;
                    }
                    this.mainInventory.method_5441(i);
                    leftToRemove -= stack.method_7947();
                }
                if (leftToRemove < 0) {
                    hasRemovedGivenCount = true;
                }
            } else {
                this.getUnifiedInventory().remove(item);
                for (int i = this.beginIndex; i <= this.endIndex; ++i) {
                    class_1799 stack = this.mainInventory.method_5438(i);
                    if (!stack.method_31574(item)) continue;
                    this.mainInventory.method_5441(i);
                }
                hasRemovedGivenCount = true;
            }
            this.markDirty();
        }
        return hasRemovedGivenCount;
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public boolean isUnifiedInvEmpty() {
        return this.getUnifiedInventory().isEmpty();
    }
}

