/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.forges;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.wispforest.owo.moddata.ModDataConsumer;
import io.wispforest.owo.util.TagInjector;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import wraith.alloyforgery.AlloyForgery;
import wraith.alloyforgery.ForgeControllerItem;
import wraith.alloyforgery.block.ForgeControllerBlock;
import wraith.alloyforgery.forges.ForgeDefinition;

public class ForgeRegistry {
    public static final Gson GSON = new Gson();
    private static final class_2960 MINEABLE_PICKAXE = new class_2960("mineable/pickaxe");
    private static final Map<class_2960, ForgeDefinition> FORGE_DEFINITION_REGISTRY = new HashMap<class_2960, ForgeDefinition>();
    private static final Map<class_2960, class_2248> CONTROLLER_BLOCK_REGISTRY = new HashMap<class_2960, class_2248>();
    private static final Set<class_2248> CONTROLLER_BLOCKS = new HashSet<class_2248>();
    private static final Set<class_2248> CONTROLLER_BLOCKS_VIEW = Collections.unmodifiableSet(CONTROLLER_BLOCKS);

    static void registerDefinition(class_2960 forgeDefinitionId, ForgeDefinition definition) {
        ForgeControllerBlock controllerBlock = new ForgeControllerBlock(definition);
        class_2960 controllerBlockRegistryId = AlloyForgery.id(class_2378.field_11146.method_10221((Object)definition.material()).method_12832() + "_forge_controller");
        class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)controllerBlockRegistryId, (Object)((Object)controllerBlock));
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)controllerBlockRegistryId, (Object)((Object)new ForgeControllerItem(controllerBlock, new class_1792.class_1793().method_7892((class_1761)AlloyForgery.ALLOY_FORGERY_GROUP))));
        TagInjector.inject((class_2378)class_2378.field_11146, (class_2960)MINEABLE_PICKAXE, (Object[])new class_2248[]{controllerBlock});
        ForgeRegistry.store(forgeDefinitionId, definition, controllerBlock);
    }

    public static Optional<ForgeDefinition> getForgeDefinition(class_2960 id) {
        return FORGE_DEFINITION_REGISTRY.containsKey(id) ? Optional.of(FORGE_DEFINITION_REGISTRY.get(id)) : Optional.empty();
    }

    public static Optional<class_2248> getControllerBlock(class_2960 id) {
        return FORGE_DEFINITION_REGISTRY.containsKey(id) ? Optional.of(CONTROLLER_BLOCK_REGISTRY.get(id)) : Optional.empty();
    }

    public static Set<class_2960> getForgeIds() {
        return FORGE_DEFINITION_REGISTRY.keySet();
    }

    public static List<class_2248> getControllerBlocks() {
        return CONTROLLER_BLOCK_REGISTRY.values().stream().toList();
    }

    public static Set<class_2248> controllerBlocksView() {
        return CONTROLLER_BLOCKS_VIEW;
    }

    private static void store(class_2960 id, ForgeDefinition definition, ForgeControllerBlock block) {
        FORGE_DEFINITION_REGISTRY.put(id, definition);
        CONTROLLER_BLOCK_REGISTRY.put(id, (class_2248)block);
        CONTROLLER_BLOCKS.add((class_2248)block);
    }

    public static final class Loader
    implements ModDataConsumer {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public String getDataSubdirectory() {
            return "alloy_forges";
        }

        public void acceptParsedFile(class_2960 id, JsonObject object) {
            ForgeDefinition.loadAndEnqueue(id, object);
        }
    }
}

