/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ConstDirectiveParser {
    public static List<ConstDirective> findDirectives(String string) {
        ArrayList<ConstDirective> arrayList = new ArrayList<ConstDirective>();
        for (String string2 : string.split("\\R")) {
            ConstDirectiveParser.findDirectiveInLine(string2).ifPresent(arrayList::add);
        }
        return arrayList;
    }

    public static Optional<ConstDirective> findDirectiveInLine(String string) {
        Type type;
        if (!(string.contains("const") && string.contains("=") && string.contains(";"))) {
            return Optional.empty();
        }
        if (!(string = string.trim()).startsWith("const")) {
            return Optional.empty();
        }
        if (!ConstDirectiveParser.startsWithWhitespace(string = string.substring("const".length()))) {
            return Optional.empty();
        }
        if ((string = string.trim()).startsWith("int")) {
            type = Type.INT;
            string = string.substring("int".length());
        } else if (string.startsWith("float")) {
            type = Type.FLOAT;
            string = string.substring("float".length());
        } else if (string.startsWith("vec4")) {
            type = Type.VEC4;
            string = string.substring("vec4".length());
        } else if (string.startsWith("bool")) {
            type = Type.BOOL;
            string = string.substring("bool".length());
        } else {
            return Optional.empty();
        }
        if (!ConstDirectiveParser.startsWithWhitespace(string)) {
            return Optional.empty();
        }
        int n = string.indexOf(61);
        if (n == -1) {
            return Optional.empty();
        }
        String string2 = string.substring(0, n).trim();
        if (!ConstDirectiveParser.isWord(string2)) {
            return Optional.empty();
        }
        String string3 = string.substring(n + 1);
        int n2 = string3.indexOf(59);
        if (n2 == -1) {
            return Optional.empty();
        }
        String string4 = string3.substring(0, n2).trim();
        return Optional.of(new ConstDirective(type, string2, string4));
    }

    private static boolean startsWithWhitespace(String string) {
        return !string.isEmpty() && Character.isWhitespace(string.charAt(0));
    }

    private static boolean isWord(String string) {
        if (string.isEmpty()) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (Character.isDigit(c) || Character.isAlphabetic(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    public static enum Type {
        INT,
        FLOAT,
        VEC4,
        BOOL;

    }

    public static class ConstDirective {
        private final Type type;
        private final String key;
        private final String value;

        ConstDirective(Type type, String string, String string2) {
            this.type = type;
            this.key = string;
            this.value = string2;
        }

        public Type getType() {
            return this.type;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "ConstDirective { " + this.type + " " + this.key + " = " + this.value + "; }";
        }
    }
}

