/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.block_rendering.BlockMaterialMapping;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gbuffer_overrides.matching.ProgramTable;
import net.coderbot.iris.gbuffer_overrides.matching.RenderCondition;
import net.coderbot.iris.gbuffer_overrides.matching.SpecialCondition;
import net.coderbot.iris.gbuffer_overrides.state.RenderTargetStateListener;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.AlphaTestOverride;
import net.coderbot.iris.gl.blending.AlphaTestStorage;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.layer.GbufferPrograms;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.pipeline.ClearPass;
import net.coderbot.iris.pipeline.ClearPassCreator;
import net.coderbot.iris.pipeline.CustomTextureManager;
import net.coderbot.iris.pipeline.HandRenderer;
import net.coderbot.iris.pipeline.HorizonRenderer;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.patcher.AttributeShaderTransformer;
import net.coderbot.iris.postprocess.BufferFlipper;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.CompositeRenderer;
import net.coderbot.iris.postprocess.FinalPassRenderer;
import net.coderbot.iris.rendertarget.Blaze3dRenderTargetExt;
import net.coderbot.iris.rendertarget.NativeImageBackedSingleColorTexture;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramFallbackResolver;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.loading.ProgramId;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.texture.TextureInfoCache;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.minecraft.class_1044;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_5294;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public class DeferredWorldRenderingPipeline
implements WorldRenderingPipeline,
RenderTargetStateListener {
    private final RenderTargets renderTargets;
    @Nullable
    private ShadowRenderTargets shadowRenderTargets;
    private final Supplier<ShadowRenderTargets> shadowTargetsSupplier;
    private final ProgramTable<Pass> table;
    private final ImmutableList<ClearPass> clearPassesFull;
    private final ImmutableList<ClearPass> clearPasses;
    private final GlFramebuffer baseline;
    private final CompositeRenderer prepareRenderer;
    @Nullable
    private final ShadowRenderer shadowRenderer;
    private final int shadowMapResolution;
    private final CompositeRenderer deferredRenderer;
    private final CompositeRenderer compositeRenderer;
    private final FinalPassRenderer finalPassRenderer;
    private final CustomTextureManager customTextureManager;
    private final class_1044 whitePixel;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final ImmutableSet<Integer> flippedBeforeShadow;
    private final ImmutableSet<Integer> flippedAfterPrepare;
    private final ImmutableSet<Integer> flippedAfterTranslucent;
    private final SodiumTerrainPipeline sodiumTerrainPipeline;
    private final HorizonRenderer horizonRenderer = new HorizonRenderer();
    private final float sunPathRotation;
    private final boolean shouldRenderClouds;
    private final boolean shouldRenderUnderwaterOverlay;
    private final boolean shouldRenderVignette;
    private final boolean shouldWriteRainAndSnowToDepthBuffer;
    private final boolean shouldRenderParticlesBeforeDeferred;
    private final boolean oldLighting;
    private final OptionalInt forcedShadowRenderDistanceChunks;
    private Pass current = null;
    private WorldRenderingPhase overridePhase = null;
    private WorldRenderingPhase phase = WorldRenderingPhase.NONE;
    private boolean isBeforeTranslucent;
    private InputAvailability inputs = new InputAvailability(false, false, false);
    private SpecialCondition special = null;
    private boolean isPostChain;
    private boolean isMainBound = true;
    private boolean isRenderingWorld = false;
    private boolean isRenderingFullScreenPass = false;
    boolean sodiumTerrainRendering = false;
    private boolean isRenderingShadow = false;

    public DeferredWorldRenderingPipeline(ProgramSet programSet) {
        Object object;
        Objects.requireNonNull(programSet);
        this.shouldRenderClouds = programSet.getPackDirectives().areCloudsEnabled();
        this.shouldRenderUnderwaterOverlay = programSet.getPackDirectives().underwaterOverlay();
        this.shouldRenderVignette = programSet.getPackDirectives().vignette();
        this.shouldWriteRainAndSnowToDepthBuffer = programSet.getPackDirectives().rainDepth();
        this.shouldRenderParticlesBeforeDeferred = programSet.getPackDirectives().areParticlesBeforeDeferred();
        this.oldLighting = programSet.getPackDirectives().isOldLighting();
        this.updateNotifier = new FrameUpdateNotifier();
        class_276 class_2762 = class_310.method_1551().method_1522();
        int n2 = class_2762.method_30278();
        int n3 = TextureInfoCache.INSTANCE.getInfo(n2).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(n3);
        this.renderTargets = new RenderTargets(class_2762.field_1482, class_2762.field_1481, n2, ((Blaze3dRenderTargetExt)class_2762).iris$getDepthBufferVersion(), depthBufferFormat, programSet.getPackDirectives().getRenderTargetDirectives().getRenderTargetSettings());
        this.sunPathRotation = programSet.getPackDirectives().getSunPathRotation();
        PackShadowDirectives packShadowDirectives = programSet.getPackDirectives().getShadowDirectives();
        this.forcedShadowRenderDistanceChunks = packShadowDirectives.isDistanceRenderMulExplicit() ? ((double)packShadowDirectives.getDistanceRenderMul() >= 0.0 ? OptionalInt.of(((int)(packShadowDirectives.getDistance() * packShadowDirectives.getDistanceRenderMul()) + 15) / 16) : OptionalInt.of(-1)) : OptionalInt.empty();
        BlockRenderingSettings.INSTANCE.setBlockStateIds(BlockMaterialMapping.createBlockStateIdMap(programSet.getPack().getIdMap().getBlockProperties()));
        BlockRenderingSettings.INSTANCE.setBlockTypeIds(BlockMaterialMapping.createBlockTypeMap(programSet.getPack().getIdMap().getBlockRenderTypeMap()));
        BlockRenderingSettings.INSTANCE.setEntityIds(programSet.getPack().getIdMap().getEntityIdMap());
        BlockRenderingSettings.INSTANCE.setAmbientOcclusionLevel(programSet.getPackDirectives().getAmbientOcclusionLevel());
        BlockRenderingSettings.INSTANCE.setDisableDirectionalShading(this.shouldDisableDirectionalShading());
        BlockRenderingSettings.INSTANCE.setUseSeparateAo(programSet.getPackDirectives().shouldUseSeparateAo());
        BlockRenderingSettings.INSTANCE.setUseExtendedVertexFormat(true);
        GlStateManager.glActiveTexture((int)33986);
        this.customTextureManager = new CustomTextureManager(programSet.getPackDirectives(), programSet.getPack().getCustomTextureDataMap(), programSet.getPack().getCustomNoiseTexture());
        this.whitePixel = new NativeImageBackedSingleColorTexture(255, 255, 255, 255);
        GlStateManager.glActiveTexture((int)33984);
        this.flippedBeforeShadow = ImmutableSet.of();
        BufferFlipper bufferFlipper = new BufferFlipper();
        this.centerDepthSampler = new CenterDepthSampler(programSet.getPackDirectives().getCenterDepthHalfLife());
        this.shadowMapResolution = programSet.getPackDirectives().getShadowDirectives().getResolution();
        this.shadowTargetsSupplier = () -> {
            if (this.shadowRenderTargets == null) {
                this.shadowRenderTargets = new ShadowRenderTargets(this.shadowMapResolution, new InternalTextureFormat[]{InternalTextureFormat.RGBA, InternalTextureFormat.RGBA});
            }
            return this.shadowRenderTargets;
        };
        this.prepareRenderer = new CompositeRenderer(programSet.getPackDirectives(), programSet.getPrepare(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, bufferFlipper, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap(TextureStage.PREPARE), programSet.getPackDirectives().getExplicitFlips("prepare_pre"));
        this.flippedAfterPrepare = bufferFlipper.snapshot();
        this.deferredRenderer = new CompositeRenderer(programSet.getPackDirectives(), programSet.getDeferred(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, bufferFlipper, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap(TextureStage.DEFERRED), programSet.getPackDirectives().getExplicitFlips("deferred_pre"));
        this.flippedAfterTranslucent = bufferFlipper.snapshot();
        this.compositeRenderer = new CompositeRenderer(programSet.getPackDirectives(), programSet.getComposite(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, bufferFlipper, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap(TextureStage.COMPOSITE_AND_FINAL), programSet.getPackDirectives().getExplicitFlips("composite_pre"));
        this.finalPassRenderer = new FinalPassRenderer(programSet, this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, bufferFlipper.snapshot(), this.centerDepthSampler, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap(TextureStage.COMPOSITE_AND_FINAL), this.compositeRenderer.getFlippedAtLeastOnceFinal());
        ProgramId[] programIdArray = new ProgramId[]{ProgramId.Basic, ProgramId.Textured, ProgramId.TexturedLit, ProgramId.SkyBasic, ProgramId.SkyTextured, ProgramId.SkyTextured, null, null, ProgramId.Terrain, null, null, ProgramId.Water, null, ProgramId.Clouds, ProgramId.Clouds, null, ProgramId.DamagedBlock, ProgramId.DamagedBlock, ProgramId.Block, ProgramId.Block, ProgramId.Block, ProgramId.BeaconBeam, ProgramId.BeaconBeam, ProgramId.BeaconBeam, ProgramId.Entities, ProgramId.Entities, ProgramId.Entities, null, ProgramId.ArmorGlint, ProgramId.ArmorGlint, null, ProgramId.SpiderEyes, ProgramId.SpiderEyes, ProgramId.Hand, ProgramId.Hand, ProgramId.Hand, ProgramId.HandWater, ProgramId.HandWater, ProgramId.HandWater, null, null, ProgramId.Weather, null, ProgramId.TexturedLit, ProgramId.TexturedLit, ProgramId.Shadow, ProgramId.Shadow, ProgramId.Shadow};
        if (programIdArray.length != RenderCondition.values().length * 3) {
            throw new IllegalStateException("Program ID table length mismatch");
        }
        ProgramFallbackResolver programFallbackResolver = new ProgramFallbackResolver(programSet);
        HashMap hashMap = new HashMap();
        this.table = new ProgramTable<Pass>((renderCondition, inputAvailability) -> {
            int n = inputAvailability.texture && inputAvailability.lightmap ? 2 : (inputAvailability.texture ? 1 : 0);
            ProgramId programId = programIdArray[renderCondition.ordinal() * 3 + n];
            if (programId == null) {
                programId = programIdArray[n];
            }
            return hashMap.computeIfAbsent(new Pair((Object)programId, inputAvailability), pair -> {
                ProgramSource programSource = programFallbackResolver.resolveNullable((ProgramId)((Object)((Object)((Object)pair.getFirst()))));
                if (renderCondition == RenderCondition.SHADOW) {
                    if (this.shadowRenderTargets == null) {
                        return null;
                    }
                    if (programSource == null) {
                        GlFramebuffer glFramebuffer = this.shadowRenderTargets.getFramebuffer();
                        return new Pass(null, glFramebuffer, glFramebuffer, null, BlendModeOverride.OFF, true);
                    }
                }
                if (programSource == null) {
                    return this.createDefaultPass();
                }
                return this.createPass(programSource, (InputAvailability)inputAvailability, renderCondition == RenderCondition.SHADOW);
            });
        });
        this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, programSet.getPackDirectives().getRenderTargetDirectives());
        this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, programSet.getPackDirectives().getRenderTargetDirectives());
        this.baseline = this.renderTargets.createGbufferFramebuffer((ImmutableSet<Integer>)ImmutableSet.of(), new int[]{0});
        if (this.shadowRenderTargets != null) {
            object = this.table.match(RenderCondition.SHADOW, new InputAvailability(true, true, true)).getProgram();
            boolean bl = object != null && ((Program)object).getActiveImages() > 0;
            this.shadowRenderer = new ShadowRenderer(programSet.getShadow().orElse(null), programSet.getPackDirectives(), this.shadowRenderTargets, bl);
        } else {
            this.shadowRenderer = null;
        }
        object = () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        IntFunction<ProgramSamplers> intFunction = n -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(n, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap(TextureStage.GBUFFERS_AND_SHADOW));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, object, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (class_1044)this.customTextureManager.getNormals(), (class_1044)this.customTextureManager.getSpecular(), this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        IntFunction<ProgramImages> intFunction2 = n -> {
            ProgramImages.Builder builder = ProgramImages.builder(n);
            IrisImages.addRenderTargetImages(builder, object, this.renderTargets);
            if (IrisImages.hasShadowImages(builder)) {
                IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        IntFunction<ProgramSamplers> intFunction3 = n -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(n, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap(TextureStage.GBUFFERS_AND_SHADOW));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> this.flippedAfterPrepare, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (class_1044)this.customTextureManager.getNormals(), (class_1044)this.customTextureManager.getSpecular(), this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        IntFunction<ProgramImages> intFunction4 = n -> {
            ProgramImages.Builder builder = ProgramImages.builder(n);
            IrisImages.addRenderTargetImages(builder, () -> this.flippedAfterPrepare, this.renderTargets);
            if (IrisImages.hasShadowImages(builder)) {
                IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        this.sodiumTerrainPipeline = new SodiumTerrainPipeline(this, programSet, intFunction, this.shadowRenderTargets == null ? null : intFunction3, intFunction2, intFunction4, this.renderTargets, this.flippedAfterPrepare, this.flippedAfterTranslucent, this.shadowRenderTargets != null ? this.shadowRenderTargets.getFramebuffer() : null);
    }

    private void checkWorld() {
        if (class_310.method_1551().field_1687 == null) {
            this.isRenderingWorld = false;
            this.current = null;
        }
    }

    @Override
    public boolean shouldDisableVanillaEntityShadows() {
        return this.shadowRenderer != null;
    }

    @Override
    public boolean shouldDisableDirectionalShading() {
        return !this.oldLighting;
    }

    @Override
    public boolean shouldRenderClouds() {
        return this.shouldRenderClouds;
    }

    @Override
    public boolean shouldRenderUnderwaterOverlay() {
        return this.shouldRenderUnderwaterOverlay;
    }

    @Override
    public boolean shouldRenderVignette() {
        return this.shouldRenderVignette;
    }

    @Override
    public boolean shouldWriteRainAndSnowToDepthBuffer() {
        return this.shouldWriteRainAndSnowToDepthBuffer;
    }

    @Override
    public boolean shouldRenderParticlesBeforeDeferred() {
        return this.shouldRenderParticlesBeforeDeferred;
    }

    @Override
    public float getSunPathRotation() {
        return this.sunPathRotation;
    }

    private RenderCondition getCondition(WorldRenderingPhase worldRenderingPhase) {
        if (this.isRenderingShadow) {
            return RenderCondition.SHADOW;
        }
        if (this.special != null) {
            if (this.special == SpecialCondition.BEACON_BEAM) {
                return RenderCondition.BEACON_BEAM;
            }
            if (this.special == SpecialCondition.ENTITY_EYES) {
                return RenderCondition.ENTITY_EYES;
            }
            if (this.special == SpecialCondition.GLINT) {
                return RenderCondition.GLINT;
            }
        }
        switch (worldRenderingPhase) {
            case NONE: 
            case OUTLINE: 
            case DEBUG: 
            case PARTICLES: {
                return RenderCondition.DEFAULT;
            }
            case SKY: 
            case SUNSET: 
            case CUSTOM_SKY: 
            case SUN: 
            case MOON: 
            case STARS: 
            case VOID: {
                return RenderCondition.SKY;
            }
            case TERRAIN_SOLID: 
            case TERRAIN_CUTOUT: 
            case TERRAIN_CUTOUT_MIPPED: {
                return RenderCondition.TERRAIN_OPAQUE;
            }
            case ENTITIES: {
                return RenderCondition.ENTITIES;
            }
            case BLOCK_ENTITIES: {
                return RenderCondition.BLOCK_ENTITIES;
            }
            case DESTROY: {
                return RenderCondition.DESTROY;
            }
            case HAND_SOLID: {
                return RenderCondition.HAND_OPAQUE;
            }
            case TERRAIN_TRANSLUCENT: 
            case TRIPWIRE: {
                return RenderCondition.TERRAIN_TRANSLUCENT;
            }
            case CLOUDS: {
                return RenderCondition.CLOUDS;
            }
            case RAIN_SNOW: {
                return RenderCondition.RAIN_SNOW;
            }
            case HAND_TRANSLUCENT: {
                return RenderCondition.HAND_TRANSLUCENT;
            }
            case WORLD_BORDER: {
                return RenderCondition.WORLD_BORDER;
            }
        }
        throw new IllegalStateException("Unknown render phase " + worldRenderingPhase);
    }

    private void matchPass() {
        if (!this.isRenderingWorld || this.isRenderingFullScreenPass || this.isPostChain || !this.isMainBound) {
            return;
        }
        if (this.sodiumTerrainRendering) {
            this.beginPass(this.table.match(this.getCondition(this.getPhase()), new InputAvailability(true, true, false)));
            return;
        }
        this.beginPass(this.table.match(this.getCondition(this.getPhase()), this.inputs));
    }

    public void beginPass(Pass pass) {
        if (this.current == pass) {
            return;
        }
        if (this.current != null) {
            this.current.stopUsing();
        }
        this.current = pass;
        if (pass != null) {
            pass.use();
        } else {
            Program.unbind();
        }
    }

    private Pass createDefaultPass() {
        GlFramebuffer glFramebuffer = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, new int[]{0});
        GlFramebuffer glFramebuffer2 = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, new int[]{0});
        return new Pass(null, glFramebuffer, glFramebuffer2, null, null, false);
    }

    private Pass createPass(ProgramSource programSource, InputAvailability inputAvailability, boolean bl) {
        ProgramBuilder programBuilder;
        String string;
        String string2 = AttributeShaderTransformer.patch(programSource.getVertexSource().orElseThrow(NullPointerException::new), ShaderType.VERTEX, (string = (String)programSource.getGeometrySource().orElse(null)) != null, inputAvailability);
        String string3 = AttributeShaderTransformer.patch(programSource.getFragmentSource().orElseThrow(NullPointerException::new), ShaderType.FRAGMENT, string != null, inputAvailability);
        try {
            programBuilder = ProgramBuilder.begin(programSource.getName(), string2, string, string3, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Shader compilation failed!", runtimeException);
        }
        return this.createPassInner(programBuilder, programSource.getParent().getPack().getIdMap(), programSource.getDirectives(), programSource.getParent().getPackDirectives(), inputAvailability, bl);
    }

    private Pass createPassInner(ProgramBuilder programBuilder, IdMap idMap, ProgramDirectives programDirectives, PackDirectives packDirectives, InputAvailability inputAvailability, boolean bl) {
        GlFramebuffer glFramebuffer;
        GlFramebuffer glFramebuffer2;
        CommonUniforms.addCommonUniforms(programBuilder, idMap, packDirectives, this.updateNotifier, null);
        Supplier<Object> supplier = bl ? () -> this.flippedBeforeShadow : () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(programBuilder, this.customTextureManager.getCustomTextureIdMap(textureStage));
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, supplier, this.renderTargets, false);
        IrisImages.addRenderTargetImages(programBuilder, supplier, this.renderTargets);
        IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (class_1044)this.customTextureManager.getNormals(), (class_1044)this.customTextureManager.getSpecular(), this.whitePixel, inputAvailability);
        if (!bl) {
            IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
        }
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
        if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            if (!bl) {
                this.shadowTargetsSupplier.get();
            }
            if (this.shadowRenderTargets != null) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowRenderTargets);
                IrisImages.addShadowColorImages(programBuilder, this.shadowRenderTargets);
            }
        }
        if (bl) {
            glFramebuffer = glFramebuffer2 = Objects.requireNonNull(this.shadowRenderTargets).getFramebuffer();
        } else {
            glFramebuffer2 = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, programDirectives.getDrawBuffers());
            glFramebuffer = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, programDirectives.getDrawBuffers());
        }
        programBuilder.bindAttributeLocation(11, "mc_Entity");
        programBuilder.bindAttributeLocation(12, "mc_midTexCoord");
        programBuilder.bindAttributeLocation(13, "at_tangent");
        AlphaTest alphaTest = programDirectives.getAlphaTestOverride().orElse(null);
        return new Pass(programBuilder.build(), glFramebuffer2, glFramebuffer, alphaTest, programDirectives.getBlendModeOverride(), bl);
    }

    @Override
    public void beginPostChain() {
        this.isPostChain = true;
        this.beginPass(null);
    }

    @Override
    public void endPostChain() {
        this.isPostChain = false;
    }

    @Override
    public void setIsMainBound(boolean bl) {
        this.isMainBound = bl;
        if (!this.isRenderingWorld || this.isRenderingFullScreenPass || this.isPostChain) {
            return;
        }
        if (bl) {
            this.current = null;
        } else {
            this.beginPass(null);
        }
    }

    @Override
    public void destroy() {
        BlendModeOverride.restore();
        AlphaTestOverride.restore();
        DeferredWorldRenderingPipeline.destroyPasses(this.table);
        this.compositeRenderer.destroy();
        this.deferredRenderer.destroy();
        this.finalPassRenderer.destroy();
        this.centerDepthSampler.destroy();
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
        GlStateManager._glBindFramebuffer((int)36009, (int)0);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
        class_310.method_1551().method_1522().method_1235(false);
        this.renderTargets.destroy();
        if (this.shadowRenderTargets != null) {
            this.shadowRenderTargets.destroy();
        }
        this.customTextureManager.destroy();
        this.whitePixel.method_4528();
    }

    private static void destroyPasses(ProgramTable<Pass> programTable) {
        HashSet hashSet = new HashSet();
        programTable.forEach(pass -> {
            if (pass == null) {
                return;
            }
            if (hashSet.contains(pass)) {
                return;
            }
            pass.destroy();
            hashSet.add(pass);
        });
    }

    private void prepareRenderTargets() {
        ImmutableList<ClearPass> immutableList;
        RenderSystem.activeTexture((int)33984);
        if (this.shadowRenderTargets != null) {
            this.shadowRenderTargets.getFramebuffer().bind();
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.clearDepth((double)1.0);
            RenderSystem.clear((int)16640, (boolean)false);
        }
        class_276 class_2762 = class_310.method_1551().method_1522();
        Blaze3dRenderTargetExt blaze3dRenderTargetExt = (Blaze3dRenderTargetExt)class_2762;
        int n = class_2762.method_30278();
        int n2 = TextureInfoCache.INSTANCE.getInfo(n).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(n2);
        this.renderTargets.resizeIfNeeded(blaze3dRenderTargetExt.iris$getDepthBufferVersion(), n, class_2762.field_1482, class_2762.field_1481, depthBufferFormat);
        if (this.renderTargets.isFullClearRequired()) {
            this.renderTargets.onFullClear();
            immutableList = this.clearPassesFull;
        } else {
            immutableList = this.clearPasses;
        }
        Vector3d vector3d = CapturedRenderingState.INSTANCE.getFogColor();
        Vector4f vector4f = new Vector4f((float)vector3d.x, (float)vector3d.y, (float)vector3d.z, 1.0f);
        for (ClearPass clearPass : immutableList) {
            clearPass.execute(vector4f);
        }
    }

    @Override
    public void beginHand() {
        this.renderTargets.copyPreHandDepth();
    }

    @Override
    public void beginTranslucents() {
        this.isBeforeTranslucent = false;
        this.renderTargets.copyPreTranslucentDepth();
        this.beginPass(null);
        this.isRenderingFullScreenPass = true;
        this.deferredRenderer.renderAll();
        RenderSystem.enableBlend();
        this.isRenderingFullScreenPass = false;
    }

    @Override
    public void renderShadows(LevelRendererAccessor levelRendererAccessor, class_4184 class_41842) {
        if (this.shadowRenderer != null) {
            this.isRenderingShadow = true;
            this.shadowRenderer.renderShadows(levelRendererAccessor, class_41842);
            this.beginPass(null);
            this.isRenderingShadow = false;
        }
        this.isRenderingFullScreenPass = true;
        this.prepareRenderer.renderAll();
        this.isRenderingFullScreenPass = false;
    }

    @Override
    public void addDebugText(List<String> list) {
        list.add("");
        if (this.shadowRenderer != null) {
            this.shadowRenderer.addDebugText(list);
        } else {
            list.add("[Iris] Shadow Maps: not used by shader pack");
        }
    }

    @Override
    public OptionalInt getForcedShadowRenderDistanceChunksForDisplay() {
        return this.forcedShadowRenderDistanceChunks;
    }

    @Override
    public void beginLevelRendering() {
        this.isRenderingFullScreenPass = false;
        this.isRenderingWorld = true;
        this.isBeforeTranslucent = true;
        this.isMainBound = true;
        this.isPostChain = false;
        this.phase = WorldRenderingPhase.NONE;
        this.overridePhase = null;
        HandRenderer.INSTANCE.getBufferSource().resetDrawCalls();
        this.checkWorld();
        if (!this.isRenderingWorld) {
            Iris.logger.warn("beginWorldRender was called but we are not currently rendering a world?");
            return;
        }
        if (this.current != null) {
            throw new IllegalStateException("Called beginLevelRendering but level rendering appears to still be in progress?");
        }
        this.updateNotifier.onNewFrame();
        this.prepareRenderTargets();
        this.setPhase(WorldRenderingPhase.SKY);
        class_5294.class_5401 class_54012 = class_310.method_1551().field_1687.method_28103().method_29992();
        if (class_54012 == class_5294.class_5401.field_25640) {
            RenderSystem.disableTexture();
            RenderSystem.depthMask((boolean)false);
            Vector3d vector3d = CapturedRenderingState.INSTANCE.getFogColor();
            RenderSystem.setShaderColor((float)((float)vector3d.x), (float)((float)vector3d.y), (float)((float)vector3d.z), (float)1.0f);
            this.horizonRenderer.renderHorizon(CapturedRenderingState.INSTANCE.getGbufferModelView(), CapturedRenderingState.INSTANCE.getGbufferProjection(), class_757.method_34539());
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableTexture();
        }
    }

    @Override
    public void finalizeLevelRendering() {
        this.checkWorld();
        if (!this.isRenderingWorld) {
            Iris.logger.warn("finalizeWorldRendering was called but we are not currently rendering a world?");
            return;
        }
        this.beginPass(null);
        this.isRenderingWorld = false;
        this.phase = WorldRenderingPhase.NONE;
        this.overridePhase = null;
        this.isRenderingFullScreenPass = true;
        this.centerDepthSampler.sampleCenterDepth();
        this.compositeRenderer.renderAll();
        this.finalPassRenderer.renderFinalPass();
        this.isRenderingFullScreenPass = false;
    }

    @Override
    public SodiumTerrainPipeline getSodiumTerrainPipeline() {
        return this.sodiumTerrainPipeline;
    }

    @Override
    public FrameUpdateNotifier getFrameUpdateNotifier() {
        return this.updateNotifier;
    }

    @Override
    public WorldRenderingPhase getPhase() {
        if (this.overridePhase != null) {
            return this.overridePhase;
        }
        return this.phase;
    }

    public void syncProgram() {
        this.matchPass();
    }

    @Override
    public void beginSodiumTerrainRendering() {
        this.sodiumTerrainRendering = true;
        this.syncProgram();
    }

    @Override
    public void endSodiumTerrainRendering() {
        this.sodiumTerrainRendering = false;
        this.current = null;
        this.syncProgram();
    }

    @Override
    public void setOverridePhase(WorldRenderingPhase worldRenderingPhase) {
        this.overridePhase = worldRenderingPhase;
        GbufferPrograms.runPhaseChangeNotifier();
    }

    @Override
    public void setPhase(WorldRenderingPhase worldRenderingPhase) {
        this.phase = worldRenderingPhase;
        GbufferPrograms.runPhaseChangeNotifier();
    }

    public void setInputs(InputAvailability inputAvailability) {
        this.inputs = inputAvailability;
    }

    @Override
    public void setSpecialCondition(SpecialCondition specialCondition) {
        this.special = specialCondition;
    }

    @Override
    public RenderTargetStateListener getRenderTargetStateListener() {
        return this;
    }

    private final class Pass {
        @Nullable
        private final Program program;
        private final GlFramebuffer framebufferBeforeTranslucents;
        private final GlFramebuffer framebufferAfterTranslucents;
        @Nullable
        private final AlphaTest alphaTestOverride;
        @Nullable
        private final BlendModeOverride blendModeOverride;
        private final boolean shadowViewport;

        private Pass(Program program, GlFramebuffer glFramebuffer, @Nullable GlFramebuffer glFramebuffer2, @Nullable AlphaTest alphaTest, BlendModeOverride blendModeOverride, boolean bl) {
            this.program = program;
            this.framebufferBeforeTranslucents = glFramebuffer;
            this.framebufferAfterTranslucents = glFramebuffer2;
            this.alphaTestOverride = alphaTest;
            this.blendModeOverride = blendModeOverride;
            this.shadowViewport = bl;
        }

        public void use() {
            if (DeferredWorldRenderingPipeline.this.isBeforeTranslucent) {
                this.framebufferBeforeTranslucents.bind();
            } else {
                this.framebufferAfterTranslucents.bind();
            }
            if (this.shadowViewport) {
                RenderSystem.viewport((int)0, (int)0, (int)DeferredWorldRenderingPipeline.this.shadowMapResolution, (int)DeferredWorldRenderingPipeline.this.shadowMapResolution);
            } else {
                class_276 class_2762 = class_310.method_1551().method_1522();
                RenderSystem.viewport((int)0, (int)0, (int)class_2762.field_1482, (int)class_2762.field_1481);
            }
            if (this.program != null && !DeferredWorldRenderingPipeline.this.sodiumTerrainRendering) {
                this.program.use();
            }
            if (this.alphaTestOverride != null) {
                AlphaTestStorage.overrideAlphaTest(this.alphaTestOverride);
            } else {
                AlphaTestStorage.restoreAlphaTest();
            }
            if (this.blendModeOverride != null) {
                this.blendModeOverride.apply();
            } else {
                BlendModeOverride.restore();
            }
        }

        public void stopUsing() {
            if (this.alphaTestOverride != null) {
                AlphaTestStorage.restoreAlphaTest();
            }
            if (this.blendModeOverride != null) {
                BlendModeOverride.restore();
            }
        }

        @Nullable
        public Program getProgram() {
            return this.program;
        }

        public void destroy() {
            if (this.program != null) {
                this.program.destroy();
            }
        }
    }
}

