/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.world.biome;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import org.apache.commons.lang3.mutable.MutableInt;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.overworld.BYGOverworldBiomeBuilder;
import potionstudios.byg.common.world.biome.overworld.OverworldRegion;
import potionstudios.byg.mixin.access.OverworldBiomeBuilderAccess;
import potionstudios.byg.util.BYGRegionUtils;
import potionstudios.byg.util.BYGUtil;
import terrablender.api.Region;
import terrablender.api.RegionType;

public class BYGTerraBlenderRegion
extends Region {
    private static int count = 0;
    private final Set<class_5321<class_1959>> bygKeys = new ObjectOpenHashSet();
    private final Map<class_5321<class_1959>, class_5321<class_1959>> swapper;
    private final BYGOverworldBiomeBuilder bygOverworldBiomeBuilder;

    public BYGTerraBlenderRegion(OverworldRegion overworldRegion) {
        this(overworldRegion.overworldWeight(), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.oceans().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.middleBiomes().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.middleBiomesVariant().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.plateauBiomes().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.plateauBiomesVariant().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.extremeHills().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.beachBiomes().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.peakBiomes().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.peakBiomesVariant().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.slopeBiomes().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.slopeBiomesVariant().value()), overworldRegion.swapper());
    }

    public BYGTerraBlenderRegion(int overworldWeight, class_5321<class_1959>[][] oceans, class_5321<class_1959>[][] middleBiomes, class_5321<class_1959>[][] middleBiomesVariant, class_5321<class_1959>[][] plateauBiomes, class_5321<class_1959>[][] plateauBiomesVariant, class_5321<class_1959>[][] shatteredBiomes, class_5321<class_1959>[][] beachBiomes, class_5321<class_1959>[][] peakBiomes, class_5321<class_1959>[][] peakBiomesVariant, class_5321<class_1959>[][] slopeBiomes, class_5321<class_1959>[][] slopeBiomesVariant, Map<class_5321<class_1959>, class_5321<class_1959>> swapper) {
        super(BYG.createLocation("region_" + count++), RegionType.OVERWORLD, overworldWeight);
        this.swapper = swapper;
        Predicate<class_5321<class_1959>> noVoidBiomes = biomeResourceKey -> biomeResourceKey != class_1972.field_9473;
        oceans = BYGRegionUtils.filter("oceans", this.getName(), count, oceans, noVoidBiomes, true);
        middleBiomes = BYGRegionUtils.filter("middle_biomes", this.getName(), count, middleBiomes, noVoidBiomes, true);
        middleBiomesVariant = BYGRegionUtils.filter("middle_biomes_variant", this.getName(), count, middleBiomesVariant, noVoidBiomes, false);
        plateauBiomes = BYGRegionUtils.filter("plateau_biomes", this.getName(), count, plateauBiomes, noVoidBiomes, true);
        plateauBiomesVariant = BYGRegionUtils.filter("plateau_biomes_variant", this.getName(), count, plateauBiomesVariant, noVoidBiomes, false);
        shatteredBiomes = BYGRegionUtils.filter("shattered_biomes", this.getName(), count, shatteredBiomes, noVoidBiomes, false);
        beachBiomes = BYGRegionUtils.filter("beach_biomes", this.getName(), count, beachBiomes, noVoidBiomes, true);
        peakBiomes = BYGRegionUtils.filter("peak_biomes", this.getName(), count, peakBiomes, noVoidBiomes, true);
        peakBiomesVariant = BYGRegionUtils.filter("peak_biomes_variant", this.getName(), count, peakBiomesVariant, noVoidBiomes, false);
        slopeBiomes = BYGRegionUtils.filter("slope_biomes", this.getName(), count, slopeBiomes, noVoidBiomes, true);
        slopeBiomesVariant = BYGRegionUtils.filter("slope_biomes_variant", this.getName(), count, slopeBiomesVariant, noVoidBiomes, false);
        this.bygOverworldBiomeBuilder = new BYGOverworldBiomeBuilder(oceans, middleBiomes, middleBiomesVariant, plateauBiomes, plateauBiomesVariant, shatteredBiomes, beachBiomes, peakBiomes, peakBiomesVariant, slopeBiomes, slopeBiomesVariant);
        BYGRegionUtils.dumpArrays(biomeResourceKey -> {
            if (biomeResourceKey != null) {
                this.bygKeys.add((class_5321<class_1959>)biomeResourceKey);
                if (swapper.containsValue(biomeResourceKey)) {
                    throw new IllegalArgumentException("Swapper cannot contain elements found in the temperature arrays.");
                }
            }
        }, oceans, middleBiomes, middleBiomesVariant, plateauBiomes, plateauBiomesVariant, shatteredBiomes, beachBiomes, peakBiomes);
    }

    public void addBiomes(class_2378<class_1959> registry, Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper) {
        boolean sanityCheck;
        MutableInt totalPairs = new MutableInt();
        MutableInt bygMapperAccepted = new MutableInt(0);
        ((OverworldBiomeBuilderAccess)((Object)this.bygOverworldBiomeBuilder)).byg_invokeAddBiomes(parameterPointResourceKeyPair -> {
            class_5321 biomeKey = (class_5321)parameterPointResourceKeyPair.getSecond();
            if (!registry.method_35842(biomeKey)) {
                throw new IllegalArgumentException(String.format("\"%s\" is not a valid biome in the world registry!", biomeKey.method_29177().toString()));
            }
            totalPairs.increment();
            boolean mapped = false;
            boolean alreadyMappedOutsideSwapper = false;
            if (this.bygKeys.contains(biomeKey)) {
                mapper.accept(new Pair((Object)((class_6544.class_4762)parameterPointResourceKeyPair.getFirst()), (Object)biomeKey));
                bygMapperAccepted.increment();
                alreadyMappedOutsideSwapper = true;
                mapped = true;
            }
            if (this.swapper.containsKey(biomeKey)) {
                if (alreadyMappedOutsideSwapper) {
                    throw new UnsupportedOperationException(String.format("Attempting to assign a biome resource key in both the swapper and biome selectors. We're crashing your game to let you know that \"%s\" was put in the biome selectors but will always be swapped by \"%s\" due to the swapper. In region \"%s\".", biomeKey.method_29177().toString(), this.swapper.get(biomeKey).method_29177().toString(), this.getName().toString()));
                }
                mapper.accept(new Pair((Object)((class_6544.class_4762)parameterPointResourceKeyPair.getFirst()), this.swapper.get(biomeKey)));
                bygMapperAccepted.increment();
                mapped = true;
            }
            if (!mapped) {
                mapper.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)parameterPointResourceKeyPair);
                bygMapperAccepted.increment();
            }
        });
        int totalPairsValue = totalPairs.intValue();
        int mapperAcceptValue = bygMapperAccepted.intValue();
        boolean bl = sanityCheck = totalPairsValue != mapperAcceptValue;
        if (sanityCheck) {
            throw new UnsupportedOperationException(String.format("Not all biome parameter points were accepted for BYG Terrablender biome region: %s. %s/%s were accepted.", this.getName().toString(), totalPairsValue, mapperAcceptValue));
        }
        BYG.LOGGER.info(bygMapperAccepted.getValue() + " biome parameter points were mapped for BYG region: " + this.getName().toString());
    }
}

