/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.util;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import potionstudios.byg.BYG;
import potionstudios.byg.common.block.sapling.GrowingPatterns;
import potionstudios.byg.util.BYGUtil;

public interface FeatureGrowerFromBlockPattern {
    public static final List<Supplier<? extends FeatureGrowerFromBlockPattern>> ENTRIES = new ArrayList<Supplier<? extends FeatureGrowerFromBlockPattern>>();

    public void load();

    public static void serializePatterns(class_2960 key, List<Pair<List<class_2338>, class_6005<GrowingPatterns.FeatureSpawner>>> patternsToSpawner) {
        patternsToSpawner.clear();
        Map<class_2960, List<GrowingPatterns.GrowingPatternEntry>> patterns = GrowingPatterns.getConfig().patternsForBlock();
        if (patterns.containsKey(key)) {
            ArrayList<GrowingPatterns.GrowingPatternEntry> growingPatternEntries = new ArrayList<GrowingPatterns.GrowingPatternEntry>((Collection)patterns.get(key));
            growingPatternEntries.sort(Comparator.comparingInt(p -> {
                int saplingCount = 0;
                for (String s : p.pattern()) {
                    char[] chars;
                    for (char aChar : chars = s.toCharArray()) {
                        if (aChar != 'x' && aChar != 'X') continue;
                        ++saplingCount;
                    }
                }
                return saplingCount;
            }));
            ArrayList<Pair> patternsToSpawnerMapped = new ArrayList<Pair>();
            for (GrowingPatterns.GrowingPatternEntry growingPatternEntry : growingPatternEntries) {
                List<String> pattern = growingPatternEntry.pattern();
                class_6005<GrowingPatterns.FeatureSpawner> spawner = growingPatternEntry.spawners();
                Pair newEntry = Pair.of(new ArrayList(), spawner);
                patternsToSpawnerMapped.add(newEntry);
                int patternLoopSize = Math.min(pattern.size(), 5);
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < patternLoopSize; ++i) {
                    String s = pattern.get(i);
                    String substring = s.substring(0, Math.min(s.length(), 5));
                    builder.append(substring);
                }
                String patternCombined = builder.toString();
                String trimmed = patternCombined.trim();
                if (trimmed.length() > 1) {
                    int zOffset = -patternLoopSize / 2;
                    for (int i = 0; i < patternLoopSize; ++i) {
                        char[] charArray;
                        String s = pattern.get(i);
                        int range = Math.min(s.length(), 5);
                        String substring = s.substring(0, range);
                        int xOffset = -range / 2;
                        for (char c : charArray = substring.toCharArray()) {
                            if (c == 'x' || c == 'X') {
                                ((List)newEntry.getFirst()).add(new class_2338(xOffset, 0, zOffset));
                            }
                            ++xOffset;
                        }
                        ++zOffset;
                    }
                    continue;
                }
                ((List)newEntry.getFirst()).add(new class_2338(0, 0, 0));
            }
            patternsToSpawner.addAll(patternsToSpawnerMapped);
            Collections.reverse(patternsToSpawner);
        }
    }

    public static boolean growFeature(class_2248 block, class_3218 world, class_2338 pos, class_5819 rand, List<Pair<List<class_2338>, class_6005<GrowingPatterns.FeatureSpawner>>> patternsToSpawner) {
        int range = 2;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339().method_10101((class_2382)pos);
        for (Pair<List<class_2338>, class_6005<GrowingPatterns.FeatureSpawner>> entry : patternsToSpawner) {
            for (int xMove = -range; xMove <= range; ++xMove) {
                for (int zMove = -range; zMove <= range; ++zMove) {
                    Optional configuredFeaturesOptionalRegistry;
                    boolean matchedPattern = true;
                    class_2338.class_2339 mutableBlockPos1 = new class_2338.class_2339().method_10101((class_2382)mutableBlockPos.method_10101((class_2382)pos).method_10100(xMove, 0, zMove));
                    List offsets = (List)entry.getFirst();
                    class_6005 treePicker = (class_6005)entry.getSecond();
                    for (class_2338 offset : offsets) {
                        class_2338.class_2339 movedPos = mutableBlockPos1.method_10101((class_2382)mutableBlockPos).method_30927((class_2382)offset);
                        class_2680 offsetState = world.method_8320((class_2338)movedPos);
                        if (offsetState.method_26204() == block) continue;
                        matchedPattern = false;
                        break;
                    }
                    if (!matchedPattern || !(configuredFeaturesOptionalRegistry = world.method_30349().method_30527(class_2378.field_25914)).isPresent()) continue;
                    class_2378 configuredFeaturesRegistry = (class_2378)configuredFeaturesOptionalRegistry.get();
                    Optional randomValue = treePicker.method_34973(rand);
                    if (!randomValue.isPresent()) continue;
                    GrowingPatterns.FeatureSpawner featureSpawner = (GrowingPatterns.FeatureSpawner)randomValue.get();
                    class_2975 configuredFeature = (class_2975)configuredFeaturesRegistry.method_10223(featureSpawner.spawnerID());
                    if (configuredFeature != null) {
                        class_2338 spawnOffset = featureSpawner.spawnOffset();
                        class_2338 growthPos = mutableBlockPos1.method_10081((class_2382)spawnOffset);
                        if (configuredFeature.method_12862((class_5281)world, world.method_14178().method_12129(), rand, growthPos)) {
                            for (class_2338 offset : offsets) {
                                class_2338.class_2339 movedPos = mutableBlockPos1.method_10101((class_2382)mutableBlockPos).method_30927((class_2382)offset);
                                class_2680 offsetState = world.method_8320((class_2338)movedPos);
                                if (offsetState.method_26204() != block) continue;
                                world.method_8650((class_2338)movedPos, false);
                            }
                            if (GrowingPatterns.getConfig().logGrowth()) {
                                BYG.LOGGER.info(String.format("Grower \"%s\" grew configured feature \"%s\" at position %s(growth offset: %s).", class_2378.field_11146.method_10221((Object)block).toString(), featureSpawner.toString(), growthPos, spawnOffset));
                            }
                            return true;
                        }
                        if (!GrowingPatterns.getConfig().logGrowth()) continue;
                        BYG.LOGGER.info(String.format("Grower \"%s\" couldn't grow configured feature \"%s\" at position %s(growth offset: %s).", class_2378.field_11146.method_10221((Object)block).toString(), featureSpawner.toString(), growthPos, spawnOffset));
                        continue;
                    }
                    BYG.LOGGER.error(String.format("Grower \"%s\" failed when attempting to spawn configured feature \"%s\" at position %s. \"%s\" is not a valid configured feature ID in this world's datapack configured feature registry! Valid entries:\n %s", class_2378.field_11146.method_10221((Object)block).toString(), featureSpawner, pos, featureSpawner, BYGUtil.dumpRegistry(configuredFeaturesRegistry)));
                }
            }
        }
        return false;
    }
}

