/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.mixin.common.world.level.storage.loot;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_60;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import potionstudios.byg.BYG;
import potionstudios.byg.config.SettingsConfig;
import potionstudios.byg.mixin.access.JsonReloadListenerAccess;

@Mixin(value={class_60.class})
public abstract class MixinLootTableManager
extends class_4309 {
    public MixinLootTableManager(Gson gson, String string) {
        super(gson, string);
    }

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="HEAD")})
    private void appendTables(Map<class_2960, JsonElement> values, class_3300 resourceManager, class_3695 profilerFiller, CallbackInfo ci) {
        if (!SettingsConfig.getConfig().appendLootTables()) {
            return;
        }
        String appendTablesDir = "append_loot_tables";
        Map resourceMap = resourceManager.method_14488(appendTablesDir, key -> key.toString().endsWith(".json"));
        for (class_2960 resourceLocation : resourceMap.keySet()) {
            class_2960 key2 = new class_2960(resourceLocation.method_12832().replace(appendTablesDir + "/", "").replaceFirst("/", ":").replace(".json", ""));
            if (!values.containsKey(key2)) continue;
            values.get(key2).getAsJsonObject().getAsJsonArray("pools").addAll(this.extractPools(resourceManager, resourceLocation));
        }
    }

    private JsonArray extractPools(class_3300 resourceManager, class_2960 location) {
        try {
            Optional optionalResource = resourceManager.method_14486(location);
            if (optionalResource.isPresent()) {
                class_3298 appendedTable = (class_3298)optionalResource.get();
                InputStream inputstream = appendedTable.method_14482();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                JsonElement appendedElement = (JsonElement)class_3518.method_15276((Gson)((JsonReloadListenerAccess)((Object)this)).byg_getGson(), (Reader)reader, JsonElement.class);
                return appendedElement.getAsJsonObject().getAsJsonArray("pools");
            }
        }
        catch (IOException e) {
            BYG.LOGGER.error("Could not read appended table:" + location);
            e.printStackTrace();
        }
        return new JsonArray();
    }
}

