/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.config;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import potionstudios.byg.shadow.blue.endless.jankson.api.SyntaxError;
import potionstudios.byg.util.ModPlatform;
import potionstudios.byg.util.jankson.JanksonJsonOps;
import potionstudios.byg.util.jankson.JanksonUtil;

public record ConfigVersionTracker(int configVersion) {
    public static final Codec<ConfigVersionTracker> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("version").forGetter(ConfigVersionTracker::configVersion)).apply((Applicative)builder, ConfigVersionTracker::new));
    public static ConfigVersionTracker INSTANCE = null;

    public static ConfigVersionTracker getConfig() {
        return ConfigVersionTracker.getConfig(new ConfigVersionTracker(5), false);
    }

    public static ConfigVersionTracker getConfig(ConfigVersionTracker from, boolean recreate) {
        Path resolve = ModPlatform.INSTANCE.configPath().resolve("config_versions.json5");
        if (!resolve.toFile().exists() || recreate) {
            JanksonUtil.createConfig(resolve, CODEC, "/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n*/", (Map<String, String>)ImmutableMap.of(), JanksonJsonOps.INSTANCE, from);
        }
        try {
            INSTANCE = JanksonUtil.readConfig(resolve, CODEC, JanksonJsonOps.INSTANCE);
        }
        catch (IOException | SyntaxError e) {
            e.printStackTrace();
        }
        return INSTANCE;
    }
}

