/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_156;
import potionstudios.byg.BYG;
import potionstudios.byg.shadow.blue.endless.jankson.api.SyntaxError;
import potionstudios.byg.util.ModPlatform;
import potionstudios.byg.util.jankson.JanksonJsonOps;
import potionstudios.byg.util.jankson.JanksonUtil;

public record BiomepediaConfig(boolean biomepediaEnabled) {
    public static final Codec<BiomepediaConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("inventory_enabled").forGetter(BiomepediaConfig::biomepediaEnabled)).apply((Applicative)builder, BiomepediaConfig::new));
    public static final BiomepediaConfig DEFAULT = new BiomepediaConfig(true);
    public static BiomepediaConfig INSTANCE = null;

    public static BiomepediaConfig getConfig() {
        return BiomepediaConfig.getConfig(false, false);
    }

    public static BiomepediaConfig getConfig(boolean serialize) {
        return BiomepediaConfig.getConfig(serialize, false);
    }

    public static BiomepediaConfig getConfig(boolean serialize, boolean recreate) {
        if (INSTANCE == null || serialize || recreate) {
            INSTANCE = BiomepediaConfig.readConfig(recreate);
        }
        return INSTANCE;
    }

    private static BiomepediaConfig readConfig(boolean recreate) {
        Path path = ModPlatform.INSTANCE.configPath().resolve("biomepedia.json5");
        if (!path.toFile().exists() || recreate) {
            JanksonUtil.createConfig(path, CODEC, "/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n*/", (Map)class_156.method_654(new HashMap(), map -> map.put("inventory_enabled", "Whether the biomepedia button is enabled or not in the player inventory for all users connected to this host.")), JanksonJsonOps.INSTANCE, DEFAULT);
        }
        BYG.LOGGER.info(String.format("\"%s\" was read.", path.toString()));
        try {
            return JanksonUtil.readConfig(path, CODEC, JanksonJsonOps.INSTANCE);
        }
        catch (IOException | SyntaxError e) {
            throw new RuntimeException(e);
        }
    }
}

