/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.structure.arch;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_6862;
import net.minecraft.class_7138;
import net.minecraft.class_7151;
import potionstudios.byg.common.world.structure.BYGStructureTypes;
import potionstudios.byg.common.world.structure.arch.ArchConfiguration;
import potionstudios.byg.common.world.structure.arch.ArchPiece;
import potionstudios.byg.util.blendingfunction.BlendingFunction;

public class ArchStructure
extends class_3195 {
    public static final Codec<ArchStructure> CODEC = RecordCodecBuilder.mapCodec(archStructureInstance -> archStructureInstance.group((App)ArchStructure.method_42697((RecordCodecBuilder.Instance)archStructureInstance), (App)ArchConfiguration.CODEC.fieldOf("settings").forGetter(p_227656_ -> p_227656_.archConfiguration)).apply((Applicative)archStructureInstance, ArchStructure::new)).codec();
    public static final int PIECE_BB_EXPANSION = 5;
    private final ArchConfiguration archConfiguration;

    public ArchStructure(class_3195.class_7302 structureSettings, ArchConfiguration archConfiguration) {
        super(structureSettings);
        this.archConfiguration = archConfiguration;
    }

    private static void generatePieces(class_6626 piecesBuilder, class_3195.class_7149 context, ArchConfiguration config) {
        Long2ObjectOpenHashMap newSortedPositions;
        class_2919 random = context.comp_566();
        class_7138 randomState = context.comp_564();
        double fullRange = Math.PI * 2;
        double ninetyDegrees = fullRange / 4.0;
        double angle = random.method_43058() * fullRange;
        class_1923 chunkPos = context.comp_568();
        int blockX = chunkPos.method_33939(random.method_43048(16));
        int blockZ = chunkPos.method_33941(random.method_43048(16));
        class_2794 generator = context.comp_562();
        int length = config.length().method_35008((class_5819)random) / 2;
        int archHeight = config.height().method_35008((class_5819)random);
        class_2338 center = new class_2338(blockX, generator.method_16397(blockX, blockZ, class_2902.class_2903.field_13195, context.comp_569(), randomState) + archHeight, blockZ);
        double xOffset = Math.sin(angle) * (double)length;
        double zOffset = Math.cos(angle) * (double)length;
        Long2ObjectOpenHashMap chunkSortedPositions = new Long2ObjectOpenHashMap();
        float percentageDestroyed = 1.0f - config.percentageDestroyed().method_33920((class_5819)random);
        float percentageDestroyed2 = 1.0f - config.percentageDestroyed().method_33920((class_5819)random);
        class_2338 start = center.method_10080(-xOffset, 0.0, -zOffset);
        start = new class_2338(start.method_10263(), generator.method_16397(start.method_10263(), start.method_10260(), class_2902.class_2903.field_13195, context.comp_569(), randomState) - 5, start.method_10260());
        class_2338 end = center.method_10080(xOffset, 0.0, zOffset);
        end = new class_2338(end.method_10263(), generator.method_16397(end.method_10263(), end.method_10260(), class_2902.class_2903.field_13195, context.comp_569(), randomState) - 5, end.method_10260());
        int points = 1000;
        if (!(config.biomeEnforcement() == ArchConfiguration.EMPTY || ArchStructure.matchesBiome(start, generator, config.biomeEnforcement(), randomState) && ArchStructure.matchesBiome(end, generator, config.biomeEnforcement(), randomState))) {
            return;
        }
        BlendingFunction blendingFunction = (BlendingFunction)config.blendingFunction().method_34973((class_5819)random).orElseThrow();
        BlendingFunction blendingFunction2 = random.method_43057() < config.matchingBlendingFunctionChance().method_33920((class_5819)random) ? blendingFunction : (BlendingFunction)config.blendingFunction().method_34973((class_5819)random).orElseThrow();
        class_2338 startToCenterLastPos = null;
        class_2338 endToCenterLastPos = null;
        for (int pointCount = points; pointCount >= 1; --pointCount) {
            double factor = (double)pointCount / (double)points;
            int squareDistance = 2;
            class_2338 startToCenterLerpPos = new class_2338(class_3532.method_16436((double)factor, (double)start.method_10263(), (double)center.method_10263()), blendingFunction.apply(factor, start.method_10264(), center.method_10264()), class_3532.method_16436((double)factor, (double)start.method_10260(), (double)center.method_10260()));
            if (startToCenterLastPos == null || startToCenterLastPos.method_10262((class_2382)startToCenterLerpPos) > (double)squareDistance) {
                if (factor > (double)percentageDestroyed) {
                    startToCenterLerpPos = new class_2338(startToCenterLerpPos.method_10263(), Integer.MIN_VALUE, startToCenterLerpPos.method_10260());
                } else {
                    startToCenterLastPos = startToCenterLerpPos;
                }
                long chunkKey = class_1923.method_8331((int)class_4076.method_18675((int)startToCenterLerpPos.method_10263()), (int)class_4076.method_18675((int)startToCenterLerpPos.method_10260()));
                ((Set)chunkSortedPositions.computeIfAbsent(chunkKey, key -> new HashSet())).add(startToCenterLerpPos);
            }
            class_2338 centerToEndLerpPos = new class_2338(class_3532.method_16436((double)factor, (double)end.method_10263(), (double)center.method_10263()), blendingFunction2.apply(factor, end.method_10264(), center.method_10264()), class_3532.method_16436((double)factor, (double)end.method_10260(), (double)center.method_10260()));
            if (endToCenterLastPos != null && !(endToCenterLastPos.method_10262((class_2382)centerToEndLerpPos) > (double)squareDistance)) continue;
            if (factor > (double)percentageDestroyed2) {
                centerToEndLerpPos = new class_2338(centerToEndLerpPos.method_10263(), Integer.MIN_VALUE, centerToEndLerpPos.method_10260());
            } else {
                endToCenterLastPos = centerToEndLerpPos;
            }
            long centerToEndChunkKey = class_1923.method_8331((int)class_4076.method_18675((int)centerToEndLerpPos.method_10263()), (int)class_4076.method_18675((int)centerToEndLerpPos.method_10260()));
            ((Set)chunkSortedPositions.computeIfAbsent(centerToEndChunkKey, key -> new HashSet())).add(centerToEndLerpPos);
        }
        int width = config.width().method_35008((class_5819)random);
        double totalThicknessPoints = (double)width / 3.0;
        if (totalThicknessPoints > 1.0) {
            newSortedPositions = new Long2ObjectOpenHashMap(chunkSortedPositions.size() * (int)totalThicknessPoints);
            ObjectCollection capture = chunkSortedPositions.values();
            double wideXOffset = Math.sin(angle + ninetyDegrees);
            double wideZOffset = Math.cos(angle + ninetyDegrees);
            double widthXOffset = wideXOffset * (double)width;
            double widthZOffset = wideZOffset * (double)width;
            for (Set value : capture) {
                for (class_2338 pos : value) {
                    class_2338 start2 = pos.method_10080(-widthXOffset, 0.0, -widthZOffset);
                    class_2338 end2 = pos.method_10080(widthXOffset, 0.0, widthZOffset);
                    for (int thickness = (int)totalThicknessPoints; thickness >= 1; --thickness) {
                        double factor = (double)thickness / totalThicknessPoints;
                        class_2338 startToCenterLerpPos = new class_2338(class_3532.method_16436((double)factor, (double)start2.method_10263(), (double)pos.method_10263()), (double)pos.method_10264(), class_3532.method_16436((double)factor, (double)start2.method_10260(), (double)pos.method_10260()));
                        startToCenterLerpPos = new class_2338(startToCenterLerpPos.method_10263(), pos.method_10264(), startToCenterLerpPos.method_10260());
                        long chunkKey = class_1923.method_8331((int)class_4076.method_18675((int)startToCenterLerpPos.method_10263()), (int)class_4076.method_18675((int)startToCenterLerpPos.method_10260()));
                        ((Set)newSortedPositions.computeIfAbsent(chunkKey, key -> new HashSet())).add(startToCenterLerpPos);
                        class_2338 centerToEndLerpPos = new class_2338(class_3532.method_16436((double)factor, (double)end2.method_10263(), (double)pos.method_10263()), (double)pos.method_10264(), class_3532.method_16436((double)factor, (double)end2.method_10260(), (double)pos.method_10260()));
                        centerToEndLerpPos = new class_2338(centerToEndLerpPos.method_10263(), pos.method_10264(), centerToEndLerpPos.method_10260());
                        long centerToEndChunkKey = class_1923.method_8331((int)class_4076.method_18675((int)centerToEndLerpPos.method_10263()), (int)class_4076.method_18675((int)centerToEndLerpPos.method_10260()));
                        ((Set)newSortedPositions.computeIfAbsent(centerToEndChunkKey, key -> new HashSet())).add(centerToEndLerpPos);
                    }
                }
            }
        } else {
            newSortedPositions = chunkSortedPositions;
        }
        newSortedPositions.forEach((offsetChunkPos, set) -> {
            class_1923 movingChunkPos = new class_1923(offsetChunkPos.longValue());
            piecesBuilder.method_35462((class_3443)new ArchPiece((Set<class_2338>)set, config.sphereConfig(), 0, ArchStructure.getWritableArea(movingChunkPos, context.comp_569())));
        });
    }

    public static class_3341 getWritableArea(class_1923 chunkPos, class_5539 accessor) {
        int i = chunkPos.method_8326();
        int j = chunkPos.method_8328();
        int k = accessor.method_31607() + 1;
        int l = accessor.method_31600() - 1;
        return new class_3341(i, k, j, i + 15, l, j + 15);
    }

    private static boolean matchesBiome(class_2338 pos, class_2794 generator, class_6862<class_1959> biomeTagKey, class_7138 randomState) {
        return generator.method_12098().method_38109(class_5742.method_33100((int)pos.method_10263()), class_5742.method_33100((int)pos.method_10264()), class_5742.method_33100((int)pos.method_10260()), randomState.method_42371()).method_40220(biomeTagKey);
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 generationContext) {
        return ArchStructure.method_41612((class_3195.class_7149)generationContext, (class_2902.class_2903)class_2902.class_2903.field_13194, piecesBuilder -> ArchStructure.generatePieces(piecesBuilder, generationContext, this.archConfiguration));
    }

    public class_7151<?> method_41618() {
        return BYGStructureTypes.ARCH.get();
    }
}

