/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.overworld.trees.structure;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2465;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3746;
import net.minecraft.class_4651;
import net.minecraft.class_4662;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.jetbrains.annotations.NotNull;
import potionstudios.byg.common.world.feature.gen.overworld.trees.structure.TreeFromStructureNBTConfig;
import potionstudios.byg.common.world.feature.gen.overworld.trees.util.BYGAbstractTreeFeature;
import potionstudios.byg.mixin.access.LeavesBlockAccess;
import potionstudios.byg.mixin.access.StructureTemplateAccess;

public class TreeFromStructureNBTFeature
extends class_3031<TreeFromStructureNBTConfig> {
    public static final class_2350[] DIRECTIONS = (class_2350[])Arrays.stream(class_2350.values()).filter(direction -> direction != class_2350.field_11036).toArray(class_2350[]::new);
    public static final class_2350[] VINE_GEN_DIRECTIONS = (class_2350[])Arrays.stream(class_2350.values()).filter(direction -> direction != class_2350.field_11033).toArray(class_2350[]::new);
    private static final boolean DEBUG = false;

    public TreeFromStructureNBTFeature(Codec<TreeFromStructureNBTConfig> $$0) {
        super($$0);
    }

    public boolean method_13151(class_5821<TreeFromStructureNBTConfig> featurePlaceContext) {
        class_2338 pos2;
        TreeFromStructureNBTConfig config = (TreeFromStructureNBTConfig)featurePlaceContext.method_33656();
        class_4651 logProvider = config.logProvider();
        class_4651 leavesProvider = config.leavesProvider();
        class_5281 level = featurePlaceContext.method_33652();
        class_3485 templateManager = level.method_8410().method_14183();
        class_2960 baseLocation = config.baseLocation();
        Optional baseTemplateOptional = templateManager.method_15094(baseLocation);
        class_2960 canopyLocation = config.canopyLocation();
        Optional canopyTemplateOptional = templateManager.method_15094(canopyLocation);
        if (baseTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeature.noTreePartPresent(baseLocation);
        }
        if (canopyTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeature.noTreePartPresent(canopyLocation);
        }
        class_3499 baseTemplate = (class_3499)baseTemplateOptional.get();
        class_3499 canopyTemplate = (class_3499)canopyTemplateOptional.get();
        List<class_3499.class_5162> basePalettes = ((StructureTemplateAccess)baseTemplate).byg_getPalettes();
        List<class_3499.class_5162> canopyPalettes = ((StructureTemplateAccess)canopyTemplate).byg_getPalettes();
        class_2338 origin = featurePlaceContext.method_33655();
        class_5819 random = featurePlaceContext.method_33654();
        class_3492 placeSettings = new class_3492().method_15123(class_2470.method_16548((class_5819)random));
        class_3499.class_5162 randomBasePalette = placeSettings.method_15121(basePalettes, origin);
        class_3499.class_5162 randomCanopyPalette = placeSettings.method_15121(canopyPalettes, origin);
        List center = randomBasePalette.method_27126(class_2246.field_10446);
        if (center.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one central position.");
        }
        class_2338 centerOffset = ((class_3499.class_3501)center.get((int)0)).field_15597;
        centerOffset = new class_2338(-centerOffset.method_10263(), 0, -centerOffset.method_10260());
        List leaves = randomCanopyPalette.method_27126(config.leavesTarget());
        List canopyLogs = randomCanopyPalette.method_27126(config.logTarget());
        List logs = randomBasePalette.method_27126(config.logTarget());
        List logBuilders = randomBasePalette.method_27126(class_2246.field_10314);
        if (logBuilders.isEmpty()) {
            throw new UnsupportedOperationException(String.format("\"%s\" is missing log builders.", baseLocation));
        }
        HashSet leavePositions = new HashSet();
        HashSet<class_2338> trunkPositions = new HashSet<class_2338>();
        List trunkAnchor = randomBasePalette.method_27126(class_2246.field_10490);
        int trunkLength = config.height().method_35008(random);
        int maxTrunkBuildingDepth = config.maxLogDepth();
        for (class_3499.class_3501 logBuilder : logBuilders) {
            pos2 = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            if (TreeFromStructureNBTFeature.isOnGround(config.maxLogDepth(), level, pos2)) continue;
            return false;
        }
        block1: for (class_3499.class_3501 logBuilder : logBuilders) {
            pos2 = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339().method_10101((class_2382)pos2);
            for (int i = 0; i < maxTrunkBuildingDepth; ++i) {
                class_2680 blockState = level.method_8320((class_2338)mutableBlockPos);
                if (blockState.method_26225()) {
                    class_2248 block = blockState.method_26204();
                    if (!BYGAbstractTreeFeature.SPREADABLE_TO_NON_SPREADABLE.containsKey(block)) continue block1;
                    level.method_8652((class_2338)mutableBlockPos, BYGAbstractTreeFeature.SPREADABLE_TO_NON_SPREADABLE.get(block).method_9564(), 2);
                    continue block1;
                }
                level.method_8652((class_2338)mutableBlockPos, logProvider.method_23455(featurePlaceContext.method_33654(), (class_2338)mutableBlockPos), 2);
                mutableBlockPos.method_10098(class_2350.field_11033);
            }
        }
        for (Object trunk : logs) {
            pos2 = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, (class_3499.class_3501)trunk, centerOffset, origin);
            level.method_8652(pos2, this.getTransformedState(logProvider.method_23455(random, pos2), ((class_3499.class_3501)trunk).field_15596, placeSettings.method_15113()), 2);
            trunkPositions.add(pos2);
        }
        int trunkY = 0;
        for (class_3499.class_3501 trunk : trunkAnchor) {
            trunkY = trunk.field_15597.method_10264();
            class_2338 pos3 = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, trunk, centerOffset, origin);
            class_2338.class_2339 mutable = new class_2338.class_2339().method_10101((class_2382)pos3);
            for (int i = 0; i <= trunkLength; ++i) {
                level.method_8652((class_2338)mutable, logProvider.method_23455(random, (class_2338)mutable), 2);
                mutable.method_10098(class_2350.field_11036);
                trunkPositions.add(mutable.method_10062());
            }
        }
        List canopyAnchor = randomCanopyPalette.method_27126(class_2246.field_10446);
        if (center.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one central position.");
        }
        if (center.isEmpty()) {
            throw new IllegalArgumentException("Canopy is missing anchor block (yellow wool).");
        }
        class_3499.class_3501 structureBlockInfo = (class_3499.class_3501)canopyAnchor.get(0);
        class_2338 canopyCenterOffset = structureBlockInfo.field_15597;
        canopyCenterOffset = new class_2338(-canopyCenterOffset.method_10263(), trunkY - canopyCenterOffset.method_10264() + trunkLength, -canopyCenterOffset.method_10260());
        for (class_3499.class_3501 canopyLog : canopyLogs) {
            class_2338 pos4 = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, canopyLog, canopyCenterOffset, origin);
            level.method_8652(pos4, this.getTransformedState(logProvider.method_23455(random, pos4), canopyLog.field_15596, placeSettings.method_15113()), 2);
        }
        ArrayList<Runnable> leavesPostApply = new ArrayList<Runnable>(leaves.size());
        for (class_3499.class_3501 leaf : leaves) {
            class_2338 pos5 = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, leaf, canopyCenterOffset, origin);
            class_2680 state2 = leavesProvider.method_23455(random, pos5);
            if (level.method_8320(pos5).method_26225()) continue;
            level.method_8652(pos5, state2, 2);
            Runnable postProcess = () -> {
                class_2680 blockState = LeavesBlockAccess.byg_invokeUpdateDistance(state2, (class_1936)level, pos5);
                if ((Integer)blockState.method_11654((class_2769)class_2397.field_11199) < 7) {
                    leavePositions.add(pos5);
                    level.method_8652(pos5, blockState, 2);
                    level.method_39279(pos5, blockState.method_26204(), 0);
                } else {
                    level.method_8650(pos5, false);
                }
            };
            leavesPostApply.add(postProcess);
        }
        leavesPostApply.forEach(Runnable::run);
        for (class_4662 treeDecorator : config.treeDecorators()) {
            treeDecorator.method_23469(new class_4662.class_7402((class_3746)level, (pos, state) -> level.method_8652(pos, state, 2), random, trunkPositions, leavePositions, new HashSet()));
        }
        return true;
    }

    @NotNull
    private class_2680 getTransformedState(class_2680 state, class_2680 canopyLogState, class_2470 rotation) {
        class_2350.class_2351 axis;
        for (class_2769 property : state.method_28501()) {
            if (!canopyLogState.method_28498(property)) continue;
            Comparable value = canopyLogState.method_11654(property);
            state = (class_2680)state.method_11657(property, value);
        }
        if (state.method_28498((class_2769)class_2465.field_11459) && (axis = (class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)).method_10179() && (rotation == class_2470.field_11463 || rotation == class_2470.field_11465)) {
            if (axis == class_2350.class_2351.field_11048) {
                state = (class_2680)state.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11051);
            } else if (axis == class_2350.class_2351.field_11051) {
                state = (class_2680)state.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048);
            }
        }
        return state;
    }

    private static boolean isOnGround(int maxLogDepth, class_5281 level, class_2338 pos) {
        int oceanFloorHeight = level.method_8624(class_2902.class_2903.field_13195, pos.method_10263(), pos.method_10260());
        if (pos.method_10264() > oceanFloorHeight) {
            return pos.method_10264() - oceanFloorHeight < maxLogDepth;
        }
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339().method_10101((class_2382)pos);
        for (int logDepth = 0; logDepth < maxLogDepth; ++logDepth) {
            mutableBlockPos.method_10098(class_2350.field_11033);
            class_2680 blockState = level.method_8320((class_2338)mutableBlockPos);
            if (blockState.method_26207().method_15800()) continue;
            return true;
        }
        return false;
    }

    private static class_2338 getModifiedPos(class_3492 settings, class_3499.class_3501 placing, class_2338 partCenter, class_2338 featureOrigin) {
        return class_3499.method_15171((class_3492)settings, (class_2338)placing.field_15597).method_10081((class_2382)featureOrigin).method_10081((class_2382)class_3499.method_15171((class_3492)settings, (class_2338)partCenter));
    }

    public static IllegalArgumentException noTreePartPresent(class_2960 location) {
        throw new IllegalArgumentException(String.format("\"%s\" is not a valid tree part.", location));
    }
}

