/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome.nether;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6780;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.LayersBiomeData;
import potionstudios.byg.common.world.biome.LazyLoadSeed;
import potionstudios.byg.common.world.biome.nether.NetherBiomesConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.lite.FastNoiseLite;
import potionstudios.byg.util.BYGUtil;

public abstract class BYGNetherBiomeSource
extends class_1966
implements LazyLoadSeed {
    public static final class_2960 LOCATION = BYG.createLocation("nether");
    private FastNoiseLite lowerLayerRoughnessNoise;
    private FastNoiseLite upperLayerRoughnessNoise;
    private final class_2378<class_1959> biomeRegistry;
    private class_6780 upperBiomeResolver;
    private class_6780 middleBiomeResolver;
    private class_6780 bottomResolver;
    private final int bottomTopY;

    protected BYGNetherBiomeSource(class_2378<class_1959> biomeRegistry) {
        super(BYGNetherBiomeSource.getPossibleBiomes(biomeRegistry));
        this.biomeRegistry = biomeRegistry;
        NetherBiomesConfig config = NetherBiomesConfig.getConfig();
        Set possibleBiomes = this.method_28443().stream().map(class_6880::method_40230).map(Optional::orElseThrow).collect(Collectors.toSet());
        BiPredicate<Collection, class_5321> filter = (existing, added) -> !existing.contains(added) && possibleBiomes.contains(added);
        int usedLayerSize = config.layerSize();
        this.bottomTopY = class_5742.method_33100((int)usedLayerSize);
    }

    @Override
    public void lazyLoad(long seed) {
        NetherBiomesConfig config = NetherBiomesConfig.getConfig();
        Set possibleBiomes = this.method_28443().stream().map(class_6880::method_40230).map(Optional::orElseThrow).collect(Collectors.toSet());
        BiPredicate<Collection<class_5321<class_1959>>, class_5321<class_1959>> filter = (existing, added) -> !existing.contains(added) && possibleBiomes.contains(added);
        this.lowerLayerRoughnessNoise = new FastNoiseLite((int)seed);
        this.lowerLayerRoughnessNoise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
        this.lowerLayerRoughnessNoise.SetFrequency(0.005f);
        this.upperLayerRoughnessNoise = new FastNoiseLite((int)seed + 43594389);
        this.upperLayerRoughnessNoise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
        this.upperLayerRoughnessNoise.SetFrequency(0.005f);
        this.upperBiomeResolver = this.getUpperBiomeResolver(this.biomeRegistry, seed, config.upperLayer().filter(filter));
        this.middleBiomeResolver = this.getMiddleBiomeResolver(this.biomeRegistry, seed, config.middleLayer().filter(filter));
        this.bottomResolver = this.getLowerBiomeResolver(this.biomeRegistry, seed, config.bottomLayer().filter(filter));
    }

    public abstract class_6780 getUpperBiomeResolver(class_2378<class_1959> var1, long var2, LayersBiomeData var4);

    public abstract class_6780 getMiddleBiomeResolver(class_2378<class_1959> var1, long var2, LayersBiomeData var4);

    public abstract class_6780 getLowerBiomeResolver(class_2378<class_1959> var1, long var2, LayersBiomeData var4);

    public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 sampler) {
        if ((float)y < (float)this.bottomTopY + this.lowerLayerRoughnessNoise.GetNoise(x, z) * 5.0f) {
            return this.bottomResolver.method_38109(x, y, z, sampler);
        }
        if ((float)y > (float)(this.bottomTopY + this.bottomTopY) + this.upperLayerRoughnessNoise.GetNoise(x, z) * 5.0f) {
            return this.upperBiomeResolver.method_38109(x, y, z, sampler);
        }
        return this.middleBiomeResolver.method_38109(x, y, z, sampler);
    }

    protected class_2378<class_1959> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    @NotNull
    private static List<class_6880<class_1959>> getPossibleBiomes(class_2378<class_1959> biomeRegistry) {
        NetherBiomesConfig config = NetherBiomesConfig.getConfig(false, false, biomeRegistry);
        TreeSet<String> missingBiomes = new TreeSet<String>();
        BiPredicate<Collection<class_5321<class_1959>>, class_5321<class_1959>> filter = (existing, added) -> {
            boolean biomeRegistryHas = biomeRegistry.method_35842(added);
            if (!biomeRegistryHas) {
                missingBiomes.add(added.method_29177().toString());
            }
            return !existing.contains(added) && biomeRegistryHas;
        };
        LayersBiomeData upperLayer = config.upperLayer().filter(filter);
        LayersBiomeData middleLayer = config.middleLayer().filter(filter);
        LayersBiomeData bottomLayer = config.bottomLayer().filter(filter);
        String ignored = BYGUtil.dumpCollection(missingBiomes);
        if (!ignored.isEmpty()) {
            BYG.LOGGER.warn(String.format("Config \"%s\" warned:\nThe following biome entries were ignored due to not being in this world's biome registry:\n%s", NetherBiomesConfig.CONFIG_PATH.get(), ignored.toString()));
        }
        return BYGUtil.createBiomesFromBiomeData(biomeRegistry, upperLayer, middleLayer, bottomLayer);
    }
}

