/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.block;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1822;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_6862;
import potionstudios.byg.BYG;
import potionstudios.byg.common.block.BYGBlockProperties;
import potionstudios.byg.common.block.BYGBlockTags;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.entity.boat.BYGBoat;
import potionstudios.byg.common.item.BYGBoatItem;
import potionstudios.byg.common.item.BYGCreativeTab;
import potionstudios.byg.common.item.BYGItems;
import potionstudios.byg.mixin.access.WoodTypeAccess;
import potionstudios.byg.reg.BlockRegistryObject;
import potionstudios.byg.reg.RegistryObject;
import potionstudios.byg.util.MultiTag;

public enum BYGWoodTypes {
    ASPEN("aspen", new Builder().boatType(BYGBoat.BYGType.ASPEN).materialColor(class_3620.field_16013).growerItemGroundTag(BYGBlockTags.GROUND_ASPEN_SAPLING)),
    BAOBAB("baobab", new Builder().boatType(BYGBoat.BYGType.BAOBAB).growerItemGroundTag(BYGBlockTags.GROUND_BAOBAB_SAPLING).materialColor(class_3620.field_16028)),
    BLUE_ENCHANTED("blue_enchanted", new Builder().boatType(BYGBoat.BYGType.BLUE_ENCHANTED).growerItemGroundTag(BYGBlockTags.GROUND_BLUE_ENCHANTED_SAPLING).materialColor(class_3620.field_15984).leavesLightLevel(15)),
    BULBIS("bulbis", new Builder().materialColor(class_3620.field_15984).growerItemGroundTag(BYGBlockTags.GROUND_BULBIS_ODDITY).growerItem(GrowerItemType.ODDITY).exclude(BlockType.LEAVES).registryName(BlockType.WOOD, "%s_wood").registryName(BlockType.STRIPPED_WOOD, "stripped_%s_wood").nether()),
    CHERRY("cherry", new Builder().exclude(BlockType.SAPLING, BlockType.LEAVES).boatType(BYGBoat.BYGType.CHERRY)),
    CIKA("cika", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_CIKA_SAPLING).boatType(BYGBoat.BYGType.CIKA).materialColor(class_3620.field_15981)),
    CYPRESS("cypress", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_CYPRESS_SAPLING).boatType(BYGBoat.BYGType.CYPRESS).materialColor(class_3620.field_16018)),
    EBONY("ebony", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_EBONY_SAPLING).boatType(BYGBoat.BYGType.EBONY).materialColor(class_3620.field_15995)),
    ETHER("ether", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_ETHER_SAPLING).materialColor(class_3620.field_16026)),
    FIR("fir", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_FIR_SAPLING).materialColor(class_3620.field_15995).boatType(BYGBoat.BYGType.FIR)),
    GREEN_ENCHANTED("green_enchanted", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_GREEN_ENCHANTED_SAPLING).boatType(BYGBoat.BYGType.GREEN_ENCHANTED).materialColor(class_3620.field_15995).leavesLightLevel(15)),
    HOLLY("holly", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_HOLLY_SAPLING).materialColor(class_3620.field_16028).boatType(BYGBoat.BYGType.HOLLY)),
    IMPARIUS("imparius", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_IMPARIUS_MUSHROOM).exclude(BlockType.LEAVES, BlockType.STRIPPED_LOG, BlockType.STRIPPED_WOOD).growerItem(GrowerItemType.MUSHROOM).nether()),
    MAHOGANY("mahogany", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_MANGROVE_SAPLING).boatType(BYGBoat.BYGType.MAHOGANY).materialColor(class_3620.field_15995).leavesHaveOverlay()),
    WHITE_MANGROVE("white_mangrove", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_MANGROVE_SAPLING).boatType(BYGBoat.BYGType.MANGROVE).materialColor(class_3620.field_15995)),
    PALM("palm", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_PALM_SAPLING).boatType(BYGBoat.BYGType.PALM).materialColor(class_3620.field_15995)),
    PINE("pine", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_PINE_SAPLING).boatType(BYGBoat.BYGType.PINE).materialColor(class_3620.field_16028)),
    RAINBOW_EUCALYPTUS("rainbow_eucalyptus", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_RAINBOW_EUCALYPTUS_SAPLING).boatType(BYGBoat.BYGType.RAINBOW_EUCALYPTUS).materialColor(class_3620.field_15995)),
    REDWOOD("redwood", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_REDWOOD_SAPLING).boatType(BYGBoat.BYGType.REDWOOD).materialColor(class_3620.field_15995)),
    WILLOW("willow", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_WILLOW_SAPLING).boatType(BYGBoat.BYGType.WILLOW).materialColor(class_3620.field_16028).leavesHaveOverlay()),
    WITCH_HAZEL("witch_hazel", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_WITCH_HAZEL_SAPLING).boatType(BYGBoat.BYGType.WITCH_HAZEL).materialColor(class_3620.field_15987)),
    ZELKOVA("zelkova", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_ZELKOVA_SAPLING).boatType(BYGBoat.BYGType.ZELKOVA).materialColor(class_3620.field_15982)),
    SYTHIAN("sythian", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_SYTHIAN_FUNGUS).growerItem(GrowerItemType.FUNGUS).nether()),
    EMBUR("embur", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_EMBUR_WART).growerItem(GrowerItemType.WART).exclude(BlockType.LEAVES).registryName(BlockType.LOG, "%s_pedu").registryName(BlockType.STRIPPED_LOG, "stripped_%s_pedu").nether()),
    NIGHTSHADE("nightshade", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_NIGHTSHADE_SAPLING).materialColor(class_3620.field_15987)),
    SKYRIS("skyris", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_SKYRIS_SAPLING).materialColor(class_3620.field_16030).boatType(BYGBoat.BYGType.SKYRIS)),
    LAMENT("lament", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_LAMENT_SAPLING).materialColor(class_3620.field_15998)),
    MAPLE("maple", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_MAPLE_SAPLING).materialColor(class_3620.field_15995).boatType(BYGBoat.BYGType.MAPLE)),
    JACARANDA("jacaranda", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_JACARANDA_SAPLING).boatType(BYGBoat.BYGType.JACARANDA).materialColor(class_3620.field_16029));

    public static final Map<String, BYGWoodTypes> LOOKUP;
    private final String name;
    private final class_4719 woodType;
    private final Builder builder;
    private boolean initialized;
    private final MultiTag logTag;
    private BlockRegistryObject<class_2248> growerItem;
    private BlockRegistryObject<class_2248> leaves;
    private BlockRegistryObject<class_2248> log;
    private BlockRegistryObject<class_2248> wood;
    private BlockRegistryObject<class_2248> strippedLog;
    private BlockRegistryObject<class_2248> strippedWood;
    private BlockRegistryObject<class_2248> planks;
    private BlockRegistryObject<class_2248> bookshelf;
    private BlockRegistryObject<class_2248> craftingTable;
    private BlockRegistryObject<class_2248> stairs;
    private BlockRegistryObject<class_2248> slab;
    private BlockRegistryObject<class_2248> fence;
    private BlockRegistryObject<class_2248> fenceGate;
    private BlockRegistryObject<class_2248> door;
    private BlockRegistryObject<class_2248> trapdoor;
    private BlockRegistryObject<class_2248> pressurePlate;
    private BlockRegistryObject<class_2248> button;
    private BlockRegistryObject<class_2248> sign;
    private BlockRegistryObject<class_2248> wallSign;
    private RegistryObject<class_1822> signItem;
    private RegistryObject<BYGBoatItem> boat;
    private RegistryObject<BYGBoatItem> chestBoat;

    private BYGWoodTypes(String name, Builder builder) {
        this.name = name;
        this.builder = builder;
        this.woodType = WoodTypeAccess.byg_invokeRegister(WoodTypeAccess.byg_create(name));
        this.logTag = MultiTag.create(BYG.createLocation("wood/" + name + "_logs"));
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        if (!this.builder.excludes.contains((Object)BlockType.SAPLING)) {
            this.growerItem = switch (this.builder.growerItemType) {
                default -> throw new IncompatibleClassChangeError();
                case GrowerItemType.SAPLING -> BYGBlocks.createSapling(this.builder.growerItemGroundTag, this.name + "_sapling");
                case GrowerItemType.ODDITY -> BYGBlocks.createMushroom(this.builder.growerItemGroundTag, this.name + "_oddity");
                case GrowerItemType.FUNGUS -> BYGBlocks.createFungus(this.builder.growerItemGroundTag, this.name + "_fungus");
                case GrowerItemType.MUSHROOM -> BYGBlocks.createMushroom(this.builder.growerItemGroundTag, this.name + "_mushroom");
                case GrowerItemType.WART -> BYGBlocks.createFungus(this.builder.growerItemGroundTag, this.name + "_wart");
            };
            BYGItems.createGrowerItem(this.growerItem, this.builder.growerItemType == GrowerItemType.SAPLING);
        }
        if (!this.builder.excludes.contains((Object)BlockType.LEAVES)) {
            this.leaves = this.builder.isNether ? BYGBlocks.createBlock(BYGBlockProperties.BYGWartBlock::new, this.nameOr("%s_wart_block", BlockType.LEAVES)) : (this.builder.leavesLightLevel == null ? BYGBlocks.createLeaves(this.builder.materialColor, this.name + "_leaves") : BYGBlocks.createGlowingLeaves(this.builder.materialColor, this.builder.leavesLightLevel, this.name + "_leaves"));
            BYGItems.createItem(this.leaves);
        }
        this.log = this.ifAllowed(BlockType.LOG, () -> this.builder.isNether ? BYGBlocks.createBlock(BYGBlockProperties.BYGNetherLog::new, this.nameOr("%s_stem", BlockType.LOG)) : BYGBlocks.createLog(this.nameOr("%s_log", BlockType.LOG)));
        BYGItems.createItem(this.log);
        this.wood = this.ifAllowed(BlockType.WOOD, () -> this.builder.isNether ? BYGBlocks.createBlock(BYGBlockProperties.BYGNetherLog::new, this.nameOr("%s_hyphae", BlockType.WOOD)) : BYGBlocks.createWood(this.nameOr("%s_wood", BlockType.WOOD)));
        BYGItems.createItem(this.wood);
        this.strippedLog = this.ifAllowed(BlockType.STRIPPED_LOG, () -> this.builder.isNether ? BYGBlocks.createBlock(BYGBlockProperties.BYGNetherLog::new, this.nameOr("stripped_%s_stem", BlockType.STRIPPED_LOG)) : BYGBlocks.createStrippedLog(this.nameOr("stripped_%s_log", BlockType.STRIPPED_LOG)));
        BYGItems.createItem(this.strippedLog);
        this.strippedWood = this.ifAllowed(BlockType.STRIPPED_WOOD, () -> this.builder.isNether ? BYGBlocks.createBlock(BYGBlockProperties.BYGNetherLog::new, this.nameOr("stripped_%s_hyphae", BlockType.STRIPPED_WOOD)) : BYGBlocks.createWood(this.nameOr("stripped_%s_wood", BlockType.STRIPPED_WOOD)));
        BYGItems.createItem(this.strippedWood);
        this.planks = BYGBlocks.createPlanks(this.name + "_planks");
        BYGItems.createItem(this.planks);
        this.bookshelf = BYGBlocks.createBookshelf(this.name + "_bookshelf");
        BYGItems.createItem(this.bookshelf);
        this.craftingTable = BYGBlocks.createCraftingTable(this.name + "_crafting_table");
        BYGItems.createItem(this.craftingTable);
        this.stairs = BYGBlocks.createWoodStairs(this.name + "_stairs");
        BYGItems.createItem(this.stairs);
        this.slab = BYGBlocks.createWoodSlab(this.name + "_slab");
        BYGItems.createItem(this.slab);
        this.fence = BYGBlocks.createFence(this.name + "_fence");
        BYGItems.createItem(this.fence);
        this.fenceGate = BYGBlocks.createFenceGate(this.name + "_fence_gate");
        BYGItems.createItem(this.fenceGate);
        this.door = BYGBlocks.createDoor(this.name + "_door");
        BYGItems.createItem(this.door);
        this.trapdoor = BYGBlocks.createTrapDoor(this.name + "_trapdoor");
        BYGItems.createItem(this.trapdoor);
        this.pressurePlate = BYGBlocks.createWoodPressurePlate(this.name + "_pressure_plate");
        BYGItems.createItem(this.pressurePlate);
        this.button = BYGBlocks.createWoodButton(this.name + "_button");
        BYGItems.createItem(this.button);
        this.sign = BYGBlocks.createSign(this.name + "_sign", this.woodType, this.planks);
        this.wallSign = BYGBlocks.createWallSign(this.name + "_wall_sign", this.woodType, this.planks);
        this.signItem = BYGItems.createSign(this.name + "_sign", this.sign, this.wallSign);
        if (this.builder.boatType != null) {
            this.boat = BYGItems.createItem(() -> new BYGBoatItem(false, this.builder.boatType, new class_1792.class_1793().method_7892(BYGCreativeTab.CREATIVE_TAB).method_7889(1)), this.name + "_boat");
            this.chestBoat = BYGItems.createItem(() -> new BYGBoatItem(true, this.builder.boatType, new class_1792.class_1793().method_7892(BYGCreativeTab.CREATIVE_TAB).method_7889(1)), this.name + "_chest_boat");
        }
        this.initialized = true;
    }

    private String nameOr(String defaultName, BlockType blockType) {
        return this.builder.registryName.computeIfAbsent(blockType, k -> defaultName).formatted(this.name);
    }

    private <T> T ifAllowed(BlockType type, Supplier<? extends T> sup) {
        return this.builder.excludes.contains((Object)type) ? null : (T)sup.get();
    }

    public String toString() {
        return this.name;
    }

    public BlockRegistryObject<class_2248> planks() {
        return this.planks;
    }

    public BlockRegistryObject<class_2248> growerItem() {
        return this.growerItem;
    }

    public class_4719 woodType() {
        return this.woodType;
    }

    public BlockRegistryObject<class_2248> leaves() {
        return this.leaves;
    }

    public BlockRegistryObject<class_2248> log() {
        return this.log;
    }

    public BlockRegistryObject<class_2248> wood() {
        return this.wood;
    }

    public BlockRegistryObject<class_2248> strippedLog() {
        return this.strippedLog;
    }

    public BlockRegistryObject<class_2248> strippedWood() {
        return this.strippedWood;
    }

    public BlockRegistryObject<class_2248> bookshelf() {
        return this.bookshelf;
    }

    public BlockRegistryObject<class_2248> craftingTable() {
        return this.craftingTable;
    }

    public BlockRegistryObject<class_2248> stairs() {
        return this.stairs;
    }

    public BlockRegistryObject<class_2248> slab() {
        return this.slab;
    }

    public BlockRegistryObject<class_2248> fence() {
        return this.fence;
    }

    public BlockRegistryObject<class_2248> fenceGate() {
        return this.fenceGate;
    }

    public BlockRegistryObject<class_2248> door() {
        return this.door;
    }

    public BlockRegistryObject<class_2248> trapdoor() {
        return this.trapdoor;
    }

    public BlockRegistryObject<class_2248> pressurePlate() {
        return this.pressurePlate;
    }

    public BlockRegistryObject<class_2248> button() {
        return this.button;
    }

    public BlockRegistryObject<class_2248> sign() {
        return this.sign;
    }

    public BlockRegistryObject<class_2248> wallSign() {
        return this.wallSign;
    }

    public RegistryObject<class_1822> signItem() {
        return this.signItem;
    }

    public RegistryObject<BYGBoatItem> boat() {
        return this.boat;
    }

    public MultiTag logTag() {
        return this.logTag;
    }

    public BYGBoat.BYGType boatType() {
        return this.builder.boatType;
    }

    public boolean isNether() {
        return this.builder.isNether;
    }

    public boolean leavesHaveOverlay() {
        return this.builder.leavesHaveOverlay;
    }

    public RegistryObject<BYGBoatItem> chestBoat() {
        return this.chestBoat;
    }

    static {
        LOOKUP = Arrays.stream(BYGWoodTypes.values()).collect(Collectors.toUnmodifiableMap(BYGWoodTypes::toString, Function.identity()));
    }

    public static final class Builder {
        private final Map<BlockType, String> registryName = new HashMap<BlockType, String>();
        private GrowerItemType growerItemType = GrowerItemType.SAPLING;
        private final EnumSet<BlockType> excludes = EnumSet.noneOf(BlockType.class);
        private class_6862<class_2248> growerItemGroundTag = class_3481.field_29822;
        private BYGBoat.BYGType boatType;
        private class_3620 materialColor;
        private Integer leavesLightLevel;
        private boolean isNether;
        private boolean leavesHaveOverlay;

        public Builder growerItem(GrowerItemType type) {
            this.growerItemType = type;
            return this;
        }

        public Builder exclude(BlockType ... types) {
            this.excludes.addAll(List.of(types));
            return this;
        }

        public Builder growerItemGroundTag(class_6862<class_2248> tag) {
            this.growerItemGroundTag = tag;
            return this;
        }

        public Builder boatType(BYGBoat.BYGType type) {
            this.boatType = type;
            return this;
        }

        public Builder materialColor(class_3620 colour) {
            this.materialColor = colour;
            return this;
        }

        public Builder leavesLightLevel(Integer leavesLightLevel) {
            this.leavesLightLevel = leavesLightLevel;
            return this;
        }

        public Builder nether() {
            this.isNether = true;
            return this;
        }

        public Builder registryName(BlockType blockType, String name) {
            this.registryName.put(blockType, name);
            return this;
        }

        public Builder leavesHaveOverlay() {
            this.leavesHaveOverlay = true;
            return this;
        }
    }

    public static enum BlockType {
        LEAVES,
        SAPLING,
        WOOD,
        LOG,
        STRIPPED_WOOD,
        STRIPPED_LOG;

    }

    public static enum GrowerItemType {
        SAPLING,
        ODDITY,
        FUNGUS,
        MUSHROOM,
        WART;

    }
}

