/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client.config.serializers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_437;
import potionstudios.byg.BYG;
import potionstudios.byg.client.config.configeditor.ConfigEditEntry;
import potionstudios.byg.client.config.configeditor.ConfigPrimitiveEntry;
import potionstudios.byg.client.config.serializers.JanksonConfigEntriesSerializer;
import potionstudios.byg.client.config.serializers.TomlConfigEntriesSerializer;
import potionstudios.byg.client.config.serializers.XMLPropertiesConfigEntriesSerializer;
import potionstudios.byg.shadow.blue.endless.jankson.api.SyntaxError;

public interface ConfigEntriesSerializer<T> {
    public static final Set<Class<?>> PRIMITIVE_TYPES = (Set)class_156.method_654(new HashSet(), set -> {
        set.add(Integer.TYPE);
        set.add(Double.TYPE);
        set.add(Long.TYPE);
        set.add(Boolean.TYPE);
        set.add(Integer.class);
        set.add(Double.class);
        set.add(Long.class);
        set.add(Boolean.class);
        set.add(String.class);
    });

    public List<ConfigEditEntry<?>> createEntries(class_437 var1, String var2);

    public void saveFile(Path var1) throws Exception;

    public String save(List<? extends ConfigEditEntry<?>> var1);

    public String path();

    @Nullable
    public static ConfigEntriesSerializer<?> fromFile(Path path) {
        String fileName = path.toFile().getName();
        try {
            if (fileName.endsWith(".json") || fileName.endsWith(".json5")) {
                return JanksonConfigEntriesSerializer.fromPath(path);
            }
            if (fileName.endsWith(".xml") || fileName.endsWith(".properties")) {
                return XMLPropertiesConfigEntriesSerializer.fromPath(path);
            }
            if (fileName.endsWith(".toml")) {
                return TomlConfigEntriesSerializer.fromPath(path);
            }
        }
        catch (IOException | SyntaxError e) {
            e.printStackTrace();
        }
        return null;
    }

    public ConfigEntriesSerializer<T> makeMap(String var1);

    public ConfigEntriesSerializer<T> makeList(String var1);

    @Nullable
    public static ConfigPrimitiveEntry<?> makePrimitiveEntry(String key, Object value, class_437 parent) {
        return ConfigEntriesSerializer.makePrimitiveEntry(key, value, parent, "");
    }

    @Nullable
    public static ConfigPrimitiveEntry<?> makePrimitiveEntry(String key, Object value, class_437 parent, String comment) {
        if (value instanceof Integer) {
            Integer asInt = (Integer)value;
            return new ConfigPrimitiveEntry<Integer>(parent, key, asInt, Integer::parseInt, comment);
        }
        if (value instanceof Long) {
            Long asLong = (Long)value;
            return new ConfigPrimitiveEntry<Long>(parent, key, asLong, Long::parseLong, comment);
        }
        if (value instanceof String) {
            String asString = (String)value;
            return new ConfigPrimitiveEntry<String>(parent, key, asString, Function.identity(), comment);
        }
        if (value instanceof Double) {
            Double asDouble = (Double)value;
            return new ConfigPrimitiveEntry<Double>(parent, key, asDouble, Double::parseDouble, comment);
        }
        if (value instanceof Boolean) {
            Boolean asBoolean = (Boolean)value;
            return new ConfigPrimitiveEntry<Boolean>(parent, key, asBoolean, Boolean::parseBoolean, comment);
        }
        BYG.LOGGER.error(String.format("Could not make entry to edit for key: \"%s\"", key));
        return null;
    }
}

