/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Arrays;
import java.util.Objects;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import potionstudios.byg.BYG;
import potionstudios.byg.common.BYGFuels;
import potionstudios.byg.common.entity.npc.TradesConfig;
import potionstudios.byg.common.item.BYGCreativeTab;
import potionstudios.byg.common.item.BYGItems;
import potionstudios.byg.common.world.biome.end.BYGEndBiomeSource;
import potionstudios.byg.common.world.biome.nether.BYGNetherBiomeSource;
import potionstudios.byg.core.BYGRegistry;
import potionstudios.byg.network.FabricNetworkHandler;
import potionstudios.byg.world.biome.BYGFabricEndBiomeSource;
import potionstudios.byg.world.biome.BYGFabricNetherBiomeSource;

public class BYGFabric
implements ModInitializer {
    private static String firstInitialized = null;
    private static boolean afterRegistriesFreezeLoaded = false;

    public void onInitialize() {
        BYGFabric.initializeBYG("Fabric Mod Initializer");
    }

    public static void initializeBYG(String initializedFrom) {
        Objects.requireNonNull(initializedFrom, "BYG must be told where it was initialized from.");
        if (firstInitialized != null || BYG.INITIALIZED) {
            BYG.LOGGER.debug(String.format("Attempted to Initialize Oh The Biomes You'll Go (BYG) from \"%s\" but BYG already was initialized from \"%s\", this should not be a problem.", initializedFrom, firstInitialized));
            return;
        }
        firstInitialized = initializedFrom;
        BYG.INITIALIZED = true;
        BYGFabric.registryBootStrap();
        BYGRegistry.loadClasses();
        BYGFuels.loadFuels((arg_0, arg_1) -> ((FuelRegistry)FuelRegistry.INSTANCE).add(arg_0, arg_1));
        CommandRegistrationCallback.EVENT.register((dispatcher, commandBuildContext, commandSelection) -> BYG.attachCommands((CommandDispatcher<class_2168>)dispatcher, commandSelection));
        FabricNetworkHandler.init();
        BYG.LOGGER.info(String.format("Oh The Biomes You'll Go (BYG) was initialized from \"%s\"", initializedFrom));
    }

    public static void afterRegistriesFreeze() {
        if (afterRegistriesFreezeLoaded) {
            Throwable throwable = new Throwable();
            BYG.LOGGER.warn("Attempted to fire BYG after registries froze a 2nd time...", throwable);
        }
        BYG.LOGGER.info("\"Oh The Biomes You'll Go\" after registries freeze event firing...");
        BYG.commonLoad();
        BYG.threadSafeCommonLoad();
        BYG.threadSafeLoadFinish();
        BYGFabric.registerVillagerTrades();
        afterRegistriesFreezeLoaded = true;
        BYG.LOGGER.info("\"Oh The Biomes You'll Go\" after registries freeze event complete!");
    }

    private static void registerVillagerTrades() {
        TradesConfig tradesConfig = TradesConfig.getConfig();
        if (tradesConfig.enabled()) {
            tradesConfig.tradesByProfession().forEach((villagerProfession, int2ObjectMap) -> int2ObjectMap.forEach((level, configListing) -> TradeOfferHelper.registerVillagerOffers((class_3852)villagerProfession, (int)level, itemListings -> itemListings.addAll(Arrays.asList(configListing)))));
            tradesConfig.wanderingTraderTrades().forEach((level, listings) -> TradeOfferHelper.registerWanderingTraderOffers((int)level, itemListings -> itemListings.addAll(Arrays.asList(listings))));
        } else {
            BYG.LOGGER.warn("Ignoring villager/wandering trader trades added by BYG.");
        }
    }

    private static void registryBootStrap() {
        BYGCreativeTab.init(FabricItemGroupBuilder.build((class_2960)BYG.createLocation("byg"), () -> new class_1799((class_1935)BYGItems.BYG_LOGO.get())));
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)BYGEndBiomeSource.LOCATION, BYGFabricEndBiomeSource.CODEC);
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)BYGNetherBiomeSource.LOCATION, BYGFabricNetherBiomeSource.CODEC);
        BYG.LOGGER.info("BYG registries bootstrapped");
    }
}

