/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2478;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import potionstudios.byg.common.BYGCarvableBlocks;
import potionstudios.byg.common.BYGCompostables;
import potionstudios.byg.common.BYGFlammables;
import potionstudios.byg.common.BYGFlattenables;
import potionstudios.byg.common.BYGHoeables;
import potionstudios.byg.common.BYGStrippables;
import potionstudios.byg.common.BYGTags;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.entity.ai.village.poi.BYGPoiTypes;
import potionstudios.byg.common.entity.villager.BYGVillagerType;
import potionstudios.byg.config.BYGConfigHandler;
import potionstudios.byg.config.ConfigVersionTracker;
import potionstudios.byg.mixin.access.BlockEntityTypeAccess;
import potionstudios.byg.mixin.access.DeltaFeatureAccess;
import potionstudios.byg.mixin.access.PoiTypesAccess;
import potionstudios.byg.reg.BlockRegistryObject;
import potionstudios.byg.server.command.ReloadConfigsCommand;
import potionstudios.byg.server.command.UpdateConfigsCommand;
import potionstudios.byg.server.command.WorldGenExportCommand;
import potionstudios.byg.util.FileUtils;
import potionstudios.byg.util.ModPlatform;

public class BYG {
    public static final String MOD_ID = "byg";
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean INITIALIZED;

    public static void commonLoad() {
        PoiTypesAccess.byg_invokeRegisterBlockStates(BYGPoiTypes.FORAGER.asHolder());
        String loadAllConfigs = BYGConfigHandler.loadAllConfigs(false, false);
        if (!loadAllConfigs.isEmpty()) {
            throw new IllegalStateException(loadAllConfigs);
        }
        FileUtils.backUpDirectory(ModPlatform.INSTANCE.configPath(), "last_working_configs_backup");
        if (Boolean.getBoolean("bygDev")) {
            ModPlatform.INSTANCE.addTagsUpdatedListener(access -> {
                for (BYGTags tag : BYGTags.values()) {
                    for (BYGTags.RegistryType<?> allowed : tag.acceptedTypes) {
                        class_6862<?> bygTag;
                        Optional<class_6885.class_6888<?>> holder = allowed.getTag(bygTag = tag.byg(allowed));
                        if (!holder.isEmpty() && !holder.get().method_40239().findFirst().isEmpty()) continue;
                        LOGGER.warn("Tag {} of type {} is empty!", (Object)bygTag.comp_327(), (Object)allowed.registry.method_29177());
                    }
                }
            });
        }
    }

    public static void attachCommands(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environmentType) {
        WorldGenExportCommand.worldGenExportCommand(dispatcher);
        LiteralArgumentBuilder bygCommands = class_2170.method_9247((String)MOD_ID);
        bygCommands.then(ReloadConfigsCommand.register());
        bygCommands.then(UpdateConfigsCommand.register());
        dispatcher.register(bygCommands);
    }

    public static void threadSafeCommonLoad() {
        BYGVillagerType.setVillagerForBYGBiomes();
        BYG.appendBlocksToBlockEntities();
        DeltaFeatureAccess.byg_setCANNOT_REPLACE((ImmutableList<class_2248>)new ImmutableList.Builder().addAll(DeltaFeatureAccess.byg_getCANNOT_REPLACE()).add((Object)((class_2248)BYGBlocks.EMBUR_GEL_BLOCK.get())).add((Object)((class_2248)BYGBlocks.EMBUR_GEL_BRANCH.get())).add((Object)((class_2248)BYGBlocks.EMBUR_GEL_VINES.get())).addAll((Iterable)class_156.method_654(new ArrayList(), list -> {
            for (class_2248 block : class_2378.field_11146) {
                class_3614 material = block.method_9564().method_26207();
                if (material != class_3614.field_15935 && material != class_3614.field_15946 && material != class_3614.field_15938 && material != class_3614.field_15956 && material != class_3614.field_26708 && material != class_3614.field_15926 && material != class_3614.field_15923 && material != class_3614.field_15932 && material != class_3614.field_15945) continue;
                list.add(block);
            }
        })).build());
    }

    private static void appendBlocksToBlockEntities() {
        BlockEntityTypeAccess campfireBuilderAccess = (BlockEntityTypeAccess)class_2591.field_17380;
        ObjectOpenHashSet validCampfireBlocks = new ObjectOpenHashSet(campfireBuilderAccess.byg_getValidBlocks());
        validCampfireBlocks.add((class_2248)BYGBlocks.CRYPTIC_CAMPFIRE.get());
        validCampfireBlocks.add((class_2248)BYGBlocks.BORIC_CAMPFIRE.get());
        campfireBuilderAccess.byg_setValidBlocks((Set<class_2248>)validCampfireBlocks);
        BlockEntityTypeAccess signBuilderAccess = (BlockEntityTypeAccess)class_2591.field_11911;
        ObjectOpenHashSet signValidBlocks = new ObjectOpenHashSet(signBuilderAccess.byg_getValidBlocks());
        for (BlockRegistryObject<class_2248> signBlock : BYGBlocks.SIGN_BLOCKS) {
            class_2248 block = (class_2248)signBlock.get();
            if (block instanceof class_2478) {
                signValidBlocks.add(block);
                continue;
            }
            throw new IllegalArgumentException("Attempting to add block to sign block entity that is not a type of SignBlock");
        }
        signBuilderAccess.byg_setValidBlocks((Set<class_2248>)signValidBlocks);
    }

    public static void threadSafeLoadFinish() {
        LOGGER.debug("BYG: \"Load Complete Event\" Starting...");
        BYGCompostables.compostablesBYG();
        BYGHoeables.tillablesBYG();
        BYGFlammables.flammablesBYG();
        BYGStrippables.strippableLogsBYG();
        BYGCarvableBlocks.addCarverBlocks();
        BYGFlattenables.addFlattenables();
        LOGGER.info("BYG: \"Load Complete\" Event Complete!");
    }

    public static class_2960 createLocation(String path) {
        return new class_2960(MOD_ID, path);
    }

    public static class_2960 createLocation(class_5321<?> path) {
        return path.method_29177();
    }

    public static class_2960 createLocation(class_6880<?> holder) {
        return BYG.createLocation((class_5321)holder.method_40230().orElseThrow());
    }

    static {
        ConfigVersionTracker.getConfig(new ConfigVersionTracker(ModPlatform.INSTANCE.configPath().toFile().exists() ? 0 : 5), false);
    }
}

