/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.minecraft.class_1011;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.util.ColorExtractor;
import org.betterx.bclib.util.MHelper;

public class ColorUtil {
    private static final float[] FLOAT_BUFFER = new float[4];
    private static final int ALPHA = -16777216;
    private static final Map<class_2960, Integer> colorPalette = Maps.newHashMap();

    public static int color(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int color(String hex) {
        int r = Integer.parseInt(hex.substring(0, 2), 16);
        int g = Integer.parseInt(hex.substring(2, 4), 16);
        int b = Integer.parseInt(hex.substring(4, 6), 16);
        return ColorUtil.color(r, g, b);
    }

    public static int[] toIntArray(int color) {
        return new int[]{color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
    }

    public static float[] toFloatArray(int color) {
        ColorUtil.FLOAT_BUFFER[0] = (float)(color >> 16 & 0xFF) / 255.0f;
        ColorUtil.FLOAT_BUFFER[1] = (float)(color >> 8 & 0xFF) / 255.0f;
        ColorUtil.FLOAT_BUFFER[2] = (float)(color & 0xFF) / 255.0f;
        ColorUtil.FLOAT_BUFFER[3] = (float)(color >> 24 & 0xFF) / 255.0f;
        return FLOAT_BUFFER;
    }

    public static float[] RGBtoHSB(int r, int g, int b, float[] hsbvals) {
        float hue;
        int cmin;
        int cmax;
        if (hsbvals == null) {
            hsbvals = FLOAT_BUFFER;
        }
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }

    public static int parseHex(String hexColor) {
        int shift;
        int color;
        int len = hexColor.length();
        if (len < 6 || len > 8 || len % 2 > 0) {
            return -1;
        }
        if (len == 6) {
            color = -16777216;
            shift = 16;
        } else {
            color = 0;
            shift = 24;
        }
        try {
            String[] splited;
            for (String digit : splited = hexColor.split("(?<=\\G.{2})")) {
                color |= Integer.valueOf(digit, 16) << shift;
                shift -= 8;
            }
        }
        catch (NumberFormatException ex) {
            BCLib.LOGGER.catching(ex);
            return -1;
        }
        return color;
    }

    public static int toABGR(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return 0xFF000000 | b << 16 | g << 8 | r;
    }

    public static int ABGRtoARGB(int color) {
        int a = color >> 24 & 0xFF;
        int b = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int r = color & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int colorBrigtness(int color, float val) {
        ColorUtil.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, FLOAT_BUFFER);
        FLOAT_BUFFER[2] = FLOAT_BUFFER[2] + val / 10.0f;
        ColorUtil.FLOAT_BUFFER[2] = class_3532.method_15363((float)FLOAT_BUFFER[2], (float)0.0f, (float)1.0f);
        return ColorUtil.HSBtoRGB(FLOAT_BUFFER[0], FLOAT_BUFFER[1], FLOAT_BUFFER[2]);
    }

    public static int applyTint(int color, int tint) {
        return ColorUtil.colorBrigtness(ColorHelper.multiplyColor((int)color, (int)tint), 1.5f);
    }

    public static int colorDistance(int color1, int color2) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        return MHelper.sqr(r1 - r2) + MHelper.sqr(g1 - g2) + MHelper.sqr(b1 - b2);
    }

    @Environment(value=EnvType.CLIENT)
    public static int extractColor(class_1792 item) {
        class_2960 id = class_2378.field_11142.method_10221((Object)item);
        if (id.equals((Object)class_2378.field_11142.method_10137())) {
            return -1;
        }
        if (colorPalette.containsKey(id)) {
            return colorPalette.get(id);
        }
        class_2960 texture = item instanceof class_1747 ? new class_2960(id.method_12836(), "textures/block/" + id.method_12832() + ".png") : new class_2960(id.method_12836(), "textures/item/" + id.method_12832() + ".png");
        class_1011 image = ColorUtil.loadImage(texture, 16, 16);
        ArrayList<Integer> colors = new ArrayList<Integer>();
        for (int i = 0; i < image.method_4307(); ++i) {
            for (int j = 0; j < 16; ++j) {
                int col = image.method_4315(i, j);
                if ((col >> 24 & 0xFF) <= 0) continue;
                colors.add(ColorUtil.ABGRtoARGB(col));
            }
        }
        image.close();
        if (colors.size() == 0) {
            return -1;
        }
        ColorExtractor extractor = new ColorExtractor(colors);
        int color = extractor.analize();
        colorPalette.put(id, color);
        return color;
    }

    @Environment(value=EnvType.CLIENT)
    public static class_1011 loadImage(class_2960 image, int w, int h) {
        class_310 minecraft = class_310.method_1551();
        class_3300 resourceManager = minecraft.method_1478();
        Optional imgResource = resourceManager.method_14486(image);
        if (imgResource.isPresent()) {
            try {
                return class_1011.method_4309((InputStream)((class_3298)imgResource.get()).method_14482());
            }
            catch (IOException e) {
                BCLib.LOGGER.warning("Can't load texture image: {}. Will be created empty image.", image);
                BCLib.LOGGER.warning("Cause: {}.", e.getMessage());
            }
        }
        return new class_1011(w, h, false);
    }
}

