/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import org.betterx.bclib.config.PathConfig;

public abstract class BaseRegistry<T> {
    private static final List<BaseRegistry<?>> REGISTRIES = Lists.newArrayList();
    private static final Map<String, List<class_1792>> MOD_BLOCK_ITEMS = Maps.newHashMap();
    private static final Map<String, List<class_2248>> MOD_BLOCKS = Maps.newHashMap();
    private static final Map<String, List<class_1792>> MOD_ITEMS = Maps.newHashMap();
    protected final class_1761 creativeTab;
    protected final PathConfig config;

    protected BaseRegistry(class_1761 creativeTab, PathConfig config) {
        this.creativeTab = creativeTab;
        this.config = config;
        REGISTRIES.add(this);
    }

    public abstract T register(class_2960 var1, T var2);

    public abstract void registerItem(class_2960 var1, class_1792 var2);

    public FabricItemSettings makeItemSettings() {
        FabricItemSettings properties = new FabricItemSettings();
        return (FabricItemSettings)properties.method_7892(this.creativeTab);
    }

    private void registerInternal() {
    }

    public static Map<String, List<class_1792>> getRegisteredBlocks() {
        return MOD_BLOCK_ITEMS;
    }

    public static Map<String, List<class_1792>> getRegisteredItems() {
        return MOD_ITEMS;
    }

    public static List<class_1792> getModBlockItems(String modId) {
        if (MOD_BLOCK_ITEMS.containsKey(modId)) {
            return MOD_BLOCK_ITEMS.get(modId);
        }
        ArrayList modBlocks = Lists.newArrayList();
        MOD_BLOCK_ITEMS.put(modId, modBlocks);
        return modBlocks;
    }

    public static List<class_1792> getModItems(String modId) {
        if (MOD_ITEMS.containsKey(modId)) {
            return MOD_ITEMS.get(modId);
        }
        ArrayList modBlocks = Lists.newArrayList();
        MOD_ITEMS.put(modId, modBlocks);
        return modBlocks;
    }

    public static List<class_2248> getModBlocks(String modId) {
        if (MOD_BLOCKS.containsKey(modId)) {
            return MOD_BLOCKS.get(modId);
        }
        ArrayList modBlocks = Lists.newArrayList();
        MOD_BLOCKS.put(modId, modBlocks);
        return modBlocks;
    }

    public static void register() {
        REGISTRIES.forEach(BaseRegistry::registerInternal);
    }
}

