/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.betterx.bclib.util.CollectionsUtil;

public class BCLRecipeManager {
    private static final Map<class_3956<?>, Map<class_2960, class_1860<?>>> RECIPES = Maps.newHashMap();
    private static final Map<class_3956<?>, Object> SORTED = Maps.newHashMap();
    private static final String MINECRAFT = "minecraft";

    public static <C extends class_1263, T extends class_1860<C>> Optional<T> getSortedRecipe(class_3956<T> type, C inventory, class_1937 level, Function<class_3956<T>, Map<class_2960, class_1860<C>>> getter) {
        List recipes = (List)SORTED.computeIfAbsent(type, t -> {
            Collection values = ((Map)getter.apply(type)).values();
            ArrayList list = new ArrayList(values);
            list.sort((v1, v2) -> {
                boolean b2;
                boolean b1 = v1.method_8114().method_12836().equals(MINECRAFT);
                return b1 ^ (b2 = v2.method_8114().method_12836().equals(MINECRAFT)) ? (b1 ? 1 : -1) : v1.method_8114().method_12833(v2.method_8114());
            });
            return ImmutableList.copyOf(list);
        });
        return recipes.stream().filter(recipe -> recipe.method_8115(inventory, level)).findFirst();
    }

    public static void addRecipe(class_3956<?> type, class_1860<?> recipe) {
        Map list = RECIPES.computeIfAbsent(type, i -> Maps.newHashMap());
        list.put(recipe.method_8114(), recipe);
    }

    public static <T extends class_1860<?>> T getRecipe(class_3956<T> type, class_2960 id) {
        Map<class_2960, class_1860<?>> map = RECIPES.get(type);
        return (T)(map != null ? map.get(id) : null);
    }

    public static Map<class_3956<?>, Map<class_2960, class_1860<?>>> getMap(Map<class_3956<?>, Map<class_2960, class_1860<?>>> recipes) {
        HashMap result = Maps.newHashMap();
        for (class_3956<?> type2 : recipes.keySet()) {
            HashMap typeList = Maps.newHashMap();
            typeList.putAll(recipes.get(type2));
            result.put(type2, typeList);
        }
        SORTED.clear();
        RECIPES.forEach((type, list) -> {
            if (list != null) {
                Map typeList = result.computeIfAbsent(type, i -> Maps.newHashMap());
                for (Map.Entry entry : list.entrySet()) {
                    class_2960 id = (class_2960)entry.getKey();
                    typeList.computeIfAbsent(id, i -> (class_1860)entry.getValue());
                }
            }
        });
        return result;
    }

    public static Map<class_2960, class_1860<?>> getMapByName(Map<class_2960, class_1860<?>> recipes) {
        Map<class_2960, class_1860<?>> result = CollectionsUtil.getMutable(recipes);
        RECIPES.values().forEach(map -> map.forEach((location, recipe) -> result.computeIfAbsent((class_2960)location, i -> recipe)));
        return result;
    }

    public static <S extends class_1865<T>, T extends class_1860<?>> S registerSerializer(String modID, String id, S serializer) {
        return (S)((class_1865)class_2378.method_10226((class_2378)class_2378.field_17598, (String)(modID + ":" + id), serializer));
    }

    public static <T extends class_1860<?>> class_3956<T> registerType(String modID, final String type) {
        class_2960 recipeTypeId = new class_2960(modID, type);
        return (class_3956)class_2378.method_10230((class_2378)class_2378.field_17597, (class_2960)recipeTypeId, (Object)new class_3956<T>(){

            public String toString() {
                return type;
            }
        });
    }

    public static boolean exists(class_1935 item) {
        if (item instanceof class_2248) {
            return class_2378.field_11146.method_10221((Object)((class_2248)item)) != class_2378.field_11146.method_10137();
        }
        return class_2378.field_11142.method_10221((Object)item.method_8389()) != class_2378.field_11142.method_10137();
    }

    public static boolean exists(class_1935 ... items) {
        for (class_1935 item : items) {
            if (BCLRecipeManager.exists(item)) continue;
            return false;
        }
        return true;
    }
}

