/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.presets.worldgen;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5458;
import net.minecraft.class_6862;
import net.minecraft.class_7089;
import net.minecraft.class_7145;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.generator.BCLBiomeSource;
import org.betterx.bclib.api.v2.levelgen.LevelGenUtil;
import org.betterx.bclib.api.v2.tag.TagAPI;
import org.betterx.bclib.api.v2.tag.TagType;
import org.betterx.bclib.presets.worldgen.BCLWorldPreset;
import org.betterx.bclib.presets.worldgen.BCLWorldPresetSettings;
import org.betterx.bclib.presets.worldgen.WorldPresetSettings;

public class BCLWorldPresets {
    public static final TagType.Simple<class_7145> WORLD_PRESETS = TagAPI.registerType(class_5458.field_38010, "tags/worldgen/world_preset");
    private static Map<class_5321<class_7145>, PresetBuilder> BUILDERS = Maps.newHashMap();
    private static final Map<class_5321<class_7145>, WorldPresetSettings> SETTINGS = Maps.newHashMap();
    public static final class_5321<class_7145> BCL_WORLD = BCLWorldPresets.register(BCLib.makeID("normal"), (overworldStem, netherContext, endContext) -> new BCLWorldPresetSettings(BCLBiomeSource.DEFAULT_BIOME_SOURCE_VERSION).buildPreset(overworldStem, netherContext, endContext), true);
    public static Optional<class_5321<class_7145>> DEFAULT = Optional.of(BCL_WORLD);
    public static final class_5321<class_7145> BCL_WORLD_17 = BCLWorldPresets.register(BCLib.makeID("legacy_17"), (overworldStem, netherContext, endContext) -> new BCLWorldPresetSettings(BCLBiomeSource.BIOME_SOURCE_VERSION_SQUARE).buildPreset(overworldStem, netherContext, endContext), false);

    private static class_5321<class_7145> register(class_2960 loc) {
        return BCLWorldPresets.register(loc, true);
    }

    private static class_5321<class_7145> register(class_2960 loc, boolean addToNormal) {
        class_5321 key = class_5321.method_29179((class_5321)class_2378.field_37998, (class_2960)loc);
        if (addToNormal) {
            WORLD_PRESETS.addUntyped((class_6862<class_7145>)class_7089.field_37406, key.method_29177());
        }
        return key;
    }

    public static void registerPresets() {
    }

    public static class_5321<class_7145> register(class_2960 loc, PresetBuilder builder, boolean visibleInUI) {
        class_5321<class_7145> key = BCLWorldPresets.register(loc, visibleInUI);
        if (BUILDERS == null) {
            BCLib.LOGGER.error("Unable to register WorldPreset '" + loc + "'.");
        } else {
            BUILDERS.put(key, builder);
        }
        return key;
    }

    public static void bootstrapPresets(class_2378<class_7145> presets, class_5363 overworldStem, LevelGenUtil.Context netherContext, LevelGenUtil.Context endContext) {
        for (Map.Entry<class_5321<class_7145>, PresetBuilder> e : BUILDERS.entrySet()) {
            BCLWorldPreset preset = e.getValue().create(overworldStem, netherContext, endContext);
            SETTINGS.put(e.getKey(), preset.settings);
            class_5458.method_39203(presets, e.getKey(), (Object)((Object)preset));
        }
        BUILDERS = null;
    }

    public static WorldPresetSettings getSettingsForPreset(class_5321<class_7145> key) {
        return SETTINGS.getOrDefault(key, BCLWorldPresetSettings.DEFAULT);
    }

    @FunctionalInterface
    public static interface PresetBuilder {
        public BCLWorldPreset create(class_5363 var1, LevelGenUtil.Context var2, LevelGenUtil.Context var3);
    }
}

