/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.presets.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_5284;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.generator.BCLBiomeSource;
import org.betterx.bclib.api.v2.generator.BCLChunkGenerator;
import org.betterx.bclib.api.v2.levelgen.LevelGenUtil;
import org.betterx.bclib.api.v2.levelgen.biomes.InternalBiomeAPI;
import org.betterx.bclib.api.v2.levelgen.surface.SurfaceRuleUtil;
import org.betterx.bclib.interfaces.ChunkGeneratorAccessor;
import org.betterx.bclib.interfaces.NoiseGeneratorSettingsProvider;
import org.betterx.bclib.presets.worldgen.BCLWorldPreset;
import org.betterx.bclib.presets.worldgen.WorldPresetSettings;

public class BCLWorldPresetSettings
extends WorldPresetSettings {
    public static final BCLWorldPresetSettings DEFAULT = new BCLWorldPresetSettings(BCLBiomeSource.DEFAULT_BIOME_SOURCE_VERSION);
    public static final Codec<BCLWorldPresetSettings> CODEC = RecordCodecBuilder.create(builderInstance -> {
        RecordCodecBuilder netherVersion = Codec.INT.fieldOf(class_5363.field_25413.method_29177().toString()).forGetter(settings -> settings.netherVersion);
        RecordCodecBuilder endVersion = Codec.INT.fieldOf(class_5363.field_25414.method_29177().toString()).forGetter(settings -> settings.endVersion);
        return builderInstance.group((App)netherVersion, (App)endVersion).apply((Applicative)builderInstance, builderInstance.stable(BCLWorldPresetSettings::new));
    });
    public final int netherVersion;
    public final int endVersion;

    public BCLWorldPresetSettings(int version) {
        this(version, version);
    }

    public BCLWorldPresetSettings(int netherVersion, int endVersion) {
        this.netherVersion = netherVersion;
        this.endVersion = endVersion;
    }

    @Override
    public Codec<? extends WorldPresetSettings> codec() {
        return CODEC;
    }

    public BCLWorldPreset buildPreset(class_5363 overworldStem, LevelGenUtil.Context netherContext, LevelGenUtil.Context endContext) {
        return new BCLWorldPreset(this.buildDimensionMap(overworldStem, netherContext, endContext), 1000, this);
    }

    public Map<class_5321<class_5363>, class_5363> buildDimensionMap(class_5363 overworldStem, LevelGenUtil.Context netherContext, LevelGenUtil.Context endContext) {
        return Map.of(class_5363.field_25412, overworldStem, class_5363.field_25413, this.createNetherStem(netherContext), class_5363.field_25414, this.createEndStem(endContext));
    }

    public int getVersion(class_5321<class_5363> key) {
        if (key == class_5363.field_25413) {
            return this.netherVersion;
        }
        if (key == class_5363.field_25414) {
            return this.endVersion;
        }
        return BCLBiomeSource.BIOME_SOURCE_VERSION_VANILLA;
    }

    public class_5363 createStem(LevelGenUtil.Context ctx, class_5321<class_5363> key) {
        if (key == class_5363.field_25413) {
            return this.createNetherStem(ctx);
        }
        if (key == class_5363.field_25414) {
            return this.createEndStem(ctx);
        }
        return null;
    }

    public class_5363 createNetherStem(LevelGenUtil.Context ctx) {
        return LevelGenUtil.getBCLNetherLevelStem(ctx, Optional.of(this.netherVersion));
    }

    public class_5363 createEndStem(LevelGenUtil.Context ctx) {
        return LevelGenUtil.getBCLEndLevelStem(ctx, Optional.of(this.endVersion));
    }

    @Override
    public class_1966 fixBiomeSource(class_1966 biomeSource, Set<class_6880<class_1959>> datapackBiomes) {
        if (biomeSource instanceof BCLBiomeSource) {
            BCLBiomeSource bs = (BCLBiomeSource)biomeSource;
            return bs.createCopyForDatapack(datapackBiomes);
        }
        return biomeSource;
    }

    public class_6880<class_5284> fixNoiseSettings(class_6880<class_5284> settings, class_1966 biomeSource) {
        class_5284 old = (class_5284)settings.comp_349();
        class_5284 noise = new class_5284(old.comp_474(), old.comp_475(), old.comp_476(), old.comp_477(), SurfaceRuleUtil.addRulesForBiomeSource(old.comp_478(), biomeSource), old.comp_538(), old.comp_479(), old.comp_480(), old.comp_481(), old.comp_482(), old.comp_483());
        return class_6880.method_40223((Object)noise);
    }

    public class_5285 fixSettingsInCurrentWorld(class_5455 access, class_5321<class_5363> dimensionKey, class_5321<class_2874> dimensionTypeKey, class_5285 settings) {
        int targetVersion;
        Optional loadedStem = settings.method_28609().method_40264(dimensionKey);
        class_2794 loadedChunkGenerator = loadedStem.map(h -> ((class_5363)h.comp_349()).method_29571()).orElse(null);
        int loaderVersion = LevelGenUtil.getBiomeVersionForGenerator(loadedStem.map(h -> ((class_5363)h.comp_349()).method_29571()).orElse(null));
        if (loaderVersion != (targetVersion = this.getVersion(dimensionKey))) {
            BCLib.LOGGER.info("Enforcing Correct Generator for " + dimensionKey.method_29177().toString() + ".");
            Optional<class_6880<class_5363>> refLevelStem = LevelGenUtil.referenceStemForVersion(dimensionKey, targetVersion, access, settings.method_28028(), settings.method_28029(), settings.method_28030());
            Object referenceGenerator = refLevelStem.map(h -> ((class_5363)h.comp_349()).method_29571()).orElse(null);
            if (referenceGenerator == null) {
                BCLib.LOGGER.error("Failed to create Generator for " + dimensionKey.method_29177().toString());
                return settings;
            }
            if (loadedChunkGenerator instanceof ChunkGeneratorAccessor) {
                ChunkGeneratorAccessor generator = (ChunkGeneratorAccessor)loadedChunkGenerator;
                if (loadedChunkGenerator instanceof NoiseGeneratorSettingsProvider) {
                    NoiseGeneratorSettingsProvider noiseProvider = (NoiseGeneratorSettingsProvider)loadedChunkGenerator;
                    Set biomes = loadedChunkGenerator.method_12098().method_28443();
                    class_1966 bs = this.fixBiomeSource(referenceGenerator.method_12098(), biomes);
                    InternalBiomeAPI.applyModifications(bs, dimensionKey);
                    referenceGenerator = new BCLChunkGenerator(generator.bclib_getStructureSetsRegistry(), noiseProvider.bclib_getNoises(), bs, this.fixNoiseSettings(noiseProvider.bclib_getNoiseGeneratorSettingHolders(), bs));
                }
            }
            return LevelGenUtil.replaceGenerator(dimensionKey, dimensionTypeKey, access, settings, referenceGenerator);
        }
        BCLChunkGenerator.injectNoiseSettings(dimensionKey, loadedChunkGenerator);
        return settings;
    }

    @Override
    public class_5285 repairSettingsOnLoad(class_5455 registryAccess, class_5285 settings) {
        settings = this.fixSettingsInCurrentWorld(registryAccess, (class_5321<class_5363>)class_5363.field_25413, (class_5321<class_2874>)class_7134.field_37667, settings);
        settings = this.fixSettingsInCurrentWorld(registryAccess, (class_5321<class_5363>)class_5363.field_25414, (class_5321<class_2874>)class_7134.field_37668, settings);
        BCLChunkGenerator.injectNoiseSettings(settings, BCLChunkGenerator.NON_MANAGED_DIMENSIONS);
        return settings;
    }
}

