/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.config;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.config.ConfigKeeper;
import org.betterx.bclib.config.ConfigKey;
import org.betterx.bclib.config.ConfigUI;
import org.betterx.bclib.config.PathConfig;

public class NamedPathConfig
extends PathConfig {
    public NamedPathConfig(String modID, String group, boolean autoSync, boolean diffContent) {
        super(modID, group, autoSync, diffContent);
        this.onInit();
    }

    public NamedPathConfig(String modID, String group, boolean autoSync) {
        super(modID, group, autoSync);
        this.onInit();
    }

    public NamedPathConfig(String modID, String group) {
        super(modID, group);
        this.onInit();
    }

    public List<ConfigTokenDescription<?>> getAllOptions() {
        LinkedList res = new LinkedList();
        for (Field fl : this.getClass().getDeclaredFields()) {
            int modifiers = fl.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !ConfigToken.class.isAssignableFrom(fl.getType())) continue;
            try {
                res.add(new ConfigTokenDescription(fl));
            }
            catch (IllegalAccessException e) {
                BCLib.LOGGER.error("Could not access " + fl);
            }
        }
        return res;
    }

    protected void onInit() {
        this.getAllOptions().forEach(e -> this.get(e.token));
        this.saveChanges();
    }

    public <T> T getRaw(ConfigToken<T> what) {
        return this._get(what, true);
    }

    public <T> T get(ConfigToken<T> what) {
        return this._get(what, false);
    }

    private <T> T _get(ConfigToken<T> what, boolean raw) {
        if (ConfigKeeper.BooleanEntry.class.isAssignableFrom(what.type)) {
            return (T)this._getBoolean(what, raw);
        }
        if (ConfigKeeper.IntegerEntry.class.isAssignableFrom(what.type)) {
            return (T)this._getInt(what);
        }
        if (ConfigKeeper.FloatEntry.class.isAssignableFrom(what.type)) {
            return (T)this._getFloat(what);
        }
        if (ConfigKeeper.StringEntry.class.isAssignableFrom(what.type)) {
            return (T)this._getString(what);
        }
        if (ConfigKeeper.StringArrayEntry.class.isAssignableFrom(what.type)) {
            return (T)this._getStringArray(what);
        }
        return (T)this._get(what);
    }

    private <T> T _get(ConfigToken<T> what) {
        BCLib.LOGGER.error(what + " has unsupported Type.");
        return what.defaultValue;
    }

    public void set(ConfigToken<Boolean> what, boolean value) {
        this.setBoolean(what, value);
    }

    private Boolean _getBoolean(ConfigToken<Boolean> what, boolean raw) {
        if (!raw && !what.dependenciesTrue(this)) {
            return false;
        }
        return this.getBoolean(what, (Boolean)what.defaultValue);
    }

    public void set(ConfigToken<Integer> what, int value) {
        this.setInt(what, value);
    }

    private Integer _getInt(ConfigToken<Integer> what) {
        return this.getInt(what, (Integer)what.defaultValue);
    }

    public void set(ConfigToken<Float> what, float value) {
        this.setFloat(what, value);
    }

    private Float _getFloat(ConfigToken<Float> what) {
        return Float.valueOf(this.getFloat(what, ((Float)what.defaultValue).floatValue()));
    }

    public void set(ConfigToken<String> what, String value) {
        this.setString(what, value);
    }

    private String _getString(ConfigToken<String> what) {
        return this.getString(what, (String)what.defaultValue);
    }

    public void set(ConfigToken<List<String>> what, List<String> value) {
        this.setStringArray(what, value);
    }

    private List<String> _getStringArray(ConfigToken<List<String>> what) {
        return this.getStringArray(what, (List)what.defaultValue);
    }

    public static class ConfigToken<T>
    extends ConfigKey {
        public final T defaultValue;
        public final Class<?> type;

        protected ConfigToken(Class<?> type, T defaultValue, String entry, class_2960 path) {
            this(type, defaultValue, entry, path.method_12836(), path.method_12832());
        }

        protected ConfigToken(Class<?> type, T defaultValue, String entry, String ... path) {
            super(entry, path);
            this.defaultValue = defaultValue;
            this.type = type;
        }

        public boolean dependenciesTrue(NamedPathConfig config) {
            return true;
        }

        public static ConfigToken<Boolean> Boolean(boolean defaultValue, String entry, String path) {
            return new ConfigToken<Boolean>(ConfigKeeper.BooleanEntry.class, Boolean.valueOf(defaultValue), entry, path);
        }

        public static ConfigToken<Integer> Int(int defaultValue, String entry, String path) {
            return new ConfigToken<Integer>(ConfigKeeper.IntegerEntry.class, Integer.valueOf(defaultValue), entry, path);
        }

        public static ConfigToken<Float> Float(float defaultValue, String entry, String path) {
            return new ConfigToken<Float>(ConfigKeeper.FloatEntry.class, Float.valueOf(defaultValue), entry, path);
        }

        public static ConfigToken<String> String(String defaultValue, String entry, String path) {
            return new ConfigToken<String>(ConfigKeeper.StringEntry.class, defaultValue, entry, path);
        }

        public static ConfigToken<List<String>> StringArray(List<String> defaultValue, String entry, String path) {
            return new ConfigToken<List<String>>(ConfigKeeper.StringArrayEntry.class, defaultValue, entry, path);
        }
    }

    public static class ConfigTokenDescription<T> {
        public final ConfigToken<T> token;
        public final String internalName;
        public final Boolean hidden;
        public final int leftPadding;
        public final int topPadding;

        ConfigTokenDescription(Field fl) throws IllegalAccessException {
            this.token = (ConfigToken)fl.get(null);
            this.internalName = fl.getName();
            ConfigUI ui = fl.getAnnotation(ConfigUI.class);
            if (ui != null) {
                this.hidden = ui.hide();
                this.leftPadding = ui.leftPadding();
                this.topPadding = ui.topPadding();
            } else {
                this.hidden = false;
                this.leftPadding = 0;
                this.topPadding = 0;
            }
        }

        public String getPath() {
            StringBuilder path = new StringBuilder();
            for (String p : this.token.getPath()) {
                path.append(".").append(p);
            }
            path.append(".").append(this.token.getEntry());
            return path.toString();
        }
    }

    public static class DependendConfigToken<T>
    extends ConfigToken<T> {
        protected final Predicate<NamedPathConfig> dependenciesTrue;

        protected DependendConfigToken(Class<?> type, T defaultValue, String entry, class_2960 path, Predicate<NamedPathConfig> dependenciesTrue) {
            this(type, defaultValue, entry, new String[]{path.method_12836(), path.method_12832()}, dependenciesTrue);
        }

        protected DependendConfigToken(Class<?> type, T defaultValue, String entry, String path, Predicate<NamedPathConfig> dependenciesTrue) {
            super(type, defaultValue, entry, path);
            this.dependenciesTrue = dependenciesTrue;
        }

        protected DependendConfigToken(Class<?> type, T defaultValue, String entry, String[] path, Predicate<NamedPathConfig> dependenciesTrue) {
            super(type, defaultValue, entry, path);
            this.dependenciesTrue = dependenciesTrue;
        }

        @Override
        public boolean dependenciesTrue(NamedPathConfig config) {
            return this.dependenciesTrue.test(config);
        }

        public static DependendConfigToken<Boolean> Boolean(boolean defaultValue, String entry, String path, Predicate<NamedPathConfig> dependenciesTrue) {
            return new DependendConfigToken<Boolean>(ConfigKeeper.BooleanEntry.class, Boolean.valueOf(defaultValue), entry, path, dependenciesTrue);
        }
    }
}

