/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_5636;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.util.BackgroundInfo;
import org.betterx.bclib.util.MHelper;

public class CustomFogRenderer {
    private static final class_2338.class_2339 LAST_POS = new class_2338.class_2339(0, -100, 0);
    private static final class_2338.class_2339 MUT_POS = new class_2338.class_2339();
    private static final float[] FOG_DENSITY = new float[8];
    private static final int GRID_SIZE = 32;
    private static float fogStart = 0.0f;
    private static float fogEnd = 192.0f;

    public static boolean applyFogDensity(class_4184 camera, float viewDistance, boolean thickFog) {
        float fog;
        if (!Configs.CLIENT_CONFIG.renderCustomFog()) {
            return false;
        }
        class_5636 fogType = camera.method_19334();
        if (fogType != class_5636.field_27888) {
            BackgroundInfo.fogDensity = 1.0f;
            return false;
        }
        class_1297 entity = camera.method_19331();
        if (!CustomFogRenderer.isForcedDimension(entity.field_6002) && CustomFogRenderer.shouldIgnoreArea(entity.field_6002, (int)entity.method_23317(), (int)entity.method_23320(), (int)entity.method_23321())) {
            BackgroundInfo.fogDensity = 1.0f;
            return false;
        }
        BackgroundInfo.fogDensity = fog = CustomFogRenderer.getFogDensity(entity.field_6002, entity.method_23317(), entity.method_23320(), entity.method_23321());
        if (CustomFogRenderer.thickFog(thickFog, entity.field_6002)) {
            fogStart = viewDistance * 0.05f / fog;
            fogEnd = Math.min(viewDistance, 192.0f) * 0.5f / fog;
        } else {
            fogStart = viewDistance * 0.25f / fog;
            fogEnd = viewDistance / fog;
        }
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            class_1293 effect = livingEntity.method_6112(class_1294.field_5919);
            if (effect != null) {
                int duration = effect.method_5584();
                if (duration > 20) {
                    fogStart = 0.0f;
                    fogEnd *= 0.03f;
                    BackgroundInfo.blindness = 1.0f;
                } else {
                    float delta;
                    BackgroundInfo.blindness = delta = (float)duration / 20.0f;
                    fogStart = class_3532.method_16439((float)delta, (float)fogStart, (float)0.0f);
                    fogEnd = class_3532.method_16439((float)delta, (float)fogEnd, (float)(fogEnd * 0.03f));
                }
            } else {
                BackgroundInfo.blindness = 0.0f;
            }
        }
        RenderSystem.setShaderFogStart((float)fogStart);
        RenderSystem.setShaderFogEnd((float)fogEnd);
        return true;
    }

    private static boolean thickFog(boolean thickFog, class_1937 level) {
        if (!thickFog) {
            return false;
        }
        if (level.method_27983() == class_1937.field_25180) {
            return Configs.CLIENT_CONFIG.netherThickFog();
        }
        return true;
    }

    private static boolean isForcedDimension(class_1937 level) {
        return level.method_27983() == class_1937.field_25181 || level.method_27983() == class_1937.field_25180;
    }

    private static boolean shouldIgnoreArea(class_1937 level, int x, int y, int z) {
        for (int i = -8; i <= 8; i += 8) {
            for (int j = -8; j <= 8; j += 8) {
                if (CustomFogRenderer.shouldIgnore(level, x + i, y, z + j)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean shouldIgnore(class_1937 level, int x, int y, int z) {
        class_1959 biome = (class_1959)level.method_23753((class_2338)MUT_POS.method_10103(x, y, z)).comp_349();
        return BiomeAPI.getRenderBiome(biome) == BiomeAPI.EMPTY_BIOME;
    }

    private static float getFogDensityI(class_1937 level, int x, int y, int z) {
        class_1959 biome = (class_1959)level.method_23753((class_2338)MUT_POS.method_10103(x, y, z)).comp_349();
        BCLBiome renderBiome = BiomeAPI.getRenderBiome(biome);
        return renderBiome.getFogDensity();
    }

    private static float getFogDensity(class_1937 level, double x, double y, double z) {
        int x1 = MHelper.floor(x / 32.0) * 32;
        int y1 = MHelper.floor(y / 32.0) * 32;
        int z1 = MHelper.floor(z / 32.0) * 32;
        float dx = (float)(x - (double)x1) / 32.0f;
        float dy = (float)(y - (double)y1) / 32.0f;
        float dz = (float)(z - (double)z1) / 32.0f;
        if (LAST_POS.method_10263() != x1 || LAST_POS.method_10264() != y1 || LAST_POS.method_10260() != z1) {
            int x2 = x1 + 32;
            int y2 = y1 + 32;
            int z2 = z1 + 32;
            LAST_POS.method_10103(x1, y1, z1);
            CustomFogRenderer.FOG_DENSITY[0] = CustomFogRenderer.getFogDensityI(level, x1, y1, z1);
            CustomFogRenderer.FOG_DENSITY[1] = CustomFogRenderer.getFogDensityI(level, x2, y1, z1);
            CustomFogRenderer.FOG_DENSITY[2] = CustomFogRenderer.getFogDensityI(level, x1, y2, z1);
            CustomFogRenderer.FOG_DENSITY[3] = CustomFogRenderer.getFogDensityI(level, x2, y2, z1);
            CustomFogRenderer.FOG_DENSITY[4] = CustomFogRenderer.getFogDensityI(level, x1, y1, z2);
            CustomFogRenderer.FOG_DENSITY[5] = CustomFogRenderer.getFogDensityI(level, x2, y1, z2);
            CustomFogRenderer.FOG_DENSITY[6] = CustomFogRenderer.getFogDensityI(level, x1, y2, z2);
            CustomFogRenderer.FOG_DENSITY[7] = CustomFogRenderer.getFogDensityI(level, x2, y2, z2);
        }
        float a = class_3532.method_16439((float)dx, (float)FOG_DENSITY[0], (float)FOG_DENSITY[1]);
        float b = class_3532.method_16439((float)dx, (float)FOG_DENSITY[2], (float)FOG_DENSITY[3]);
        float c = class_3532.method_16439((float)dx, (float)FOG_DENSITY[4], (float)FOG_DENSITY[5]);
        float d = class_3532.method_16439((float)dx, (float)FOG_DENSITY[6], (float)FOG_DENSITY[7]);
        a = class_3532.method_16439((float)dy, (float)a, (float)b);
        b = class_3532.method_16439((float)dy, (float)c, (float)d);
        return class_3532.method_16439((float)dz, (float)a, (float)b);
    }
}

