/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4730;
import net.minecraft.class_773;
import net.minecraft.class_793;
import net.minecraft.class_816;
import org.betterx.bclib.api.v2.ModIntegrationAPI;
import org.betterx.bclib.client.render.EmissiveTextureInfo;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.ItemModelProvider;

public class CustomModelBakery {
    private final Map<class_2960, class_1100> models = Maps.newConcurrentMap();

    public class_1100 getBlockModel(class_2960 location) {
        return this.models.get(location);
    }

    public class_1100 getItemModel(class_2960 location) {
        class_2960 storageID = new class_2960(location.method_12836(), "models/item/" + location.method_12832() + ".json");
        return this.models.get(location);
    }

    public void loadCustomModels(class_3300 resourceManager) {
        ((Stream)class_2378.field_11146.method_10220().parallel()).filter(block -> block instanceof BlockModelProvider).forEach(block -> {
            class_2960 blockID = class_2378.field_11146.method_10221(block);
            class_2960 storageID = new class_2960(blockID.method_12836(), "blockstates/" + blockID.method_12832() + ".json");
            if (resourceManager.method_14486(storageID).isEmpty()) {
                this.addBlockModel(blockID, (class_2248)block);
            }
            if (resourceManager.method_14486(storageID = new class_2960(blockID.method_12836(), "models/item/" + blockID.method_12832() + ".json")).isEmpty()) {
                this.addItemModel(blockID, (ItemModelProvider)block);
            }
        });
        ((Stream)class_2378.field_11142.method_10220().parallel()).filter(item -> item instanceof ItemModelProvider).forEach(item -> {
            class_2960 registryID = class_2378.field_11142.method_10221(item);
            class_2960 storageID = new class_2960(registryID.method_12836(), "models/item/" + registryID.method_12832() + ".json");
            if (resourceManager.method_14486(storageID).isEmpty()) {
                this.addItemModel(registryID, (ItemModelProvider)item);
            }
        });
    }

    private void addBlockModel(class_2960 blockID, class_2248 block) {
        BlockModelProvider provider = (BlockModelProvider)block;
        ImmutableList states = block.method_9595().method_11662();
        class_2680 defaultState = block.method_9564();
        class_1091 defaultStateID = class_773.method_3336((class_2960)blockID, (class_2680)defaultState);
        class_1100 defaultModel = provider.getModelVariant((class_2960)defaultStateID, defaultState, this.models);
        if (defaultModel instanceof class_816) {
            states.forEach(blockState -> {
                class_1091 stateID = class_773.method_3336((class_2960)blockID, (class_2680)blockState);
                this.models.put((class_2960)stateID, defaultModel);
            });
        } else {
            states.forEach(arg_0 -> this.lambda$addBlockModel$5(blockID, (class_2960)defaultStateID, defaultModel, provider, arg_0));
        }
    }

    private void addItemModel(class_2960 itemID, ItemModelProvider provider) {
        class_1091 modelLocation = new class_1091(itemID.method_12836(), itemID.method_12832(), "inventory");
        if (this.models.containsKey(modelLocation)) {
            return;
        }
        class_793 model = provider.getItemModel((class_2960)modelLocation);
        this.models.put((class_2960)modelLocation, (class_1100)model);
    }

    public static void loadEmissiveModels(Map<class_2960, class_1100> unbakedCache) {
        if (!ModIntegrationAPI.hasCanvas()) {
            return;
        }
        HashMap<class_2960, class_1100> cacheCopy = new HashMap<class_2960, class_1100>(unbakedCache);
        Set strings = Sets.newConcurrentHashSet();
        class_2378.field_11146.method_10235().forEach(blockID -> {
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(blockID);
            ImmutableList states = block.method_9595().method_11662();
            boolean addBlock = false;
            for (class_2680 state : states) {
                Collection materials;
                class_1091 stateID = class_773.method_3336((class_2960)blockID, (class_2680)state);
                class_1100 model = (class_1100)cacheCopy.get(stateID);
                if (model == null || (materials = model.method_4754(cacheCopy::get, strings)) == null) continue;
                for (class_4730 material : materials) {
                    if (!EmissiveTextureInfo.isEmissiveTexture(material.method_24147())) continue;
                    addBlock = true;
                    break;
                }
                if (!addBlock) continue;
                break;
            }
            if (addBlock) {
                EmissiveTextureInfo.addBlock(blockID);
            }
        });
    }

    private /* synthetic */ void lambda$addBlockModel$5(class_2960 blockID, class_2960 defaultStateID, class_1100 defaultModel, BlockModelProvider provider, class_2680 blockState) {
        class_1091 stateID = class_773.method_3336((class_2960)blockID, (class_2680)blockState);
        class_1100 model = stateID.equals((Object)defaultStateID) ? defaultModel : provider.getModelVariant((class_2960)stateID, blockState, this.models);
        this.models.put((class_2960)stateID, model);
    }
}

