/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.gui.screens;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.HelloClient;
import org.betterx.bclib.client.gui.gridlayout.GridColumn;
import org.betterx.bclib.client.gui.gridlayout.GridLayout;
import org.betterx.bclib.client.gui.gridlayout.GridRow;
import org.betterx.bclib.client.gui.gridlayout.GridScreen;
import org.betterx.bclib.client.gui.screens.BCLibScreen;
import org.betterx.bclib.util.ModUtil;
import org.betterx.bclib.util.PathUtil;
import org.betterx.bclib.util.Triple;

@Environment(value=EnvType.CLIENT)
public class ModListScreen
extends BCLibScreen {
    private final List<ModUtil.ModInfo> mods;
    private final HelloClient.IServerModMap serverInfo;
    private final class_2561 description;
    private final class_2561 buttonTitle;

    private static List<ModUtil.ModInfo> extractModList(Map<String, ModUtil.ModInfo> mods) {
        LinkedList<ModUtil.ModInfo> list = new LinkedList<ModUtil.ModInfo>();
        ModUtil.getMods().forEach((id, info) -> list.add((ModUtil.ModInfo)info));
        return list;
    }

    public ModListScreen(class_437 parent, class_2561 title, class_2561 description, Map<String, ModUtil.ModInfo> mods, HelloClient.IServerModMap serverInfo) {
        this(parent, title, description, class_5244.field_24339, mods, serverInfo);
    }

    public ModListScreen(class_437 parent, class_2561 title, class_2561 description, List<ModUtil.ModInfo> mods, HelloClient.IServerModMap serverInfo) {
        this(parent, title, description, class_5244.field_24339, mods, serverInfo);
    }

    public ModListScreen(class_437 parent, class_2561 title, class_2561 description, class_2561 button, Map<String, ModUtil.ModInfo> mods, HelloClient.IServerModMap serverInfo) {
        this(parent, title, description, button, ModListScreen.extractModList(mods), serverInfo);
    }

    public ModListScreen(class_437 parent, class_2561 title, class_2561 description, class_2561 button, List<ModUtil.ModInfo> mods, HelloClient.IServerModMap serverInfo) {
        super(parent, title, 10, true);
        this.mods = mods;
        this.serverInfo = serverInfo;
        this.description = description;
        this.buttonTitle = button;
    }

    public static List<String> localMissing(HelloClient.IServerModMap serverInfo) {
        return serverInfo.keySet().stream().filter(modid -> !ModUtil.getMods().keySet().stream().filter(mod -> mod.equals(modid)).findFirst().isPresent()).collect(Collectors.toList());
    }

    public static List<String> serverMissing(HelloClient.IServerModMap serverInfo) {
        return ModUtil.getMods().entrySet().stream().filter(entry -> ((ModUtil.ModInfo)entry.getValue()).metadata.getEnvironment() != ModEnvironment.CLIENT).map(entry -> (String)entry.getKey()).filter(modid -> !serverInfo.keySet().stream().filter(mod -> mod.equals(modid)).findFirst().isPresent()).collect(Collectors.toList());
    }

    public static void addModDesc(GridColumn grid, List<ModUtil.ModInfo> mods, HelloClient.IServerModMap serverInfo, GridScreen parent) {
        int STATE_OK = 6;
        int STATE_SERVER_MISSING_CLIENT_MOD = 5;
        int STATE_MISSING_NOT_OFFERED = 4;
        int STATE_VERSION_CLIENT_ONLY = 7;
        int STATE_VERSION_NOT_OFFERED = 3;
        int STATE_VERSION = 2;
        boolean STATE_SERVER_MISSING = true;
        boolean STATE_MISSING = false;
        LinkedList items = new LinkedList();
        if (serverInfo != null) {
            serverInfo.keySet().stream().filter(modid -> !mods.stream().filter(mod -> mod.metadata.getId().equals(modid)).findFirst().isPresent()).forEach(modid -> {
                HelloClient.OfferedModInfo nfo = (HelloClient.OfferedModInfo)serverInfo.get(modid);
                Object stateString = nfo.version();
                if (nfo.size() > 0) {
                    stateString = "Version: " + (String)stateString + ", Size: " + PathUtil.humanReadableFileSize(nfo.size());
                }
                if (nfo.canDownload()) {
                    stateString = (String)stateString + ", offered by server";
                }
                items.add(new Triple<String, Integer, Object>((String)modid, nfo.canDownload() ? 0 : 4, stateString));
            });
        }
        mods.forEach(mod -> {
            String serverVersion = null;
            int serverSize = 0;
            int state = 6;
            if (serverInfo != null) {
                String modID = mod.metadata.getId();
                HelloClient.OfferedModInfo data = (HelloClient.OfferedModInfo)serverInfo.get(modID);
                if (data != null) {
                    String modVer = data.version();
                    int size = data.size();
                    if (!modVer.equals(mod.getVersion())) {
                        state = mod.metadata.getEnvironment() == ModEnvironment.CLIENT ? 7 : (data.canDownload() ? 2 : 3);
                        serverVersion = modVer;
                        serverSize = size;
                    }
                } else {
                    state = mod.metadata.getEnvironment() == ModEnvironment.CLIENT ? 5 : 1;
                }
            }
            Object stateString = mod.metadata.getVersion().toString();
            if (serverVersion != null) {
                stateString = "Client: " + (String)stateString;
                stateString = (String)stateString + ", Server: " + serverVersion;
                if (serverSize > 0) {
                    stateString = (String)stateString + ", Size: " + PathUtil.humanReadableFileSize(serverSize);
                }
            }
            if (mod.metadata.getEnvironment() == ModEnvironment.CLIENT) {
                stateString = (String)stateString + ", client-only";
            } else if (mod.metadata.getEnvironment() == ModEnvironment.SERVER) {
                stateString = (String)stateString + ", server-only";
            }
            items.add(new Triple<String, Integer, Object>(mod.metadata.getName(), state, stateString));
        });
        items.stream().sorted(Comparator.comparing(a -> a.second + ((String)a.first).toLowerCase(Locale.ROOT))).forEach(t -> {
            String typeText;
            String name = (String)t.first;
            int state = (Integer)t.second;
            String stateString = (String)t.third;
            int color = -2416824;
            if (state == 2 || state == 3 || state == 7) {
                typeText = "[VERSION]";
                if (state == 3) {
                    color = -339924;
                } else if (state == 7) {
                    color = -16744704;
                }
            } else if (state == 0 || state == 4) {
                typeText = "[MISSING]";
                if (state == 4) {
                    color = -339924;
                }
            } else if (state == 1 || state == 5) {
                if (state == 5) {
                    color = -16673638;
                    typeText = "[OK]";
                } else {
                    typeText = "[NOT ON SERVER]";
                }
            } else {
                color = -16744704;
                typeText = "[OK]";
            }
            class_5250 dash = class_2561.method_43470((String)"-");
            class_5250 typeTextComponent = class_2561.method_43470((String)typeText);
            GridRow row = grid.addRow();
            row.addString((class_2561)dash, parent);
            row.addSpacer(4);
            row.addString((class_2561)class_2561.method_43470((String)name), parent);
            row.addSpacer(4);
            row.addString((class_2561)typeTextComponent, color, parent);
            if (!stateString.isEmpty()) {
                row = grid.addRow();
                row.addSpacer(4 + parent.getWidth((class_2561)dash));
                row.addString((class_2561)class_2561.method_43470((String)stateString), -8421505, parent);
            }
            grid.addSpacerRow();
        });
    }

    @Override
    protected void initLayout() {
        if (this.description != null) {
            this.grid.addSpacerRow();
            this.grid.addRow().addMessage(this.description, this.field_22793, GridLayout.Alignment.CENTER);
            this.grid.addSpacerRow(8);
        }
        GridRow row = this.grid.addRow();
        row.addSpacer(10);
        GridColumn col = row.addColumn(200.0, GridLayout.GridValueType.CONSTANT);
        ModListScreen.addModDesc(col, this.mods, this.serverInfo, this);
        this.grid.addSpacerRow(8);
        row = this.grid.addRow();
        row.addFiller();
        row.addButton(this.buttonTitle, 20.0, this.field_22793, n -> this.method_25419());
        row.addFiller();
    }
}

