/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.gui.gridlayout;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.betterx.bclib.client.gui.gridlayout.GridLayout;
import org.betterx.bclib.util.Pair;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class GridScreen
extends class_437 {
    protected GridLayout grid = null;
    public final int topPadding;
    public final int sidePadding;
    public final boolean centerVertically;
    @Nullable
    public final class_437 parent;
    protected int scrollPos = 0;
    private boolean scrolling = false;
    private static final int SCROLLER_WIDTH = 6;

    public GridScreen(class_2561 title) {
        this(null, title);
    }

    public GridScreen(@Nullable class_437 parent, class_2561 title) {
        this(parent, title, 0, true);
    }

    public GridScreen(class_2561 title, int topPadding, boolean centerVertically) {
        this(null, title, topPadding, 20, centerVertically);
    }

    public GridScreen(@Nullable class_437 parent, class_2561 title, int topPadding, boolean centerVertically) {
        this(parent, title, topPadding, 20, centerVertically);
    }

    public GridScreen(class_2561 title, int topPadding, int sidePadding, boolean centerVertically) {
        this(null, title, topPadding, sidePadding, centerVertically);
    }

    public GridScreen(@Nullable class_437 parent, class_2561 title, int topPadding, int sidePadding, boolean centerVertically) {
        super(title);
        this.parent = parent;
        this.topPadding = topPadding;
        this.sidePadding = sidePadding;
        this.centerVertically = centerVertically;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public class_327 getFont() {
        return this.field_22793;
    }

    public boolean method_25421() {
        return true;
    }

    public <T extends class_364 & class_4068> T method_37063(T guiEventListener) {
        return (T)super.method_37063(guiEventListener);
    }

    protected void addTitle() {
        this.grid.addRow().addString(this.field_22785, GridLayout.Alignment.CENTER, this);
        this.grid.addSpacerRow(15);
    }

    protected final void method_25426() {
        super.method_25426();
        this.grid = new GridLayout(this, this.topPadding, this.sidePadding, this.centerVertically);
        this.addTitle();
        this.initLayout();
        this.grid.finalizeLayout();
    }

    protected abstract void initLayout();

    protected void renderScreen(class_4587 poseStack, int i, int j, float f) {
        super.method_25394(poseStack, i, j, f);
    }

    public void method_25394(class_4587 poseStack, int i, int j, float f) {
        this.method_25434(i);
        this.renderGrid(poseStack);
        super.method_25394(poseStack, i, j, f);
    }

    protected void renderGrid(class_4587 poseStack) {
        if (this.grid != null) {
            if (this.isScrollable()) {
                for (Pair<class_339, Integer> item : this.grid.movableWidgets) {
                    ((class_339)item.first).field_22761 = (Integer)item.second + this.scrollPos;
                }
                this.renderScroll(poseStack);
                poseStack.method_22903();
                poseStack.method_22904(0.0, (double)this.scrollPos, 0.0);
                this.grid.render(poseStack);
                poseStack.method_22909();
            } else {
                this.grid.render(poseStack);
            }
        }
    }

    public static int getWidth(class_2561 text, class_327 font) {
        return font.method_30880(text.method_30937());
    }

    public int getWidth(class_2561 text) {
        return GridScreen.getWidth(text, this.getFont());
    }

    public void setScrollPos(int sp) {
        this.scrollPos = Math.max(this.getMaxScrollPos(), Math.min(0, sp));
    }

    public int getScrollPos() {
        return this.scrollPos;
    }

    public int getScrollHeight() {
        if (this.grid != null) {
            return this.grid.getHeight() + this.topPadding;
        }
        return this.field_22790;
    }

    public int getMaxScrollPos() {
        return this.field_22790 - (this.getScrollHeight() + this.topPadding);
    }

    public boolean isScrollable() {
        return this.field_22790 < this.getScrollHeight();
    }

    public boolean isMouseOverScroller(double x, double y) {
        return y >= 0.0 && y <= (double)this.field_22790 && x >= (double)(this.field_22789 - 6) && x <= (double)this.field_22789;
    }

    protected void updateScrollingState(double x, double y, int i) {
        this.scrolling = i == 0 && x >= (double)(this.field_22789 - 6) && x < (double)this.field_22789;
    }

    private void renderScroll(class_4587 poseStack) {
        int y1 = this.field_22790;
        boolean y0 = false;
        int yd = y1 - 0;
        int maxPosition = this.getScrollHeight() + this.topPadding;
        int x0 = this.field_22789 - 6;
        int x1 = this.field_22789;
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        RenderSystem.disableTexture();
        RenderSystem.setShader(class_757::method_34540);
        int widgetHeight = (int)((float)(yd * yd) / (float)maxPosition);
        widgetHeight = class_3532.method_15340((int)widgetHeight, (int)32, (int)(yd - 8));
        float relPos = (float)this.getScrollPos() / (float)this.getMaxScrollPos();
        int top = (int)(relPos * (float)(yd - widgetHeight)) + 0;
        if (top < 0) {
            top = 0;
        }
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22912((double)x0, (double)y1, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)x1, (double)y1, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)x1, 0.0, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)x0, 0.0, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)x0, (double)(top + widgetHeight), 0.0).method_1336(128, 128, 128, 255).method_1344();
        bufferBuilder.method_22912((double)x1, (double)(top + widgetHeight), 0.0).method_1336(128, 128, 128, 255).method_1344();
        bufferBuilder.method_22912((double)x1, (double)top, 0.0).method_1336(128, 128, 128, 255).method_1344();
        bufferBuilder.method_22912((double)x0, (double)top, 0.0).method_1336(128, 128, 128, 255).method_1344();
        bufferBuilder.method_22912((double)x0, (double)(top + widgetHeight - 1), 0.0).method_1336(192, 192, 192, 255).method_1344();
        bufferBuilder.method_22912((double)(x1 - 1), (double)(top + widgetHeight - 1), 0.0).method_1336(192, 192, 192, 255).method_1344();
        bufferBuilder.method_22912((double)(x1 - 1), (double)top, 0.0).method_1336(192, 192, 192, 255).method_1344();
        bufferBuilder.method_22912((double)x0, (double)top, 0.0).method_1336(192, 192, 192, 255).method_1344();
        tesselator.method_1350();
    }

    public boolean method_25402(double x, double y, int i) {
        this.updateScrollingState(x, y, i);
        if (this.scrolling) {
            return true;
        }
        return super.method_25402(x, y, i);
    }

    public boolean method_25403(double xAbs, double yAbs, int i, double dX, double dY) {
        if (super.method_25403(xAbs, yAbs, i, dX, dY)) {
            return true;
        }
        if (i == 0 && this.scrolling) {
            if (yAbs < 0.0) {
                this.setScrollPos(0);
            } else if (yAbs > (double)this.field_22790) {
                this.setScrollPos(this.getMaxScrollPos());
            } else {
                this.setScrollPos((int)((double)this.getScrollPos() - dY * 2.0));
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double d, double e, double f) {
        if (this.isScrollable()) {
            this.setScrollPos((int)((double)this.scrollPos + f * 10.0));
        }
        return true;
    }

    public boolean method_25404(int keyCode, int j, int k) {
        if (super.method_25404(keyCode, j, k)) {
            return true;
        }
        if (keyCode == 264) {
            this.method_25401(0.0, -1.0, 0.0);
            return true;
        }
        if (keyCode == 265) {
            this.method_25401(0.0, 1.0, 0.0);
            return true;
        }
        return false;
    }
}

