/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.gui.gridlayout;

import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import net.minecraft.class_5489;
import org.betterx.bclib.client.gui.gridlayout.GridCell;
import org.betterx.bclib.client.gui.gridlayout.GridElement;
import org.betterx.bclib.client.gui.gridlayout.GridLayout;
import org.betterx.bclib.client.gui.gridlayout.GridTransform;

@Environment(value=EnvType.CLIENT)
public class GridMessageCell
extends GridCell {
    private final class_327 font;
    private class_2561 text;
    private class_5489 lastLabel;
    private GridTransform lastTransform;

    GridMessageCell(double width, GridLayout.GridValueType widthType, GridLayout.Alignment contentAlignment, class_327 font, class_2561 text) {
        this(width, widthType, contentAlignment, font, text, -1);
    }

    GridMessageCell(double width, GridLayout.GridValueType widthType, GridLayout.Alignment contentAlignment, class_327 font, class_2561 text, int color) {
        super(width, -1.0, widthType, null, null);
        this.font = font;
        this.text = text;
        this.customRender = (poseStack, transform, context) -> {
            if (contentAlignment == GridLayout.Alignment.CENTER) {
                int n = transform.width / 2 + transform.left;
                int n2 = transform.top;
                Objects.requireNonNull(font);
                this.lastLabel.method_30889(poseStack, n, n2, 9, color);
            } else if (contentAlignment == GridLayout.Alignment.LEFT) {
                int n = transform.left;
                int n3 = transform.top;
                Objects.requireNonNull(font);
                this.lastLabel.method_30893(poseStack, n, n3, 9, color);
            }
        };
    }

    public void setText(class_2561 text) {
        this.text = text;
        if (this.lastTransform != null) {
            this.create(this.lastTransform);
        }
    }

    private class_5489 getLabel(GridTransform transform) {
        return this.lastLabel;
    }

    protected void create(GridTransform transform) {
        this.lastTransform = transform;
        this.lastLabel = class_5489.method_30890((class_327)this.font, (class_5348)this.text, (int)transform.width);
    }

    @Override
    protected GridElement buildElementAt(int left, int top, int width, List<GridElement> collector) {
        this.create(new GridTransform(left, top, width, 0));
        int promptLines = this.lastLabel.method_30887() + 1;
        int height = promptLines * 9;
        return new GridElement(left, top, width, height, this::getLabel, this.customRender);
    }
}

