/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.gui.gridlayout;

import java.util.LinkedList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_339;
import net.minecraft.class_4587;
import org.betterx.bclib.client.gui.gridlayout.GridColumn;
import org.betterx.bclib.client.gui.gridlayout.GridElement;
import org.betterx.bclib.client.gui.gridlayout.GridScreen;
import org.betterx.bclib.client.gui.gridlayout.GridTransform;
import org.betterx.bclib.util.Pair;

@Environment(value=EnvType.CLIENT)
public class GridLayout
extends GridColumn {
    public static final int COLOR_WHITE = -1;
    public static final int COLOR_RED = -2416824;
    public static final int COLOR_CYAN = -16673638;
    public static final int COLOR_GREEN = -16711936;
    public static final int COLOR_DARK_GREEN = -16744704;
    public static final int COLOR_YELLOW = -339924;
    public static final int COLOR_BLUE = -16776961;
    public static final int COLOR_GRAY = -8421505;
    public final GridScreen screen;
    public final int screenHeight;
    public final int sidePadding;
    public final int initialTopPadding;
    public final boolean centerVertically;
    private int height;
    private int topPadding;
    private List<GridElement> elements;
    public List<Pair<class_339, Integer>> movableWidgets = new LinkedList<Pair<class_339, Integer>>();

    public GridLayout(GridScreen screen) {
        this(screen, 0, true);
    }

    public GridLayout(GridScreen screen, int topPadding, boolean centerVertically) {
        this(screen, topPadding, 20, centerVertically);
    }

    public GridLayout(GridScreen screen, int topPadding, int sidePadding, boolean centerVertically) {
        super(screen.field_22789 - 2 * sidePadding, GridValueType.CONSTANT);
        this.screen = screen;
        this.screenHeight = screen.field_22790;
        this.height = 0;
        this.topPadding = topPadding;
        this.sidePadding = sidePadding;
        this.initialTopPadding = topPadding;
        this.centerVertically = centerVertically;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTopPadding() {
        return this.topPadding;
    }

    void buildLayout() {
        this.elements = new LinkedList<GridElement>();
        GridElement el = this.buildElement((int)this.width, 0, 1.0f, 0, 0, this.elements);
        this.height = el.height;
        this.topPadding = this.centerVertically && el.height + this.initialTopPadding < this.screenHeight ? this.screenHeight - el.height >> 1 : this.initialTopPadding;
    }

    public void finalizeLayout() {
        this.buildLayout();
        this.elements.stream().filter(element -> element.componentPlacer != null).forEach(element -> {
            GridTransform transform = element.transformWithPadding(this.sidePadding, this.topPadding);
            Object context = element.componentPlacer.apply(transform);
            if (element.customRender != null) {
                element.renderContext = context;
            } else if (context instanceof class_339) {
                class_339 widget = (class_339)context;
                this.movableWidgets.add(new Pair<class_339, Integer>(widget, widget.field_22761));
                this.screen.method_37063(widget);
            }
        });
    }

    public void render(class_4587 poseStack) {
        if (this.elements == null) {
            return;
        }
        this.elements.stream().filter(element -> element.customRender != null).forEach(element -> element.customRender.accept(poseStack, element.transformWithPadding(this.sidePadding, this.topPadding), element.renderContext));
    }

    public static enum GridValueType {
        CONSTANT,
        PERCENTAGE,
        FILL,
        INHERIT;

    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum VerticalAlignment {
        TOP,
        CENTER,
        BOTTOM;

    }
}

