/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.gui.gridlayout;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.betterx.bclib.client.gui.gridlayout.GridElement;
import org.betterx.bclib.client.gui.gridlayout.GridLayout;

@Environment(value=EnvType.CLIENT)
abstract class GridCellDefinition {
    public final float width;
    public final GridLayout.GridValueType widthType;

    public GridCellDefinition(double width, GridLayout.GridValueType widthType) {
        this.width = (float)width;
        this.widthType = widthType;
    }

    public int calculateWidth(int parentWidth) {
        if (this.widthType == GridLayout.GridValueType.CONSTANT) {
            return (int)this.width;
        }
        if (this.widthType == GridLayout.GridValueType.PERCENTAGE) {
            return (int)(this.width * (float)parentWidth);
        }
        return 0;
    }

    final GridElement buildElement(int parentWidth, int autoWidth, float autoWidthSum, int left, int top, List<GridElement> collector) {
        int width = this.widthType == GridLayout.GridValueType.FILL ? (int)(this.width / autoWidthSum * (float)autoWidth) : this.calculateWidth(parentWidth);
        GridElement el = this.buildElementAt(left, top, width, collector);
        if (collector != null) {
            collector.add(el);
        }
        return el;
    }

    protected abstract GridElement buildElementAt(int var1, int var2, int var3, List<GridElement> var4);
}

