/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.tag;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3497;
import net.minecraft.class_3503;
import net.minecraft.class_3505;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.biomes.InternalBiomeAPI;

public class TagType<T> {
    boolean isFrozen = false;
    public final String directory;
    private final Map<class_2960, Set<class_3497>> tags = Maps.newConcurrentMap();
    public final class_5321<? extends class_2378<T>> registryKey;
    private final Function<T, class_2960> locationProvider;

    private TagType(class_5321<? extends class_2378<T>> registry, String directory, Function<T, class_2960> locationProvider) {
        this.registryKey = registry;
        this.directory = directory;
        this.locationProvider = locationProvider;
    }

    protected void initializeTag(class_2960 tagID) {
        this.getSetForTag(tagID);
    }

    public Set<class_3497> getSetForTag(class_2960 tagID) {
        return this.tags.computeIfAbsent(tagID, k -> Sets.newHashSet());
    }

    public Set<class_3497> getSetForTag(class_6862<T> tag) {
        if (tag == null) {
            return new HashSet<class_3497>();
        }
        return this.getSetForTag(tag.comp_327());
    }

    public class_6862<T> makeTag(class_2960 id) {
        return this.creatTagKey(id);
    }

    protected class_6862<T> creatTagKey(class_2960 id) {
        this.initializeTag(id);
        return class_6862.method_40092(this.registryKey, (class_2960)id);
    }

    public class_6862<T> makeCommonTag(String name) {
        return this.creatTagKey(new class_2960("c", name));
    }

    public void addUntyped(class_6862<T> tagID, class_2960 ... elements) {
        if (this.isFrozen) {
            BCLib.LOGGER.warning("Adding Tag " + tagID + " after the API was frozen.", new Object[0]);
        }
        Set<class_3497> set = this.getSetForTag(tagID);
        for (class_2960 id : elements) {
            if (id == null) continue;
            set.add(class_3497.method_43937((class_2960)id));
        }
    }

    public void addUntyped(class_2960 element, class_6862<T> ... tagIDs) {
        for (class_6862<T> tagID : tagIDs) {
            this.addUntyped(tagID, element);
        }
    }

    public void addOtherTags(class_6862<T> tagID, class_6862<T> ... tags) {
        if (this.isFrozen) {
            BCLib.LOGGER.warning("Adding Tag " + tagID + " after the API was frozen.", new Object[0]);
        }
        Set<class_3497> set = this.getSetForTag(tagID);
        for (class_6862<T> tag : tags) {
            class_2960 id = tag.comp_327();
            if (id == null) continue;
            set.add(class_3497.method_43945((class_2960)id));
        }
    }

    protected void add(class_6862<T> tagID, T ... elements) {
        if (this.isFrozen) {
            BCLib.LOGGER.warning("Adding Tag " + tagID + " after the API was frozen.", new Object[0]);
        }
        Set<class_3497> set = this.getSetForTag(tagID);
        for (T element : elements) {
            class_2960 id = this.locationProvider.apply(element);
            if (id == null) continue;
            set.add(class_3497.method_43937((class_2960)id));
        }
    }

    protected void add(T element, class_6862<T> ... tagIDs) {
        for (class_6862<T> tagID : tagIDs) {
            this.add(tagID, element);
        }
    }

    @Deprecated(forRemoval=true)
    protected void add(class_2960 tagID, T ... elements) {
        if (this.isFrozen) {
            BCLib.LOGGER.warning("Adding Tag " + tagID + " after the API was frozen.", new Object[0]);
        }
        Set<class_3497> set = this.getSetForTag(tagID);
        for (T element : elements) {
            class_2960 id = this.locationProvider.apply(element);
            if (id == null) continue;
            set.add(class_3497.method_43937((class_2960)id));
        }
    }

    @Deprecated(forRemoval=true)
    protected void add(T element, class_2960 ... tagIDs) {
        for (class_2960 tagID : tagIDs) {
            this.add(tagID, element);
        }
    }

    public void forEach(BiConsumer<class_2960, Set<class_3497>> consumer) {
        this.tags.forEach(consumer);
    }

    public void apply(Map<class_2960, List<class_3503.class_5145>> tagsMap) {
        if (class_2378.field_25114.equals(this.registryKey)) {
            InternalBiomeAPI._runBiomeTagAdders();
        }
        this.forEach((id, ids) -> TagType.apply(id, tagsMap.computeIfAbsent((class_2960)id, key -> Lists.newArrayList()), ids));
    }

    private static List<class_3503.class_5145> apply(class_2960 id, List<class_3503.class_5145> builder, Set<class_3497> ids) {
        ids.forEach((? super T value) -> builder.add(new class_3503.class_5145(value, "bclib")));
        return builder;
    }

    public static class UnTyped<T>
    extends TagType<T> {
        UnTyped(class_5321<? extends class_2378<T>> registry, String directory) {
            super(registry, directory, t -> {
                throw new RuntimeException("Using Untyped TagType with Type-Dependant access. ");
            });
        }
    }

    public static class Simple<T>
    extends TagType<T> {
        Simple(class_5321<? extends class_2378<T>> registry, String directory, Function<T, class_2960> locationProvider) {
            super(registry, directory, locationProvider);
        }

        @Override
        public void add(class_6862<T> tagID, T ... elements) {
            super.add(tagID, elements);
        }

        @Override
        public void add(T element, class_6862<T> ... tagIDs) {
            super.add(element, tagIDs);
        }

        @Override
        @Deprecated(forRemoval=true)
        public void add(class_2960 tagID, T ... elements) {
            super.add(tagID, elements);
        }

        @Override
        @Deprecated(forRemoval=true)
        public void add(T element, class_2960 ... tagIDs) {
            super.add(element, tagIDs);
        }
    }

    public static class RegistryBacked<T>
    extends Simple<T> {
        private final class_2348<T> registry;

        RegistryBacked(class_2348<T> registry) {
            super(registry.method_30517(), class_3505.method_40099((class_5321)registry.method_30517()), element -> {
                class_2960 id = registry.method_10221(element);
                if (id != registry.method_10137()) {
                    return id;
                }
                return null;
            });
            this.registry = registry;
        }

        @Override
        public class_6862<T> makeTag(class_2960 id) {
            this.initializeTag(id);
            return this.registry.method_40273().filter(tagKey -> tagKey.comp_327().equals((Object)id)).findAny().orElse(class_6862.method_40092((class_5321)this.registry.method_30517(), (class_2960)id));
        }
    }
}

