/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.tag;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3503;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.tag.CommonBlockTags;
import org.betterx.bclib.api.v2.tag.CommonItemTags;
import org.betterx.bclib.api.v2.tag.TagType;
import org.betterx.bclib.mixin.common.DiggerItemAccessor;

public class TagAPI {
    private static final Map<String, TagType<?>> TYPES = Maps.newHashMap();
    public static TagType.RegistryBacked<class_2248> BLOCKS = TagAPI.registerType(class_2378.field_11146);
    public static TagType.RegistryBacked<class_1792> ITEMS = TagAPI.registerType(class_2378.field_11142);
    public static TagType.Simple<class_1959> BIOMES = TagAPI.registerType(class_2378.field_25114, "tags/worldgen/biome", b -> BiomeAPI.getBiomeID(b));

    public static <T> TagType.RegistryBacked<T> registerType(class_2348<T> registry) {
        TagType.RegistryBacked type = new TagType.RegistryBacked(registry);
        return (TagType.RegistryBacked)TYPES.computeIfAbsent(type.directory, dir -> type);
    }

    public static <T> TagType.Simple<T> registerType(class_2378<T> registry, String directory) {
        return TagAPI.registerType(registry.method_30517(), directory, o -> registry.method_10221(o));
    }

    public static <T> TagType.Simple<T> registerType(class_5321<? extends class_2378<T>> registry, String directory, Function<T, class_2960> locationProvider) {
        return (TagType.Simple)TYPES.computeIfAbsent(directory, dir -> new TagType.Simple(registry, (String)dir, locationProvider));
    }

    public static <T> TagType.UnTyped<T> registerType(class_5321<? extends class_2378<T>> registry, String directory) {
        return (TagType.UnTyped)TYPES.computeIfAbsent(directory, dir -> new TagType.UnTyped(registry, (String)dir));
    }

    public static class_6862<class_1959> makeBiomeTag(String modID, String name) {
        return BIOMES.makeTag(new class_2960(modID, name));
    }

    public static class_6862<class_1959> makeStructureTag(String modID, String name) {
        return TagAPI.makeBiomeTag(modID, "has_structure/" + name);
    }

    public static class_6862<class_2248> makeBlockTag(String modID, String name) {
        return BLOCKS.makeTag(new class_2960(modID, name));
    }

    public static class_6862<class_2248> makeBlockTag(class_2960 id) {
        return BLOCKS.makeTag(id);
    }

    public static class_6862<class_1792> makeItemTag(String modID, String name) {
        return ITEMS.makeTag(new class_2960(modID, name));
    }

    public static class_6862<class_1792> makeItemTag(class_2960 id) {
        return ITEMS.makeTag(id);
    }

    public static class_6862<class_2248> makeCommonBlockTag(String name) {
        return BLOCKS.makeCommonTag(name);
    }

    public static class_6862<class_1792> makeCommonItemTag(String name) {
        return ITEMS.makeCommonTag(name);
    }

    public static class_6862<class_1959> makeCommonBiomeTag(String name) {
        return BIOMES.makeCommonTag(name);
    }

    public static void init() {
        TagAPI.addBlockTag(CommonBlockTags.BOOKSHELVES, class_2246.field_10504);
        TagAPI.addBlockTag(CommonBlockTags.CHEST, class_2246.field_10034);
        TagAPI.addItemTag(CommonItemTags.CHEST, class_1802.field_8106);
        TagAPI.addItemTag(CommonItemTags.IRON_INGOTS, class_1802.field_8620);
        TagAPI.addItemTag(CommonItemTags.FURNACES, new class_1935[]{class_2246.field_10181});
    }

    @SafeVarargs
    public static void addBiomeTags(class_1959 biome, class_6862<class_1959> ... tagIDs) {
        BIOMES.add(biome, tagIDs);
    }

    public static void addBiomeTag(class_6862<class_1959> tagID, class_1959 ... biomes) {
        BIOMES.add(tagID, (class_1959[])biomes);
    }

    @SafeVarargs
    public static void addBlockTags(class_2248 block, class_6862<class_2248> ... tagIDs) {
        BLOCKS.add(block, tagIDs);
    }

    public static void addBlockTag(class_6862<class_2248> tagID, class_2248 ... blocks) {
        BLOCKS.add(tagID, (class_2248[])blocks);
    }

    @SafeVarargs
    public static void addItemTags(class_1935 item, class_6862<class_1792> ... tagIDs) {
        ITEMS.add(item.method_8389(), tagIDs);
    }

    public static void addItemTag(class_6862<class_1792> tagID, class_1935 ... items) {
        for (class_1935 i : items) {
            ITEMS.add(i.method_8389(), tagID);
        }
    }

    public static void addItemTag(class_6862<class_1792> tagID, class_1792 ... items) {
        ITEMS.add(tagID, (class_1792[])items);
    }

    public static <T> Map<class_2960, List<class_3503.class_5145>> apply(String directory, Map<class_2960, List<class_3503.class_5145>> tagsMap) {
        TagType<?> type = TYPES.get(directory);
        if (type != null) {
            type.apply(tagsMap);
        }
        return tagsMap;
    }

    public static boolean isToolWithMineableTag(class_1799 stack, class_6862<class_2248> tag) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof DiggerItemAccessor) {
            DiggerItemAccessor dig = (DiggerItemAccessor)class_17922;
            return dig.bclib_getBlockTag().equals(tag);
        }
        return false;
    }
}

