/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.surface;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2960;
import net.minecraft.class_6686;
import net.minecraft.class_6880;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;

public class SurfaceRuleUtil {
    private static final Map<class_2960, class_6686.class_6708> SURFACE_RULES = Maps.newHashMap();

    private static List<class_6686.class_6708> getRuleSourcesForBiomes(Set<class_6880<class_1959>> biomes) {
        Set<class_2960> biomeIDs = biomes.stream().map(biome -> BiomeAPI.getBiomeID((class_6880<class_1959>)biome)).collect(Collectors.toSet());
        return SurfaceRuleUtil.getRuleSourcesFromIDs(biomeIDs);
    }

    public static List<class_6686.class_6708> getRuleSources(Set<class_1966> sources) {
        HashSet<class_6880<class_1959>> biomes = new HashSet<class_6880<class_1959>>();
        for (class_1966 s : sources) {
            biomes.addAll(s.method_28443());
        }
        return SurfaceRuleUtil.getRuleSourcesForBiomes(biomes);
    }

    public static List<class_6686.class_6708> getRuleSources(class_1966 biomeSource) {
        return SurfaceRuleUtil.getRuleSourcesForBiomes(Sets.newHashSet((Iterable)biomeSource.method_28443()));
    }

    private static List<class_6686.class_6708> getRuleSourcesFromIDs(Set<class_2960> biomeIDs) {
        ArrayList rules = Lists.newArrayList();
        SURFACE_RULES.forEach((biomeID, rule) -> {
            if (biomeIDs.contains(biomeID)) {
                rules.add(rule);
            }
        });
        return rules;
    }

    public static void addSurfaceRule(class_2960 biomeID, class_6686.class_6708 source) {
        SURFACE_RULES.put(biomeID, source);
    }

    public static class_6686.class_6708 addRulesForBiomeSource(class_6686.class_6708 org, class_1966 biomeSource) {
        List<Object> additionalRules = SurfaceRuleUtil.getRuleSources(biomeSource);
        if (org instanceof class_6686.class_6710) {
            class_6686.class_6710 sequenceRule = (class_6686.class_6710)org;
            List existingSequence = sequenceRule.comp_209();
            if ((additionalRules = additionalRules.stream().filter(r -> existingSequence.indexOf(r) < 0).collect(Collectors.toList())).size() == 0) {
                return org;
            }
            additionalRules.addAll(sequenceRule.comp_209());
        } else {
            if (additionalRules.size() == 0) {
                return org;
            }
            if (!additionalRules.contains(org)) {
                additionalRules.add(org);
            }
        }
        return class_6686.method_39050((class_6686.class_6708[])additionalRules.toArray(new class_6686.class_6708[additionalRules.size()]));
    }
}

