/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3499;
import net.minecraft.class_4966;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructure;
import org.betterx.bclib.api.v2.levelgen.structures.StructureNBT;
import org.betterx.bclib.api.v2.levelgen.structures.StructurePlacementType;
import org.betterx.bclib.api.v2.levelgen.structures.TemplatePiece;

public abstract class TemplateStructure
extends class_3195 {
    protected final List<Config> configs;

    public static <T extends TemplateStructure> Codec<T> simpleTemplateCodec(BiFunction<class_3195.class_7302, List<Config>, T> instancer) {
        return RecordCodecBuilder.create(instance -> instance.group((App)class_3195.method_42697((RecordCodecBuilder.Instance)instance), (App)class_5699.method_36973((Codec)Config.CODEC.listOf()).fieldOf("configs").forGetter(ruinedPortalStructure -> ruinedPortalStructure.configs)).apply((Applicative)instance, instancer));
    }

    protected TemplateStructure(class_3195.class_7302 structureSettings, class_2960 location, int offsetY, StructurePlacementType type, float chance) {
        this(structureSettings, List.of(new Config(location, offsetY, type, chance)));
    }

    protected TemplateStructure(class_3195.class_7302 structureSettings, List<Config> configs) {
        super(structureSettings);
        this.configs = configs;
    }

    protected Config randomConfig(class_5819 random) {
        if (this.configs.size() > 1) {
            float chanceSum = this.configs.parallelStream().map(c -> Float.valueOf(c.chance())).reduce(Float.valueOf(0.0f), (p, c) -> Float.valueOf(p.floatValue() + c.floatValue())).floatValue();
            float rnd = random.method_43057() * chanceSum;
            for (Config c2 : this.configs) {
                if (!((rnd -= c2.chance()) <= 0.0f)) continue;
                return c2;
            }
        } else {
            return this.configs.get(0);
        }
        return null;
    }

    protected boolean isLavaPlaceable(class_2680 state, class_2680 before) {
        return state.method_27852(class_2246.field_10124) && before.method_27852(class_2246.field_10164);
    }

    protected boolean isFloorPlaceable(class_2680 state, class_2680 before) {
        return state.method_27852(class_2246.field_10124) && before.method_26207().method_15799();
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 ctx) {
        int y;
        int searchStep;
        BiPredicate<class_2680, class_2680> isCorrectBase;
        class_5868 worldGenerationContext = new class_5868(ctx.comp_562(), ctx.comp_569());
        Config config = this.randomConfig((class_5819)ctx.comp_566());
        if (config == null) {
            return Optional.empty();
        }
        class_1923 chunkPos = ctx.comp_568();
        int x = chunkPos.method_33940();
        int z = chunkPos.method_33942();
        class_4966 column = ctx.comp_562().method_26261(x, z, ctx.comp_569(), ctx.comp_564());
        class_3499 structureTemplate = ctx.comp_565().method_15091(config.location);
        if (config.type == StructurePlacementType.LAVA) {
            isCorrectBase = this::isLavaPlaceable;
            searchStep = 1;
        } else if (config.type == StructurePlacementType.CEIL) {
            isCorrectBase = this::isFloorPlaceable;
            searchStep = -1;
        } else {
            isCorrectBase = this::isFloorPlaceable;
            searchStep = 1;
        }
        int seaLevel = ctx.comp_562().method_16398() + (searchStep > 0 ? 0 : structureTemplate.method_15166(class_2470.field_11467).method_10264() + config.offsetY);
        int maxHeight = worldGenerationContext.method_30458() - 4 - (searchStep > 0 ? structureTemplate.method_15166(class_2470.field_11467).method_10264() + config.offsetY : 0);
        class_2680 state = column.method_32892(y - searchStep);
        for (y = searchStep > 0 ? seaLevel : maxHeight - 1; y < maxHeight && y >= seaLevel; y += searchStep) {
            class_2680 before = state;
            state = column.method_32892(y);
            if (isCorrectBase.test(state, before)) break;
        }
        if (y >= maxHeight || y < seaLevel) {
            return Optional.empty();
        }
        if (!BCLStructure.isValidBiome(ctx, y)) {
            return Optional.empty();
        }
        class_2338 halfSize = new class_2338(structureTemplate.method_15160().method_10263() / 2, 0, structureTemplate.method_15160().method_10260() / 2);
        class_2470 rotation = StructureNBT.getRandomRotation((class_5819)ctx.comp_566());
        class_2415 mirror = StructureNBT.getRandomMirror((class_5819)ctx.comp_566());
        class_2338 centerPos = new class_2338(x, y - (searchStep == 1 ? 0 : structureTemplate.method_15166(class_2470.field_11467).method_10264()), z);
        class_3341 boundingBox = structureTemplate.method_27267(centerPos, rotation, halfSize, mirror);
        return Optional.of(new class_3195.class_7150(centerPos, structurePiecesBuilder -> structurePiecesBuilder.method_35462((class_3443)new TemplatePiece(ctx.comp_565(), config.location, centerPos.method_10069(0, config.offsetY, 0), rotation, mirror, halfSize))));
    }

    public record Config(class_2960 location, int offsetY, StructurePlacementType type, float chance) {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("location").forGetter(cfg -> cfg.location), (App)Codec.INT.fieldOf("offset_y").orElse((Object)0).forGetter(cfg -> cfg.offsetY), (App)StructurePlacementType.CODEC.fieldOf("placement").orElse((Object)StructurePlacementType.FLOOR).forGetter(cfg -> cfg.type), (App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(1.0f)).forGetter(cfg -> Float.valueOf(cfg.chance))).apply((Applicative)instance, Config::new));
    }
}

