/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import org.betterx.bclib.BCLib;

public class StructureNBT {
    public final class_2960 location;
    protected class_3499 structure;
    private static final Map<class_2960, StructureNBT> STRUCTURE_CACHE = Maps.newHashMap();
    private static final Map<class_2960, class_3499> READER_CACHE = Maps.newHashMap();

    protected StructureNBT(class_2960 location) {
        this.location = location;
        this.structure = StructureNBT.readStructureFromJar(location);
    }

    protected StructureNBT(class_2960 location, class_3499 structure) {
        this.location = location;
        this.structure = structure;
    }

    public static class_2470 getRandomRotation(class_5819 random) {
        return class_2470.method_16548((class_5819)random);
    }

    public static class_2415 getRandomMirror(class_5819 random) {
        return class_2415.values()[random.method_43048(3)];
    }

    public static StructureNBT create(class_2960 location) {
        return STRUCTURE_CACHE.computeIfAbsent(location, r -> new StructureNBT((class_2960)r));
    }

    public boolean generateCentered(class_5425 world, class_2338 pos, class_2470 rotation, class_2415 mirror) {
        if (this.structure == null) {
            BCLib.LOGGER.error("No structure: " + this.location.toString());
            return false;
        }
        class_2338.class_2339 blockpos2 = new class_2338.class_2339().method_10101(this.structure.method_15160());
        if (mirror == class_2415.field_11301) {
            blockpos2.method_33097(-blockpos2.method_10263());
        }
        if (mirror == class_2415.field_11300) {
            blockpos2.method_33099(-blockpos2.method_10260());
        }
        blockpos2.method_10101((class_2382)blockpos2.method_10070(rotation));
        class_3492 data = new class_3492().method_15123(rotation).method_15125(mirror);
        class_2338 newPos = pos.method_10069(-blockpos2.method_10263() >> 1, 0, -blockpos2.method_10260() >> 1);
        this.structure.method_15172(world, newPos, newPos, data, world.method_8409(), 2);
        return true;
    }

    private static class_3499 readStructureFromJar(class_2960 resource) {
        return READER_CACHE.computeIfAbsent(resource, r -> StructureNBT._readStructureFromJar(r));
    }

    private static class_3499 _readStructureFromJar(class_2960 resource) {
        String ns = resource.method_12836();
        String nm = resource.method_12832();
        try {
            InputStream inputstream = MinecraftServer.class.getResourceAsStream("/data/" + ns + "/structures/" + nm + ".nbt");
            return StructureNBT.readStructureFromStream(inputstream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class_3499 readStructureFromStream(InputStream stream) throws IOException {
        class_2487 nbttagcompound = class_2507.method_10629((InputStream)stream);
        class_3499 template = new class_3499();
        template.method_15183(nbttagcompound);
        return template;
    }

    public class_2338 getSize(class_2470 rotation) {
        if (rotation == class_2470.field_11467 || rotation == class_2470.field_11464) {
            return new class_2338(this.structure.method_15160());
        }
        class_2382 size = this.structure.method_15160();
        int x = size.method_10263();
        int z = size.method_10260();
        return new class_2338(z, size.method_10264(), x);
    }

    public String getName() {
        return this.location.method_12832();
    }

    public class_3341 getBoundingBox(class_2338 pos, class_2470 rotation, class_2415 mirror) {
        return this.structure.method_16187(new class_3492().method_15123(rotation).method_15125(mirror), pos);
    }
}

