/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.features.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_5444;
import net.minecraft.class_5819;
import net.minecraft.class_6797;
import net.minecraft.class_6798;
import org.betterx.bclib.api.v2.levelgen.features.placement.PlacementModifiers;
import org.betterx.bclib.util.BlocksHelper;

public class OnEveryLayer
extends class_6797 {
    private static final OnEveryLayer INSTANCE = new OnEveryLayer(Optional.empty(), Optional.empty());
    private static final OnEveryLayer INSTANCE_MIN_4 = new OnEveryLayer(Optional.of(4), Optional.empty());
    public static final Codec<OnEveryLayer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("min").forGetter(o -> o.minHeight), (App)Codec.INT.optionalFieldOf("max").forGetter(o -> o.maxHeight)).apply((Applicative)instance, OnEveryLayer::new));
    private final Optional<Integer> minHeight;
    private final Optional<Integer> maxHeight;

    private OnEveryLayer(Optional<Integer> minHeight, Optional<Integer> maxHeight) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public static OnEveryLayer simple() {
        return INSTANCE;
    }

    public static OnEveryLayer min4() {
        return INSTANCE_MIN_4;
    }

    public Stream<class_2338> method_14452(class_5444 ctx, class_5819 random, class_2338 pos) {
        int layerY;
        Stream.Builder<class_2338> builder = Stream.builder();
        int z = pos.method_10260();
        int x = pos.method_10263();
        int levelHeight = ctx.method_30460(class_2902.class_2903.field_13197, x, z);
        int minLevelHeight = ctx.method_33868();
        int y = this.maxHeight.map(h -> Math.min(levelHeight, h)).orElse(levelHeight);
        int minHeight = this.minHeight.map(h -> Math.max(minLevelHeight, h)).orElse(minLevelHeight);
        do {
            if ((layerY = OnEveryLayer.findOnGroundYPosition(ctx, x, y, z, minHeight)) == Integer.MAX_VALUE) continue;
            builder.add(new class_2338(x, layerY, z));
            y = layerY - 1;
        } while (layerY != Integer.MAX_VALUE);
        return builder.build();
    }

    public class_6798<OnEveryLayer> method_39615() {
        return PlacementModifiers.ON_EVERY_LAYER;
    }

    private static int findOnGroundYPosition(class_5444 ctx, int x, int startY, int z, int minHeight) {
        class_2338.class_2339 mPos = new class_2338.class_2339(x, startY, z);
        class_2680 nowState = ctx.method_30461((class_2338)mPos);
        for (int y = startY; y >= minHeight + 1; --y) {
            mPos.method_33098(y - 1);
            class_2680 belowState = ctx.method_30461((class_2338)mPos);
            if (BlocksHelper.isTerrain(belowState) && BlocksHelper.isFreeOrFluid(nowState) && !belowState.method_27852(class_2246.field_9987)) {
                return mPos.method_10264() + 1;
            }
            nowState = belowState;
        }
        return Integer.MAX_VALUE;
    }
}

