/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.features.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_5444;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6797;
import net.minecraft.class_6798;
import org.betterx.bclib.api.v2.levelgen.features.placement.PlacementModifiers;
import org.betterx.bclib.util.BlocksHelper;

public class FindSolidInDirection
extends class_6797 {
    public static final Codec<FindSolidInDirection> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.method_36973((Codec)class_2350.field_29502.listOf()).fieldOf("dir").orElse(List.of(class_2350.field_11033)).forGetter(a -> a.direction), (App)Codec.intRange((int)1, (int)32).fieldOf("dist").orElse((Object)12).forGetter(p -> p.maxSearchDistance), (App)Codec.BOOL.fieldOf("random:select").orElse((Object)true).forGetter(p -> p.randomSelect)).apply((Applicative)instance, FindSolidInDirection::new));
    protected static final FindSolidInDirection DOWN = new FindSolidInDirection(class_2350.field_11033, 6);
    protected static final FindSolidInDirection UP = new FindSolidInDirection(class_2350.field_11036, 6);
    private final List<class_2350> direction;
    private final int maxSearchDistance;
    private final boolean randomSelect;
    private final class_6017 provider;

    public FindSolidInDirection(class_2350 direction, int maxSearchDistance) {
        this(List.of(direction), maxSearchDistance, false);
    }

    public FindSolidInDirection(List<class_2350> direction, int maxSearchDistance) {
        this(direction, maxSearchDistance, direction.size() > 1);
    }

    public FindSolidInDirection(List<class_2350> direction, int maxSearchDistance, boolean randomSelect) {
        this.direction = direction;
        this.maxSearchDistance = maxSearchDistance;
        this.provider = class_6019.method_35017((int)0, (int)(direction.size() - 1));
        this.randomSelect = randomSelect;
    }

    public static class_6797 down() {
        return DOWN;
    }

    public static class_6797 up() {
        return UP;
    }

    public static class_6797 down(int dist) {
        if (dist == FindSolidInDirection.DOWN.maxSearchDistance) {
            return DOWN;
        }
        return new FindSolidInDirection(class_2350.field_11033, dist);
    }

    public static class_6797 up(int dist) {
        if (dist == FindSolidInDirection.UP.maxSearchDistance) {
            return UP;
        }
        return new FindSolidInDirection(class_2350.field_11036, dist);
    }

    public class_2350 randomDirection(class_5819 random) {
        return this.direction.get(this.provider.method_35008(random));
    }

    public Stream<class_2338> method_14452(class_5444 placementContext, class_5819 randomSource, class_2338 blockPos) {
        Stream.Builder<class_2338> builder = Stream.builder();
        if (this.randomSelect) {
            this.submitSingle(placementContext, blockPos, builder, this.randomDirection(randomSource));
        } else {
            for (class_2350 d : this.direction) {
                this.submitSingle(placementContext, blockPos, builder, d);
            }
        }
        return builder.build();
    }

    private void submitSingle(class_5444 placementContext, class_2338 blockPos, Stream.Builder<class_2338> builder, class_2350 d) {
        class_2338.class_2339 POS = blockPos.method_25503();
        if (BlocksHelper.findOnSurroundingSurface((class_1936)placementContext.method_34383(), POS, d, this.maxSearchDistance, BlocksHelper::isTerrain)) {
            builder.add((class_2338)POS);
        }
    }

    public class_6798<?> method_39615() {
        return PlacementModifiers.SOLID_IN_DIR;
    }
}

