/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.features.features;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.betterx.bclib.api.v2.levelgen.features.UserGrowableFeature;
import org.betterx.bclib.api.v2.levelgen.features.config.ScatterFeatureConfig;
import org.betterx.bclib.util.BlocksHelper;

public class ScatterFeature<FC extends ScatterFeatureConfig>
extends class_3031<FC>
implements UserGrowableFeature<FC> {
    public ScatterFeature(Codec<FC> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<FC> featurePlaceContext) {
        ScatterFeatureConfig config;
        class_5819 random;
        class_2338 origin;
        class_5281 level = featurePlaceContext.method_33652();
        Optional<class_2350> direction = this.getTipDirection((class_1936)level, origin = featurePlaceContext.method_33655(), random = featurePlaceContext.method_33654(), config = (ScatterFeatureConfig)featurePlaceContext.method_33656());
        if (direction.isEmpty()) {
            return false;
        }
        class_2338 basePos = origin.method_10079(direction.get(), -1);
        int i = (int)(random.method_43057() * (float)(1 + config.maxHeight - config.minHeight) + (float)config.minHeight);
        this.growCenterPillar((class_1936)level, origin, basePos, direction.get(), i, config, random);
        return true;
    }

    protected void growCenterPillar(class_1936 level, class_2338 origin, class_2338 basePos, class_2350 direction, int centerHeight, ScatterFeatureConfig config, class_5819 random) {
        if (config.isValidBase(level.method_8320(basePos))) {
            class_2350 surfaceDirection = direction.method_10153();
            class_2338.class_2339 POS = new class_2338.class_2339();
            int adaptedHeight = this.freeHeight(level, direction, centerHeight, config, origin);
            this.buildPillarWithBase(level, origin, basePos, direction, adaptedHeight, config, random, false);
            double distNormalizer = (double)config.maxSpread * Math.sqrt(2.0);
            int tryCount = config.spreadCount.method_35008(random);
            for (int i = 0; i < tryCount; ++i) {
                int x = origin.method_10263() + (int)(random.method_43059() * (double)config.maxSpread);
                int z = origin.method_10260() + (int)(random.method_43059() * (double)config.maxSpread);
                POS.method_10103(x, basePos.method_10264(), z);
                if (!BlocksHelper.findSurroundingSurface(level, POS, surfaceDirection, 4, config::isValidBase)) continue;
                int myHeight = this.freeHeight(level, direction, centerHeight, config, (class_2338)POS);
                int dx = x - POS.method_10263();
                int dz = z - POS.method_10260();
                float sizeFactor = 1.0f - (float)(Math.sqrt(dx * dx + dz * dz) / distNormalizer);
                sizeFactor = (1.0f - random.method_43057() * config.sizeVariation) * sizeFactor;
                myHeight = (int)Math.min(Math.max((float)config.minHeight, (float)config.minHeight + sizeFactor * (float)(myHeight - config.minHeight)), (float)config.maxHeight);
                class_2680 baseState = level.method_8320(POS.method_10093(direction.method_10153()));
                if (!config.isValidBase(baseState)) {
                    System.out.println("Starting from " + baseState + " at " + POS.method_10093(direction.method_10153()));
                }
                this.buildPillarWithBase(level, (class_2338)POS, POS.method_10093(direction.method_10153()), direction, myHeight, config, random, false);
            }
        }
    }

    private int freeHeight(class_1936 level, class_2350 direction, int defaultHeight, ScatterFeatureConfig config, class_2338 POS) {
        int myHeight = config.growWhileFree ? BlocksHelper.blockCount(level, POS, direction, config.maxHeight, BlocksHelper::isFree) : defaultHeight;
        return Math.max(config.minHeight, myHeight);
    }

    private void buildPillarWithBase(class_1936 level, class_2338 origin, class_2338 basePos, class_2350 direction, int height, ScatterFeatureConfig config, class_5819 random, boolean force) {
        if (force || BlocksHelper.isFreeSpace(level, origin, direction, height, BlocksHelper::isFree)) {
            this.createPatchOfBaseBlocks(level, random, basePos, config);
            class_2680 bottom = config.bottomBlock.method_23455(random, origin);
            if (bottom.method_26184((class_4538)level, origin)) {
                this.buildPillar(level, origin, direction, height, config, random);
            }
        }
    }

    private void buildPillar(class_1936 level, class_2338 origin, class_2350 direction, int height, ScatterFeatureConfig config, class_5819 random) {
        class_2338.class_2339 POS = origin.method_25503();
        for (int size = 0; size < height; ++size) {
            class_2680 state = config.createBlock(size, height - 1, random, (class_2338)POS);
            BlocksHelper.setWithoutUpdate(level, (class_2338)POS, state);
            POS.method_10098(direction);
        }
    }

    private Optional<class_2350> getTipDirection(class_1936 levelAccessor, class_2338 blockPos, class_5819 randomSource, ScatterFeatureConfig config) {
        boolean onFloor;
        boolean onCeil = config.floorChance < 1.0f && config.isValidBase(levelAccessor.method_8320(blockPos.method_10084()));
        boolean bl = onFloor = config.floorChance > 0.0f && config.isValidBase(levelAccessor.method_8320(blockPos.method_10074()));
        if (onCeil && onFloor) {
            return Optional.of(config.isFloor(randomSource) ? class_2350.field_11033 : class_2350.field_11036);
        }
        if (onCeil) {
            return Optional.of(class_2350.field_11033);
        }
        if (onFloor) {
            return Optional.of(class_2350.field_11036);
        }
        return Optional.empty();
    }

    private void createPatchOfBaseBlocks(class_1936 levelAccessor, class_5819 randomSource, class_2338 blockPos, ScatterFeatureConfig config) {
        if (config.baseState.isPresent() && config.baseReplaceChance > 0.0f && randomSource.method_43057() < config.baseReplaceChance) {
            class_2680 baseState = config.baseState.get();
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                if (randomSource.method_43057() > config.chanceOfDirectionalSpread) continue;
                class_2338 pos = blockPos.method_10093(direction);
                this.placeBaseBlockIfPossible(levelAccessor, pos, baseState);
                if (randomSource.method_43057() > config.chanceOfSpreadRadius2) continue;
                pos = pos.method_10093(class_2350.method_10162((class_5819)randomSource));
                this.placeBaseBlockIfPossible(levelAccessor, pos, baseState);
                if (randomSource.method_43057() > config.chanceOfSpreadRadius3) continue;
                pos = pos.method_10093(class_2350.method_10162((class_5819)randomSource));
                this.placeBaseBlockIfPossible(levelAccessor, pos, baseState);
            }
            this.placeBaseBlockIfPossible(levelAccessor, blockPos, baseState);
        }
    }

    protected void placeBaseBlockIfPossible(class_1936 levelAccessor, class_2338 blockPos, class_2680 baseState) {
        class_2680 blockState = levelAccessor.method_8320(blockPos);
        if (BlocksHelper.isTerrain(blockState)) {
            levelAccessor.method_8652(blockPos, baseState, 2);
        }
    }

    @Override
    public boolean grow(class_5425 level, class_2338 origin, class_5819 random, FC config) {
        Optional<class_2350> oDirection = this.getTipDirection((class_1936)level, origin, random, (ScatterFeatureConfig)config);
        if (oDirection.isEmpty()) {
            return false;
        }
        class_2350 direction = oDirection.get();
        class_2338 basePos = origin.method_10079(direction, -1);
        if (((ScatterFeatureConfig)config).isValidBase(level.method_8320(basePos))) {
            int centerHeight = (int)(random.method_43057() * (float)(1 + ((ScatterFeatureConfig)config).maxHeight - ((ScatterFeatureConfig)config).minHeight) + (float)((ScatterFeatureConfig)config).minHeight);
            centerHeight = this.freeHeight((class_1936)level, direction, centerHeight, (ScatterFeatureConfig)config, origin.method_10079(direction, 1)) + 1;
            this.buildPillarWithBase((class_1936)level, origin, basePos, direction, centerHeight, (ScatterFeatureConfig)config, random, true);
        }
        return false;
    }
}

