/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.features;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3003;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3173;
import net.minecraft.class_3175;
import net.minecraft.class_4651;
import net.minecraft.class_5450;
import net.minecraft.class_5452;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6646;
import net.minecraft.class_6732;
import net.minecraft.class_6792;
import net.minecraft.class_6793;
import net.minecraft.class_6797;
import net.minecraft.class_6799;
import net.minecraft.class_6817;
import org.betterx.bclib.api.v2.levelgen.features.BCLFeature;
import org.betterx.bclib.api.v2.levelgen.features.placement.All;
import org.betterx.bclib.api.v2.levelgen.features.placement.Extend;
import org.betterx.bclib.api.v2.levelgen.features.placement.FindSolidInDirection;
import org.betterx.bclib.api.v2.levelgen.features.placement.Is;
import org.betterx.bclib.api.v2.levelgen.features.placement.IsBasin;
import org.betterx.bclib.api.v2.levelgen.features.placement.IsEmptyAboveSampledFilter;
import org.betterx.bclib.api.v2.levelgen.features.placement.MinEmptyFilter;
import org.betterx.bclib.api.v2.levelgen.features.placement.Offset;
import org.betterx.bclib.api.v2.levelgen.features.placement.OnEveryLayer;
import org.betterx.bclib.api.v2.levelgen.features.placement.Stencil;
import org.betterx.bclib.api.v2.levelgen.features.placement.UnderEveryLayer;

public class BCLFeatureBuilder<FC extends class_3037, F extends class_3031<FC>> {
    private final List<class_6797> modifications = new ArrayList<class_6797>(5);
    private final class_2960 featureID;
    private class_2893.class_2895 decoration = class_2893.class_2895.field_13178;
    private final F feature;
    private class_4651 provider;

    private BCLFeatureBuilder(class_2960 featureID, F feature) {
        this.featureID = featureID;
        this.feature = feature;
    }

    public static BCLFeatureBuilder start(class_2960 featureID, class_3031<?> feature) {
        return new BCLFeatureBuilder(featureID, feature);
    }

    public static BCLFeatureBuilder<class_3175, class_3173> start(class_2960 featureID, class_2248 block) {
        return BCLFeatureBuilder.start(featureID, (class_4651)class_4651.method_38432((class_2248)block));
    }

    public static BCLFeatureBuilder<class_3175, class_3173> start(class_2960 featureID, class_2680 state) {
        return BCLFeatureBuilder.start(featureID, (class_4651)class_4651.method_38433((class_2680)state));
    }

    public static BCLFeatureBuilder<class_3175, class_3173> start(class_2960 featureID, class_4651 provider) {
        BCLFeatureBuilder builder = new BCLFeatureBuilder(featureID, class_3031.field_13518);
        builder.provider = provider;
        return builder;
    }

    public BCLFeatureBuilder decoration(class_2893.class_2895 decoration) {
        this.decoration = decoration;
        return this;
    }

    public BCLFeatureBuilder modifier(class_6797 modifier) {
        this.modifications.add(modifier);
        return this;
    }

    public BCLFeatureBuilder modifier(List<class_6797> modifiers) {
        this.modifications.addAll(modifiers);
        return this;
    }

    public BCLFeatureBuilder count(int count) {
        return this.modifier((class_6797)class_6793.method_39623((int)count));
    }

    public BCLFeatureBuilder countMax(int count) {
        return this.modifier((class_6797)class_6793.method_39624((class_6017)class_6019.method_35017((int)0, (int)count)));
    }

    public BCLFeatureBuilder countRange(int min, int max) {
        return this.modifier((class_6797)class_6793.method_39624((class_6017)class_6019.method_35017((int)min, (int)max)));
    }

    public BCLFeatureBuilder countLayers(int count) {
        return this.modifier((class_6797)class_5452.method_39620((int)count));
    }

    public BCLFeatureBuilder countLayersMax(int count) {
        return this.modifier((class_6797)class_5452.method_39621((class_6017)class_6019.method_35017((int)0, (int)count)));
    }

    public BCLFeatureBuilder onceEvery(int n) {
        return this.modifier((class_6797)class_6799.method_39659((int)n));
    }

    public BCLFeatureBuilder onlyInBiome() {
        return this.modifier((class_6797)class_6792.method_39614());
    }

    public BCLFeatureBuilder squarePlacement() {
        return this.modifier((class_6797)class_5450.method_39639());
    }

    public BCLFeatureBuilder stencil() {
        return this.modifier(Stencil.all());
    }

    public BCLFeatureBuilder all() {
        return this.modifier(All.simple());
    }

    public BCLFeatureBuilder stencilOneIn4() {
        return this.modifier(Stencil.oneIn4());
    }

    public BCLFeatureBuilder randomHeight10FromFloorCeil() {
        return this.modifier(class_6817.field_36083);
    }

    public BCLFeatureBuilder randomHeight4FromFloorCeil() {
        return this.modifier(class_6817.field_36085);
    }

    public BCLFeatureBuilder randomHeight8FromFloorCeil() {
        return this.modifier(class_6817.field_36084);
    }

    public BCLFeatureBuilder randomHeight() {
        return this.modifier(class_6817.field_36082);
    }

    public BCLFeatureBuilder isEmptyAbove4() {
        return this.modifier((class_6797)IsEmptyAboveSampledFilter.emptyAbove4());
    }

    public BCLFeatureBuilder isEmptyAbove2() {
        return this.modifier((class_6797)IsEmptyAboveSampledFilter.emptyAbove2());
    }

    public BCLFeatureBuilder isEmptyAbove() {
        return this.modifier((class_6797)IsEmptyAboveSampledFilter.emptyAbove());
    }

    public BCLFeatureBuilder isEmptyBelow4() {
        return this.modifier((class_6797)IsEmptyAboveSampledFilter.emptyBelow4());
    }

    public BCLFeatureBuilder isEmptyBelow2() {
        return this.modifier((class_6797)IsEmptyAboveSampledFilter.emptyBelow2());
    }

    public BCLFeatureBuilder isEmptyBelow() {
        return this.modifier((class_6797)IsEmptyAboveSampledFilter.emptyBelow());
    }

    public BCLFeatureBuilder isEmptyAbove(int d1, int d2) {
        return this.modifier((class_6797)new IsEmptyAboveSampledFilter(d1, d2));
    }

    public BCLFeatureBuilder onEveryLayer() {
        return this.modifier(OnEveryLayer.simple());
    }

    public BCLFeatureBuilder underEveryLayer() {
        return this.modifier(UnderEveryLayer.simple());
    }

    public BCLFeatureBuilder spreadHorizontal(class_6017 p) {
        return this.modifier((class_6797)class_6732.method_39658((class_6017)p));
    }

    public BCLFeatureBuilder spreadVertical(class_6017 p) {
        return this.modifier((class_6797)class_6732.method_39658((class_6017)p));
    }

    public BCLFeatureBuilder spread(class_6017 horizontal, class_6017 vertical) {
        return this.modifier((class_6797)class_6732.method_39657((class_6017)horizontal, (class_6017)vertical));
    }

    public BCLFeatureBuilder offset(class_2350 dir) {
        return this.modifier(Offset.inDirection(dir));
    }

    public BCLFeatureBuilder offset(class_2382 dir) {
        return this.modifier(new Offset(dir));
    }

    public BCLFeatureBuilder findSolidFloor(int distance) {
        return this.modifier(FindSolidInDirection.down(distance));
    }

    public BCLFeatureBuilder noiseBasedCount(float noiseLevel, int belowNoiseCount, int aboveNoiseCount) {
        return this.modifier((class_6797)class_3003.method_39642((double)noiseLevel, (int)belowNoiseCount, (int)aboveNoiseCount));
    }

    public BCLFeatureBuilder extendDown(int min, int max) {
        return this.modifier(new Extend(class_2350.field_11033, (class_6017)class_6019.method_35017((int)min, (int)max)));
    }

    public BCLFeatureBuilder inBasinOf(class_6646 ... predicates) {
        return this.modifier((class_6797)new IsBasin(class_6646.method_38887((class_6646[])predicates)));
    }

    public BCLFeatureBuilder inOpenBasinOf(class_6646 ... predicates) {
        return this.modifier((class_6797)IsBasin.openTop(class_6646.method_38887((class_6646[])predicates)));
    }

    public BCLFeatureBuilder is(class_6646 ... predicates) {
        return this.modifier((class_6797)new Is(class_6646.method_38887((class_6646[])predicates), Optional.empty()));
    }

    public BCLFeatureBuilder isAbove(class_6646 ... predicates) {
        return this.modifier((class_6797)new Is(class_6646.method_38887((class_6646[])predicates), Optional.of(class_2350.field_11033.method_10163())));
    }

    public BCLFeatureBuilder isUnder(class_6646 ... predicates) {
        return this.modifier((class_6797)new Is(class_6646.method_38887((class_6646[])predicates), Optional.of(class_2350.field_11036.method_10163())));
    }

    public BCLFeatureBuilder findSolidCeil(int distance) {
        return this.modifier(FindSolidInDirection.up(distance));
    }

    public BCLFeatureBuilder hasMinimumDownwardSpace() {
        return this.modifier(MinEmptyFilter.down());
    }

    public BCLFeatureBuilder hasMinimumUpwardSpace() {
        return this.modifier(MinEmptyFilter.up());
    }

    public BCLFeatureBuilder findSolidSurface(class_2350 dir, int distance) {
        return this.modifier(new FindSolidInDirection(dir, distance));
    }

    public BCLFeatureBuilder findSolidSurface(List<class_2350> dir, int distance, boolean randomSelect) {
        return this.modifier(new FindSolidInDirection(dir, distance, randomSelect));
    }

    public BCLFeatureBuilder heightmap() {
        return this.modifier(class_6817.field_36078);
    }

    public BCLFeatureBuilder heightmapTopSolid() {
        return this.modifier(class_6817.field_36079);
    }

    public BCLFeatureBuilder heightmapWorldSurface() {
        return this.modifier(class_6817.field_36080);
    }

    public BCLFeature buildAndRegister(FC configuration) {
        class_6797[] modifiers = this.modifications.toArray(new class_6797[this.modifications.size()]);
        return new BCLFeature<F, FC>(this.featureID, this.feature, this.decoration, configuration, modifiers);
    }

    public BCLFeature buildAndRegister() {
        if (this.feature == class_3031.field_13518 && this.provider != null) {
            return this.buildAndRegister(new class_3175(this.provider));
        }
        return this.buildAndRegister(class_3037.field_13603);
    }

    @Deprecated(forRemoval=true)
    public BCLFeature build(FC configuration) {
        return this.buildAndRegister(configuration);
    }

    @Deprecated(forRemoval=true)
    public BCLFeature build() {
        return this.buildAndRegister();
    }
}

