/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.biomes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.registry.DynamicRegistrySetupCallback;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5458;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import org.apache.commons.lang3.mutable.MutableInt;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.FabricBiomesData;
import org.betterx.bclib.interfaces.BiomeSourceAccessor;
import org.betterx.bclib.interfaces.NoiseGeneratorSettingsProvider;
import org.betterx.bclib.interfaces.SurfaceRuleProvider;
import org.betterx.bclib.mixin.common.BiomeGenerationSettingsAccessor;

public class InternalBiomeAPI {
    static final Map<class_1959, BCLBiome> CLIENT = Maps.newHashMap();
    static final Map<class_6880<class_6796>, Integer> FEATURE_ORDER = Maps.newHashMap();
    static final MutableInt FEATURE_ORDER_ID = new MutableInt(0);
    static final Map<class_5321<class_5363>, List<BiConsumer<class_2960, class_6880<class_1959>>>> MODIFICATIONS = Maps.newHashMap();
    static final Map<class_5321, List<BiConsumer<class_2960, class_6880<class_1959>>>> TAG_ADDERS = Maps.newHashMap();
    static class_2378<class_1959> biomeRegistry;
    static class_5455 registryAccess;
    private static final Set<class_2960> BIOMES_TO_SORT;

    static void initFeatureOrder() {
        if (!FEATURE_ORDER.isEmpty()) {
            return;
        }
        class_5458.field_25933.method_29722().stream().filter(entry -> ((class_5321)entry.getKey()).method_29177().method_12836().equals("minecraft")).map(Map.Entry::getValue).map(biome -> (BiomeGenerationSettingsAccessor)biome.method_30970()).map(BiomeGenerationSettingsAccessor::bclib_getFeatures).forEach(stepFeatureSuppliers -> stepFeatureSuppliers.forEach(step -> step.forEach(feature -> FEATURE_ORDER.computeIfAbsent((class_6880<class_6796>)feature, f -> FEATURE_ORDER_ID.getAndIncrement()))));
    }

    public static void initRegistry(class_5455 access) {
        if (access != registryAccess) {
            registryAccess = access;
            class_2378 biomeRegistry = access.method_33310(class_2378.field_25114).orElse(null);
            if (biomeRegistry != InternalBiomeAPI.biomeRegistry) {
                InternalBiomeAPI.biomeRegistry = biomeRegistry;
                CLIENT.clear();
                BIOMES_TO_SORT.forEach(id -> {
                    class_1959 b = (class_1959)biomeRegistry.method_10223(id);
                    BCLib.LOGGER.info("Sorting Features in Biome: " + id + "(" + b + ")");
                    BiomeAPI.sortBiomeFeatures(b);
                });
            }
        }
    }

    public static void prepareNewLevel() {
    }

    public static void loadFabricAPIBiomes() {
        FabricBiomesData.NETHER_BIOMES.forEach(key -> {
            Optional optional;
            if (!BiomeAPI.hasBiome(key.method_29177()) && (optional = class_5458.field_25933.method_40264(key)).isPresent()) {
                BiomeAPI.registerNetherBiome((class_1959)((class_6880)optional.get()).comp_349());
            }
        });
        FabricBiomesData.END_LAND_BIOMES.forEach((key, weight) -> {
            Optional optional;
            if (!BiomeAPI.hasBiome(key.method_29177()) && (optional = class_5458.field_25933.method_40264(key)).isPresent()) {
                BiomeAPI.registerEndLandBiome((class_6880<class_1959>)((class_6880)optional.get()), weight.floatValue());
            }
        });
        FabricBiomesData.END_VOID_BIOMES.forEach((key, weight) -> {
            Optional optional;
            if (!BiomeAPI.hasBiome(key.method_29177()) && (optional = class_5458.field_25933.method_40264(key)).isPresent()) {
                BiomeAPI.registerEndVoidBiome((class_6880<class_1959>)((class_6880)optional.get()), weight.floatValue());
            }
        });
    }

    public static void _runBiomeTagAdders() {
        for (Map.Entry<class_5321, List<BiConsumer<class_2960, class_6880<class_1959>>>> mod : TAG_ADDERS.entrySet()) {
            Stream<class_2960> s = null;
            if (mod.getKey() == class_1937.field_25180) {
                s = BiomeAPI.BiomeType.BIOME_TYPE_MAP.entrySet().stream().filter(e -> ((BiomeAPI.BiomeType)e.getValue()).is(BiomeAPI.BiomeType.NETHER)).map(e -> (class_2960)e.getKey());
            } else if (mod.getKey() == class_1937.field_25181) {
                s = BiomeAPI.BiomeType.BIOME_TYPE_MAP.entrySet().stream().filter(e -> ((BiomeAPI.BiomeType)e.getValue()).is(BiomeAPI.BiomeType.END)).map(e -> (class_2960)e.getKey());
            }
            if (s == null) continue;
            s.forEach(id -> {
                class_6880<class_1959> biomeHolder = BiomeAPI.getBiomeHolder(id);
                if (biomeHolder.method_40227()) {
                    ((List)mod.getValue()).forEach(c -> c.accept(id, biomeHolder));
                }
            });
        }
    }

    @Deprecated(forRemoval=true)
    public static void applyModificationsDeprecated(class_3218 level) {
        if (level != null) {
            return;
        }
        class_5284 noiseGeneratorSettings = null;
        class_2794 chunkGenerator = level.method_14178().method_12129();
        class_1966 source = chunkGenerator.method_12098();
        Set biomes = source.method_28443();
        if (chunkGenerator instanceof NoiseGeneratorSettingsProvider) {
            NoiseGeneratorSettingsProvider gen = (NoiseGeneratorSettingsProvider)chunkGenerator;
            noiseGeneratorSettings = gen.bclib_getNoiseGeneratorSettings();
        }
        if (noiseGeneratorSettings == null) {
            if (level.method_27983() == class_1937.field_25180) {
                noiseGeneratorSettings = (class_5284)class_5458.field_26375.method_29107(class_5284.field_26357);
            } else if (level.method_27983() == class_1937.field_25181) {
                noiseGeneratorSettings = (class_5284)class_5458.field_26375.method_29107(class_5284.field_26358);
            }
        }
        List<BiConsumer<class_2960, class_6880<class_1959>>> modifications = MODIFICATIONS.get(level.method_40134().method_40230().orElseThrow());
        for (class_6880 biomeHolder : biomes) {
            if (!biomeHolder.method_40227()) continue;
            InternalBiomeAPI.applyModificationsAndUpdateFeatures(modifications, (class_6880<class_1959>)biomeHolder);
        }
        if (noiseGeneratorSettings != null) {
            SurfaceRuleProvider provider = (SurfaceRuleProvider)SurfaceRuleProvider.class.cast(noiseGeneratorSettings);
            provider.bclib_addBiomeSource(source);
        } else {
            BCLib.LOGGER.warning("No generator for " + source, new Object[0]);
        }
        ((BiomeSourceAccessor)source).bclRebuildFeatures();
    }

    public static void applyModifications(class_1966 source, class_5321<class_5363> dimension) {
        BCLib.LOGGER.info("Apply Modifications for " + dimension.method_29177() + " BiomeSource " + source);
        Set biomes = source.method_28443();
        List<BiConsumer<class_2960, class_6880<class_1959>>> modifications = MODIFICATIONS.get(dimension);
        for (class_6880 biomeHolder : biomes) {
            if (!biomeHolder.method_40227()) continue;
            InternalBiomeAPI.applyModificationsAndUpdateFeatures(modifications, (class_6880<class_1959>)biomeHolder);
        }
    }

    private static void applyModificationsAndUpdateFeatures(List<BiConsumer<class_2960, class_6880<class_1959>>> modifications, class_6880<class_1959> biome) {
        class_2960 biomeID = BiomeAPI.getBiomeID(biome);
        if (modifications != null) {
            modifications.forEach(consumer -> consumer.accept(biomeID, biome));
        }
        BiomeAPI.sortBiomeFeatures(biome);
    }

    static {
        BIOMES_TO_SORT = Sets.newHashSet();
        DynamicRegistrySetupCallback.EVENT.register(registryManager -> {
            Optional oBiomeRegistry = registryManager.method_33310(class_2378.field_25114);
            RegistryEntryAddedCallback.event((class_2378)((class_2378)oBiomeRegistry.get())).register((rawId, id, biome) -> {
                BCLBiome b = BiomeAPI.getBiome(id);
                if (!("minecraft".equals(id.method_12836()) || b != null && b != BiomeAPI.EMPTY_BIOME)) {
                    BIOMES_TO_SORT.add(id);
                }
            });
        });
    }
}

