/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.biomes;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.biome.NetherBiomeData;
import net.fabricmc.fabric.impl.biome.TheEndBiomeData;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2841;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_310;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5458;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6012;
import net.minecraft.class_6544;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6908;
import net.minecraft.class_7522;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.InternalBiomeAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.VanillaBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.features.BCLFeature;
import org.betterx.bclib.api.v2.tag.CommonBiomeTags;
import org.betterx.bclib.api.v2.tag.TagAPI;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.bclib.mixin.common.BiomeGenerationSettingsAccessor;
import org.betterx.bclib.mixin.common.MobSpawnSettingsAccessor;
import org.betterx.bclib.util.CollectionsUtil;
import org.jetbrains.annotations.Nullable;

public class BiomeAPI {
    public static final BCLBiome EMPTY_BIOME = new BCLBiome(class_1972.field_9473.method_29177());
    private static final Map<class_2960, BCLBiome> ID_MAP = Maps.newHashMap();
    public static final BCLBiome NETHER_WASTES_BIOME = BiomeAPI.registerNetherBiome((class_1959)BiomeAPI.getFromRegistry((class_5321<class_1959>)class_1972.field_9461).comp_349());
    public static final BCLBiome CRIMSON_FOREST_BIOME = BiomeAPI.registerNetherBiome((class_1959)BiomeAPI.getFromRegistry((class_5321<class_1959>)class_1972.field_22077).comp_349());
    public static final BCLBiome WARPED_FOREST_BIOME = BiomeAPI.registerNetherBiome((class_1959)BiomeAPI.getFromRegistry((class_5321<class_1959>)class_1972.field_22075).comp_349());
    public static final BCLBiome SOUL_SAND_VALLEY_BIOME = BiomeAPI.registerNetherBiome((class_1959)BiomeAPI.getFromRegistry((class_5321<class_1959>)class_1972.field_22076).comp_349());
    public static final BCLBiome BASALT_DELTAS_BIOME = BiomeAPI.registerNetherBiome((class_1959)BiomeAPI.getFromRegistry((class_5321<class_1959>)class_1972.field_23859).comp_349());
    public static final BCLBiome THE_END = BiomeAPI.registerEndLandBiome(BiomeAPI.getFromRegistry((class_5321<class_1959>)class_1972.field_9411));
    public static final BCLBiome END_MIDLANDS = BiomeAPI.registerSubBiome(THE_END, (class_1959)BiomeAPI.getFromRegistry((class_5321<class_1959>)class_1972.field_9447).comp_349(), 0.5f);
    public static final BCLBiome END_HIGHLANDS = BiomeAPI.registerSubBiome(THE_END, (class_1959)BiomeAPI.getFromRegistry((class_5321<class_1959>)class_1972.field_9442).comp_349(), 0.5f);
    public static final BCLBiome END_BARRENS = BiomeAPI.registerEndVoidBiome(BiomeAPI.getFromRegistry(new class_2960("end_barrens")));
    public static final BCLBiome SMALL_END_ISLANDS = BiomeAPI.registerEndVoidBiome(BiomeAPI.getFromRegistry(new class_2960("small_end_islands")));

    public static BCLBiome registerBiome(BCLBiome bclbiome, BiomeType dim) {
        if (class_5458.field_25933.method_10223(bclbiome.getID()) == null) {
            class_1959 biome = bclbiome.getBiome();
            class_2960 loc = bclbiome.getID();
            class_2378.method_10230((class_2378)class_5458.field_25933, (class_2960)loc, (Object)biome);
        }
        ID_MAP.put(bclbiome.getID(), bclbiome);
        BiomeType.BIOME_TYPE_MAP.put(bclbiome.getID(), dim);
        if (dim != null && dim.is(BiomeType.NETHER)) {
            TagAPI.addBiomeTag((class_6862<class_1959>)class_6908.field_36518, bclbiome.getBiome());
            TagAPI.addBiomeTag(CommonBiomeTags.IN_NETHER, bclbiome.getBiome());
        } else if (dim != null && dim.is(BiomeType.END)) {
            TagAPI.addBiomeTag((class_6862<class_1959>)class_6908.field_37394, bclbiome.getBiome());
        }
        bclbiome.afterRegistration();
        return bclbiome;
    }

    public static BCLBiome registerSubBiome(BCLBiome parent, BCLBiome subBiome) {
        return BiomeAPI.registerSubBiome(parent, subBiome, BiomeType.BIOME_TYPE_MAP.getOrDefault(parent.getID(), BiomeType.NONE));
    }

    public static BCLBiome registerSubBiome(BCLBiome parent, class_1959 subBiome, float genChance) {
        return BiomeAPI.registerSubBiome(parent, subBiome, genChance, BiomeType.BIOME_TYPE_MAP.getOrDefault(parent.getID(), BiomeType.NONE));
    }

    public static BCLBiome registerSubBiome(BCLBiome parent, BCLBiome subBiome, BiomeType dim) {
        BiomeAPI.registerBiome(subBiome, dim);
        parent.addSubBiome(subBiome);
        return subBiome;
    }

    public static BCLBiome registerSubBiome(BCLBiome parent, class_1959 biome, float genChance, BiomeType dim) {
        BCLBiome subBiome = new BCLBiome(biome, (VanillaBiomeSettings)((VanillaBiomeSettings.Builder)VanillaBiomeSettings.createVanilla().setGenChance(genChance)).build());
        return BiomeAPI.registerSubBiome(parent, subBiome, dim);
    }

    public static BCLBiome registerNetherBiome(BCLBiome bclBiome) {
        BiomeAPI.registerBiome(bclBiome, BiomeType.BCL_NETHER);
        class_5321 key = BiomeAPI.getBiomeKey(bclBiome.getBiome());
        if (bclBiome.allowFabricRegistration()) {
            bclBiome.forEachClimateParameter(p -> NetherBiomeData.addNetherBiome((class_5321)key, (class_6544.class_4762)p));
        }
        return bclBiome;
    }

    public static BCLBiome registerNetherBiome(class_1959 biome) {
        BCLBiome bclBiome = new BCLBiome(biome, null);
        BiomeAPI.registerBiome(bclBiome, BiomeType.OTHER_NETHER);
        return bclBiome;
    }

    public static BCLBiome registerEndLandBiome(BCLBiome biome) {
        BiomeAPI.registerBiome(biome, BiomeType.BCL_END_LAND);
        float weight = biome.getGenChance();
        class_5321 key = BiomeAPI.getBiomeKey(biome.getBiome());
        if (biome.allowFabricRegistration()) {
            TheEndBiomeData.addEndBiomeReplacement((class_5321)class_1972.field_9442, (class_5321)key, (double)weight);
            TheEndBiomeData.addEndBiomeReplacement((class_5321)class_1972.field_9447, (class_5321)key, (double)weight);
        }
        return biome;
    }

    public static BCLBiome registerEndLandBiome(class_6880<class_1959> biome) {
        BCLBiome bclBiome = new BCLBiome((class_1959)biome.comp_349(), null);
        BiomeAPI.registerBiome(bclBiome, BiomeType.OTHER_END_LAND);
        return bclBiome;
    }

    public static BCLBiome registerEndLandBiome(class_6880<class_1959> biome, float genChance) {
        BCLBiome bclBiome = new BCLBiome((class_1959)biome.comp_349(), (VanillaBiomeSettings)((VanillaBiomeSettings.Builder)VanillaBiomeSettings.createVanilla().setGenChance(genChance)).build());
        BiomeAPI.registerBiome(bclBiome, BiomeType.OTHER_END_LAND);
        return bclBiome;
    }

    public static BCLBiome registerEndVoidBiome(BCLBiome biome) {
        BiomeAPI.registerBiome(biome, BiomeType.END_VOID);
        float weight = biome.getGenChance();
        class_5321 key = BiomeAPI.getBiomeKey(biome.getBiome());
        if (biome.allowFabricRegistration()) {
            TheEndBiomeData.addEndBiomeReplacement((class_5321)class_1972.field_9457, (class_5321)key, (double)weight);
        }
        return biome;
    }

    public static BCLBiome registerEndVoidBiome(class_6880<class_1959> biome) {
        BCLBiome bclBiome = new BCLBiome((class_1959)biome.comp_349(), null);
        BiomeAPI.registerBiome(bclBiome, BiomeType.END_VOID);
        return bclBiome;
    }

    public static BCLBiome registerEndVoidBiome(class_6880<class_1959> biome, float genChance) {
        BCLBiome bclBiome = new BCLBiome((class_1959)biome.comp_349(), (VanillaBiomeSettings)((VanillaBiomeSettings.Builder)VanillaBiomeSettings.createVanilla().setGenChance(genChance)).build());
        BiomeAPI.registerBiome(bclBiome, BiomeType.END_VOID);
        return bclBiome;
    }

    public static BCLBiome getFromBiome(class_6880<class_1959> biome) {
        if (InternalBiomeAPI.biomeRegistry == null) {
            return EMPTY_BIOME;
        }
        return ID_MAP.getOrDefault(((class_5321)biome.method_40230().orElseThrow()).method_29177(), EMPTY_BIOME);
    }

    @Environment(value=EnvType.CLIENT)
    public static BCLBiome getRenderBiome(class_1959 biome) {
        BCLBiome endBiome = InternalBiomeAPI.CLIENT.get(biome);
        if (endBiome == null) {
            class_310 minecraft = class_310.method_1551();
            class_2960 id = minecraft.field_1687.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome);
            endBiome = id == null ? EMPTY_BIOME : ID_MAP.getOrDefault(id, EMPTY_BIOME);
            InternalBiomeAPI.CLIENT.put(biome, endBiome);
        }
        return endBiome;
    }

    @Nullable
    public static class_5321 getBiomeKey(class_1959 biome) {
        Optional key;
        if (InternalBiomeAPI.biomeRegistry != null && (key = InternalBiomeAPI.biomeRegistry.method_29113((Object)biome)).isPresent()) {
            return (class_5321)key.get();
        }
        return (class_5321)class_5458.field_25933.method_29113((Object)biome).orElseGet(null);
    }

    public static class_2960 getBiomeID(class_1959 biome) {
        class_2960 id = null;
        if (InternalBiomeAPI.biomeRegistry != null) {
            id = InternalBiomeAPI.biomeRegistry.method_10221((Object)biome);
        }
        if (id == null) {
            id = class_5458.field_25933.method_10221((Object)biome);
        }
        if (id == null) {
            BCLib.LOGGER.error("Unable to get ID for " + biome + ". Falling back to empty Biome...");
            id = EMPTY_BIOME.getID();
        }
        return id;
    }

    public static class_2960 getBiomeID(class_6880<class_1959> biome) {
        Optional oKey = biome.method_40230();
        if (oKey.isPresent()) {
            return ((class_5321)oKey.get()).method_29177();
        }
        return null;
    }

    public static class_5321 getBiomeKey(class_6880<class_1959> biome) {
        return biome.method_40230().orElse(null);
    }

    public static class_5321 getBiomeKeyOrThrow(class_6880<class_1959> biome) {
        return (class_5321)biome.method_40230().orElseThrow();
    }

    public static class_6880<class_1959> getBiomeHolder(BCLBiome biome) {
        return BiomeAPI.getBiomeHolder(biome.getBiome());
    }

    public static class_6880<class_1959> getBiomeHolder(class_1959 biome) {
        Optional key;
        if (InternalBiomeAPI.biomeRegistry != null && (key = InternalBiomeAPI.biomeRegistry.method_29113((Object)biome)).isPresent()) {
            return InternalBiomeAPI.biomeRegistry.method_44298((class_5321)key.get());
        }
        return class_5458.field_25933.method_44298(BiomeAPI.getBiomeKey(biome));
    }

    public static class_6880<class_1959> getBiomeHolder(class_2960 biome) {
        if (InternalBiomeAPI.biomeRegistry != null) {
            return BiomeAPI.getBiomeHolder((class_1959)InternalBiomeAPI.biomeRegistry.method_10223(biome));
        }
        return BiomeAPI.getBiomeHolder((class_1959)class_5458.field_25933.method_10223(biome));
    }

    public static BCLBiome getBiome(class_2960 biomeID) {
        return ID_MAP.getOrDefault(biomeID, EMPTY_BIOME);
    }

    public static BCLBiome getBiome(class_1959 biome) {
        return BiomeAPI.getBiome(BiomeAPI.getBiomeID(biome));
    }

    public static BCLBiome getBiome(class_6880<class_1959> biome) {
        return BiomeAPI.getBiome(BiomeAPI.getBiomeID(biome));
    }

    public static boolean hasBiome(class_2960 biomeID) {
        return ID_MAP.containsKey(biomeID);
    }

    @Nullable
    public static class_6880<class_1959> getFromRegistry(class_2960 key) {
        return (class_6880)class_5458.field_25933.method_40264(class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)key)).orElseThrow();
    }

    @Nullable
    public static class_6880<class_1959> getFromRegistry(class_5321<class_1959> key) {
        return class_5458.field_25933.method_44298(key);
    }

    public static boolean isDatapackBiome(class_2960 biomeID) {
        return BiomeAPI.getFromRegistry(biomeID) == null;
    }

    public static boolean wasRegisteredAs(class_2960 biomeID, BiomeType dim) {
        if (BiomeType.BIOME_TYPE_MAP.containsKey(biomeID) && BiomeType.BIOME_TYPE_MAP.get(biomeID).is(dim)) {
            return true;
        }
        BCLBiome biome = BiomeAPI.getBiome(biomeID);
        if (biome != null && biome != EMPTY_BIOME && biome.getParentBiome() != null) {
            return BiomeAPI.wasRegisteredAs(biome.getParentBiome().getID(), dim);
        }
        return false;
    }

    public static boolean wasRegisteredAsNetherBiome(class_2960 biomeID) {
        return BiomeAPI.wasRegisteredAs(biomeID, BiomeType.NETHER);
    }

    public static boolean wasRegisteredAsEndBiome(class_2960 biomeID) {
        return BiomeAPI.wasRegisteredAs(biomeID, BiomeType.END);
    }

    public static boolean wasRegisteredAsEndLandBiome(class_2960 biomeID) {
        return BiomeAPI.wasRegisteredAs(biomeID, BiomeType.END_LAND);
    }

    public static boolean wasRegisteredAsEndVoidBiome(class_2960 biomeID) {
        return BiomeAPI.wasRegisteredAs(biomeID, BiomeType.END_VOID);
    }

    public static void registerBiomeModification(class_5321<class_5363> dimensionID, BiConsumer<class_2960, class_6880<class_1959>> modification) {
        List modifications = InternalBiomeAPI.MODIFICATIONS.computeIfAbsent(dimensionID, k -> Lists.newArrayList());
        modifications.add(modification);
    }

    public static void registerOverworldBiomeModification(BiConsumer<class_2960, class_6880<class_1959>> modification) {
        BiomeAPI.registerBiomeModification((class_5321<class_5363>)class_5363.field_25412, modification);
    }

    public static void registerNetherBiomeModification(BiConsumer<class_2960, class_6880<class_1959>> modification) {
        BiomeAPI.registerBiomeModification((class_5321<class_5363>)class_5363.field_25413, modification);
    }

    public static void registerEndBiomeModification(BiConsumer<class_2960, class_6880<class_1959>> modification) {
        BiomeAPI.registerBiomeModification((class_5321<class_5363>)class_5363.field_25414, modification);
    }

    public static void onFinishingBiomeTags(class_5321 dimensionID, BiConsumer<class_2960, class_6880<class_1959>> modification) {
        List modifications = InternalBiomeAPI.TAG_ADDERS.computeIfAbsent(dimensionID, k -> Lists.newArrayList());
        modifications.add(modification);
    }

    public static void onFinishingNetherBiomeTags(BiConsumer<class_2960, class_6880<class_1959>> modification) {
        BiomeAPI.onFinishingBiomeTags(class_1937.field_25180, modification);
    }

    public static void onFinishingEndBiomeTags(BiConsumer<class_2960, class_6880<class_1959>> modification) {
        BiomeAPI.onFinishingBiomeTags(class_1937.field_25181, modification);
    }

    public static void sortBiomeFeatures(class_6880<class_1959> biome) {
        BiomeAPI.sortBiomeFeatures((class_1959)biome.comp_349());
    }

    static void sortBiomeFeatures(class_1959 biome) {
        class_5485 settings = biome.method_30970();
        BiomeGenerationSettingsAccessor accessor = (BiomeGenerationSettingsAccessor)settings;
        List<class_6885<class_6796>> featureList = CollectionsUtil.getMutable(accessor.bclib_getFeatures());
        int size = featureList.size();
        for (int i = 0; i < size; ++i) {
            List<class_6880<class_6796>> features = BiomeAPI.getFeaturesListCopy(featureList, i);
            BiomeAPI.sortFeatures(features);
            featureList.set(i, (class_6885<class_6796>)class_6885.method_40242(features));
        }
        accessor.bclib_setFeatures(featureList);
    }

    public static void addBiomeFeature(class_6880<class_1959> biome, BCLFeature feature) {
        BiomeAPI.addBiomeFeature(biome, feature.getDecoration(), feature.getPlacedFeature());
    }

    public static void addBiomeFeature(class_6880<class_1959> biome, class_2893.class_2895 step, class_6880<class_6796> ... featureList) {
        BiomeAPI.addBiomeFeature(biome, step, List.of(featureList));
    }

    private static void addBiomeFeature(class_6880<class_1959> biome, class_2893.class_2895 step, List<class_6880<class_6796>> additionalFeatures) {
        BiomeGenerationSettingsAccessor accessor = (BiomeGenerationSettingsAccessor)((class_1959)biome.comp_349()).method_30970();
        List<class_6885<class_6796>> allFeatures = CollectionsUtil.getMutable(accessor.bclib_getFeatures());
        List<class_6880<class_6796>> features = BiomeAPI.getFeaturesListCopy(allFeatures, step);
        for (class_6880<class_6796> feature : additionalFeatures) {
            if (features.contains(feature)) continue;
            features.add(feature);
        }
        allFeatures.set(step.ordinal(), (class_6885<class_6796>)class_6885.method_40242(features));
        com.google.common.base.Supplier flowerFeatures = Suppliers.memoize(() -> (List)allFeatures.stream().flatMap(class_6885::method_40239).map(class_6880::comp_349).flatMap(class_6796::method_39643).filter(configuredFeature -> configuredFeature.comp_332() == class_3031.field_21219).collect(ImmutableList.toImmutableList()));
        com.google.common.base.Supplier featureSet = Suppliers.memoize(() -> allFeatures.stream().flatMap(class_6885::method_40239).map(class_6880::comp_349).collect(Collectors.toSet()));
        accessor.bclib_setFeatures(allFeatures);
        accessor.bclib_setFeatureSet((Supplier<Set<class_6796>>)featureSet);
        accessor.bclib_setFlowerFeatures((Supplier<List<class_2975<?, ?>>>)flowerFeatures);
    }

    public static <M extends class_1308> void addBiomeMobSpawn(class_6880<class_1959> biome, class_1299<M> entityType, int weight, int minGroupCount, int maxGroupCount) {
        class_1311 category = entityType.method_5891();
        MobSpawnSettingsAccessor accessor = (MobSpawnSettingsAccessor)((class_1959)biome.comp_349()).method_30966();
        Map<class_1311, class_6012<class_5483.class_1964>> spawners = CollectionsUtil.getMutable(accessor.bcl_getSpawners());
        ArrayList mobs = spawners.containsKey(category) ? CollectionsUtil.getMutable(spawners.get(category).method_34994()) : Lists.newArrayList();
        mobs.add(new class_5483.class_1964(entityType, weight, minGroupCount, maxGroupCount));
        spawners.put(category, (class_6012<class_5483.class_1964>)class_6012.method_34988((List)mobs));
        accessor.bcl_setSpawners(spawners);
    }

    public static Optional<class_2680> findTopMaterial(class_5281 world, class_2338 pos) {
        return BiomeAPI.findTopMaterial(BiomeAPI.getBiome((class_6880<class_1959>)world.method_23753(pos)));
    }

    public static Optional<class_2680> findTopMaterial(class_6880<class_1959> biome) {
        return BiomeAPI.findTopMaterial(BiomeAPI.getBiome((class_1959)biome.comp_349()));
    }

    public static Optional<class_2680> findTopMaterial(class_1959 biome) {
        return BiomeAPI.findTopMaterial(BiomeAPI.getBiome(biome));
    }

    public static Optional<class_2680> findTopMaterial(BCLBiome biome) {
        if (biome instanceof SurfaceMaterialProvider) {
            SurfaceMaterialProvider smp = (SurfaceMaterialProvider)((Object)biome);
            return Optional.of(smp.getTopMaterial());
        }
        return Optional.empty();
    }

    public static Optional<class_2680> findUnderMaterial(class_6880<class_1959> biome) {
        return BiomeAPI.findUnderMaterial(BiomeAPI.getBiome((class_1959)biome.comp_349()));
    }

    public static Optional<class_2680> findUnderMaterial(BCLBiome biome) {
        if (biome instanceof SurfaceMaterialProvider) {
            SurfaceMaterialProvider smp = (SurfaceMaterialProvider)((Object)biome);
            return Optional.of(smp.getUnderMaterial());
        }
        return Optional.empty();
    }

    public static void setBiome(class_2791 chunk, class_2338 pos, class_6880<class_1959> biome) {
        int sectionY = pos.method_10264() - chunk.method_31607() >> 4;
        class_7522 biomes = chunk.method_38259(sectionY).method_38294();
        if (biomes instanceof class_2841) {
            class_2841 palette = (class_2841)biomes;
            palette.method_35321((pos.method_10263() & 0xF) >> 2, (pos.method_10264() & 0xF) >> 2, (pos.method_10260() & 0xF) >> 2, biome);
        } else {
            BCLib.LOGGER.warning("Unable to change Biome at " + pos, new Object[0]);
        }
    }

    public static void setBiome(class_1936 level, class_2338 pos, class_6880<class_1959> biome) {
        class_2791 chunk = level.method_22350(pos);
        BiomeAPI.setBiome(chunk, pos, biome);
    }

    private static void sortFeatures(List<class_6880<class_6796>> features) {
        InternalBiomeAPI.initFeatureOrder();
        HashSet featuresWithoutDuplicates = Sets.newHashSet();
        features.forEach(holder -> featuresWithoutDuplicates.add(holder));
        if (featuresWithoutDuplicates.size() != features.size()) {
            features.clear();
            featuresWithoutDuplicates.forEach(feature -> features.add((class_6880<class_6796>)feature));
        }
        features.forEach(feature -> InternalBiomeAPI.FEATURE_ORDER.computeIfAbsent((class_6880<class_6796>)feature, f -> InternalBiomeAPI.FEATURE_ORDER_ID.getAndIncrement()));
        features.sort((f1, f2) -> {
            int v1 = InternalBiomeAPI.FEATURE_ORDER.getOrDefault(f1, 70000);
            int v2 = InternalBiomeAPI.FEATURE_ORDER.getOrDefault(f2, 70000);
            return Integer.compare(v1, v2);
        });
    }

    private static List<class_6880<class_6796>> getFeaturesListCopy(List<class_6885<class_6796>> features, class_2893.class_2895 step) {
        return BiomeAPI.getFeaturesListCopy(features, step.ordinal());
    }

    private static List<class_6880<class_6796>> getFeaturesListCopy(List<class_6885<class_6796>> features, int index) {
        while (features.size() <= index) {
            features.add((class_6885<class_6796>)class_6885.method_40242((List)Lists.newArrayList()));
        }
        return features.get(index).method_40239().collect(Collectors.toList());
    }

    public static class BiomeType {
        public static final BiomeType NONE = new BiomeType("NONE");
        public static final BiomeType OVERWORLD = new BiomeType("OVERWORLD");
        public static final BiomeType NETHER = new BiomeType("NETHER");
        public static final BiomeType BCL_NETHER = new BiomeType("BCL_NETHER", NETHER);
        public static final BiomeType OTHER_NETHER = new BiomeType("OTHER_NETHER", NETHER);
        public static final BiomeType END = new BiomeType("END");
        public static final BiomeType END_LAND = new BiomeType("END_LAND", END);
        public static final BiomeType END_VOID = new BiomeType("END_VOID", END);
        public static final BiomeType BCL_END_LAND = new BiomeType("BCL_END_LAND", END_LAND);
        public static final BiomeType BCL_END_VOID = new BiomeType("BCL_END_VOID", END_VOID);
        public static final BiomeType OTHER_END_LAND = new BiomeType("OTHER_END_LAND", END_LAND);
        public static final BiomeType OTHER_END_VOID = new BiomeType("OTHER_END_VOID", END_VOID);
        static final Map<class_2960, BiomeType> BIOME_TYPE_MAP = Maps.newHashMap();
        public final BiomeType parentOrNull;
        private final String debugName;

        public BiomeType(String debugName) {
            this(debugName, null);
        }

        public BiomeType(String debugName, BiomeType parentOrNull) {
            this.parentOrNull = parentOrNull;
            this.debugName = debugName;
        }

        public boolean is(BiomeType d) {
            if (d == this) {
                return true;
            }
            if (this.parentOrNull != null) {
                return this.parentOrNull.is(d);
            }
            return false;
        }

        public String toString() {
            Object str = this.debugName;
            if (this.parentOrNull != null) {
                str = (String)str + " -> " + this.parentOrNull;
            }
            return str;
        }
    }
}

