/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.biomes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5819;
import net.minecraft.class_6544;
import net.minecraft.class_6686;
import net.minecraft.class_6862;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.VanillaBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.surface.SurfaceRuleUtil;
import org.betterx.bclib.api.v2.tag.TagAPI;
import org.betterx.bclib.util.WeightedList;
import org.jetbrains.annotations.Nullable;

public class BCLBiome
extends BCLBiomeSettings {
    private final Set<class_6862<class_1959>> biomeTags = Sets.newHashSet();
    private final WeightedList<BCLBiome> subbiomes = new WeightedList();
    private final Map<String, Object> customData = Maps.newHashMap();
    private final class_2960 biomeID;
    private final class_1959 biome;
    private final List<class_6544.class_4762> parameterPoints = Lists.newArrayList();
    private Consumer<class_5321<class_1959>> surfaceInit;
    private BCLBiome biomeParent;
    private final boolean didLoadConfig = false;

    protected BCLBiome(class_5321<class_1959> biomeKey) {
        this(biomeKey.method_29177());
    }

    protected BCLBiome(class_2960 biomeID) {
        this(biomeID, (class_1959)class_5458.field_25933.method_10223(biomeID), null);
    }

    protected BCLBiome(class_1959 biome) {
        this(biome, null);
    }

    protected BCLBiome(class_1959 biome, VanillaBiomeSettings settings) {
        this(BiomeAPI.getBiomeID(biome), biome, settings);
    }

    public BCLBiome(class_2960 biomeID, class_1959 biome) {
        this(biomeID, biome, null);
    }

    protected BCLBiome(class_2960 biomeID, class_1959 biome, BCLBiomeSettings defaults) {
        this.subbiomes.add(this, 1.0f);
        this.biomeID = biomeID;
        this.biome = biome;
        if (defaults != null) {
            defaults.applyWithDefaults(this);
        }
    }

    @Override
    @Nullable
    public BCLBiome getEdge() {
        return this.edge;
    }

    BCLBiome setEdge(BCLBiome edge) {
        this.edge = edge;
        edge.biomeParent = this;
        return this;
    }

    public BCLBiome addSubBiome(BCLBiome biome) {
        biome.biomeParent = this;
        this.subbiomes.add(biome, biome.getGenChance());
        return this;
    }

    public boolean containsSubBiome(BCLBiome biome) {
        return this.subbiomes.contains(biome);
    }

    public BCLBiome getSubBiome(class_2919 random) {
        return this.subbiomes.get((class_5819)random);
    }

    public void forEachSubBiome(BiConsumer<BCLBiome, Float> consumer) {
        for (int i = 0; i < this.subbiomes.size(); ++i) {
            consumer.accept(this.subbiomes.get(i), Float.valueOf(this.subbiomes.getWeight(i)));
        }
    }

    @Nullable
    public BCLBiome getParentBiome() {
        return this.biomeParent;
    }

    public boolean isSame(BCLBiome biome) {
        return biome == this || biome.biomeParent != null && biome.biomeParent == this;
    }

    public class_2960 getID() {
        return this.biomeID;
    }

    public class_1959 getBiome() {
        return this.biome;
    }

    void afterRegistration() {
        class_5321 key = (class_5321)class_5458.field_25933.method_29113((Object)this.getBiome()).orElseThrow();
        this.biomeTags.forEach(tagKey -> TagAPI.addBiomeTag((class_6862<class_1959>)tagKey, this.biome));
        if (this.surfaceInit != null) {
            this.surfaceInit.accept((class_5321<class_1959>)key);
        }
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public <T> T getCustomData(String name) {
        return (T)this.customData.get(name);
    }

    @Deprecated(forRemoval=true)
    public <T> T getCustomData(String name, T defaultValue) {
        return (T)this.customData.getOrDefault(name, defaultValue);
    }

    public BCLBiome addCustomData(String name, Object obj) {
        this.customData.put(name, obj);
        return this;
    }

    public BCLBiome addCustomData(Map<String, Object> data) {
        this.customData.putAll(data);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        BCLBiome biome = (BCLBiome)obj;
        return biome != null && this.biomeID.equals((Object)biome.biomeID);
    }

    public int hashCode() {
        return this.biomeID.hashCode();
    }

    public String toString() {
        return this.biomeID.toString();
    }

    void addBiomeTags(Set<class_6862<class_1959>> tags) {
        this.biomeTags.addAll(tags);
    }

    void addClimateParameters(List<class_6544.class_4762> params) {
        this.parameterPoints.addAll(params);
    }

    public void forEachClimateParameter(Consumer<class_6544.class_4762> consumer) {
        this.parameterPoints.forEach(consumer);
    }

    void setSurface(class_6686.class_6708 surface) {
        this.surfaceInit = key -> {
            if (key == null) {
                BCLib.LOGGER.warning("BCL Biome " + this.biomeID + " does not have registry key!", new Object[0]);
            } else {
                SurfaceRuleUtil.addSurfaceRule(this.biomeID, class_6686.method_39049((class_6686.class_6693)class_6686.method_39055((class_5321[])new class_5321[]{key}), (class_6686.class_6708)surface));
            }
        };
    }

    public String configGroup() {
        return this.biomeID.method_12836() + "." + this.biomeID.method_12832();
    }

    public boolean isEdgeBiome() {
        if (this.getParentBiome() == null) {
            return false;
        }
        return this.getParentBiome().edge == this;
    }

    boolean allowFabricRegistration() {
        return !this.isEdgeBiome();
    }
}

