/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_5216;
import net.minecraft.class_5284;
import net.minecraft.class_5285;
import net.minecraft.class_5317;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7059;
import net.minecraft.class_7145;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.WorldDataAPI;
import org.betterx.bclib.api.v2.generator.BCLBiomeSource;
import org.betterx.bclib.api.v2.generator.BCLChunkGenerator;
import org.betterx.bclib.api.v2.generator.BCLibEndBiomeSource;
import org.betterx.bclib.api.v2.generator.BCLibNetherBiomeSource;
import org.betterx.bclib.mixin.common.RegistryOpsAccessor;
import org.betterx.bclib.presets.worldgen.BCLWorldPresetSettings;
import org.betterx.bclib.presets.worldgen.BCLWorldPresets;
import org.betterx.bclib.presets.worldgen.WorldPresetSettings;
import org.betterx.bclib.util.ModUtil;
import org.jetbrains.annotations.NotNull;

public class LevelGenUtil {
    private static final String TAG_VERSION = "version";
    private static final String TAG_BN_GEN_VERSION = "generator_version";
    private static final String TAG_GENERATOR = "generator";

    @NotNull
    public static class_5363 getBCLNetherLevelStem(Context context, Optional<Integer> version) {
        BCLibNetherBiomeSource netherSource = new BCLibNetherBiomeSource(context.biomes, version);
        return LevelGenUtil.getBCLNetherLevelStem((StemContext)context, netherSource);
    }

    public static class_5363 getBCLNetherLevelStem(StemContext context, class_1966 biomeSource) {
        return new class_5363(context.dimension, (class_2794)new BCLChunkGenerator(context.structureSets, context.noiseParameters, biomeSource, context.generatorSettings));
    }

    @NotNull
    public static class_5363 getBCLEndLevelStem(StemContext context, class_1966 biomeSource) {
        return new class_5363(context.dimension, (class_2794)new BCLChunkGenerator(context.structureSets, context.noiseParameters, biomeSource, context.generatorSettings));
    }

    public static class_5363 getBCLEndLevelStem(Context context, Optional<Integer> version) {
        BCLibEndBiomeSource endSource = new BCLibEndBiomeSource(context.biomes, version);
        return LevelGenUtil.getBCLEndLevelStem((StemContext)context, endSource);
    }

    public static class_5285 fixSettingsInCurrentWorld(Optional<class_6903<class_2520>> registryOps, class_5285 settings) {
        Object var3_2 = registryOps.orElse(null);
        if (var3_2 instanceof RegistryOpsAccessor) {
            RegistryOpsAccessor acc = var3_2;
            return LevelGenUtil.getWorldSettings().repairSettingsOnLoad(acc.bcl_getRegistryAccess(), settings);
        }
        BCLib.LOGGER.error("Unable to obtain registryAccess when enforcing generators.");
        return settings;
    }

    public static class_5285 createWorldFromPreset(class_5321<class_7145> preset, class_5455 registryAccess, long seed, boolean generateStructures, boolean generateBonusChest) {
        class_5285 settings = ((class_7145)registryAccess.method_30530(class_2378.field_37998).method_40290(preset).comp_349()).method_41585(seed, generateStructures, generateBonusChest);
        for (class_5363 stem : settings.method_28609()) {
            class_1966 class_19662 = stem.method_29571().method_12098();
            if (!(class_19662 instanceof BCLBiomeSource)) continue;
            BCLBiomeSource bcl = (BCLBiomeSource)class_19662;
            bcl.setSeed(seed);
        }
        return settings;
    }

    public static class_5285 createDefaultWorldFromPreset(class_5455 registryAccess, long seed, boolean generateStructures, boolean generateBonusChest) {
        return LevelGenUtil.createWorldFromPreset(BCLWorldPresets.DEFAULT.orElseThrow(), registryAccess, seed, generateStructures, generateBonusChest);
    }

    public static Pair<class_5285, class_5455.class_6890> defaultWorldDataSupplier(class_5455.class_6890 frozen) {
        class_5285 worldGenSettings = LevelGenUtil.createDefaultWorldFromPreset((class_5455)frozen);
        return Pair.of((Object)worldGenSettings, (Object)frozen);
    }

    public static class_5285 createDefaultWorldFromPreset(class_5455 registryAccess, long seed) {
        return LevelGenUtil.createDefaultWorldFromPreset(registryAccess, seed, true, false);
    }

    public static class_5285 createDefaultWorldFromPreset(class_5455 registryAccess) {
        return LevelGenUtil.createDefaultWorldFromPreset(registryAccess, class_5819.method_43047().method_43055());
    }

    public static class_5285 replaceGenerator(class_5321<class_5363> dimensionKey, class_5321<class_2874> dimensionTypeKey, int biomeSourceVersion, class_5455 registryAccess, class_5285 worldGenSettings) {
        Optional<class_6880<class_5363>> oLevelStem = LevelGenUtil.referenceStemForVersion(dimensionKey, biomeSourceVersion, registryAccess, worldGenSettings.method_28028(), worldGenSettings.method_28029(), worldGenSettings.method_28029());
        return LevelGenUtil.replaceGenerator(dimensionKey, dimensionTypeKey, registryAccess, worldGenSettings, oLevelStem.map(l -> ((class_5363)l.comp_349()).method_29571()).orElseThrow());
    }

    public static class_5285 replaceGenerator(class_5321<class_5363> dimensionKey, class_5321<class_2874> dimensionTypeKey, class_5455 registryAccess, class_5285 worldGenSettings, class_2794 generator) {
        class_2378 dimensionTypeRegistry = registryAccess.method_30530(class_2378.field_25095);
        class_2378<class_5363> newDimensions = LevelGenUtil.withDimension(dimensionKey, dimensionTypeKey, (class_2378<class_2874>)dimensionTypeRegistry, (class_2378<class_5363>)worldGenSettings.method_28609(), generator);
        return new class_5285(worldGenSettings.method_28028(), worldGenSettings.method_28029(), worldGenSettings.method_28030(), newDimensions);
    }

    public static class_5285 replaceStem(class_5321<class_5363> dimensionKey, class_5285 worldGenSettings, class_5363 levelStem) {
        class_2378<class_5363> newDimensions = LevelGenUtil.withDimension(dimensionKey, (class_2378<class_5363>)worldGenSettings.method_28609(), levelStem);
        return new class_5285(worldGenSettings.method_28028(), worldGenSettings.method_28029(), worldGenSettings.method_28030(), newDimensions);
    }

    public static class_2378<class_5363> withDimension(class_5321<class_5363> dimensionKey, class_5321<class_2874> dimensionTypeKey, class_2378<class_2874> dimensionTypeRegistry, class_2378<class_5363> inputDimensions, class_2794 generator) {
        class_5363 levelStem = (class_5363)inputDimensions.method_29107(dimensionKey);
        class_6880 dimensionType = levelStem == null ? dimensionTypeRegistry.method_44298(dimensionTypeKey) : levelStem.method_29566();
        return LevelGenUtil.withDimension(dimensionKey, inputDimensions, new class_5363(dimensionType, generator));
    }

    public static class_2378<class_5363> withDimension(class_5321<class_5363> dimensionKey, class_2378<class_5363> inputDimensions, class_5363 levelStem) {
        class_2370 writableRegistry = new class_2370(class_2378.field_25490, Lifecycle.experimental(), null);
        writableRegistry.method_10272(dimensionKey, (Object)levelStem, Lifecycle.stable());
        for (Map.Entry entry : inputDimensions.method_29722()) {
            class_5321 resourceKey = (class_5321)entry.getKey();
            if (resourceKey == dimensionKey) continue;
            writableRegistry.method_10272(resourceKey, (Object)((class_5363)entry.getValue()), inputDimensions.method_31139((Object)((class_5363)entry.getValue())));
        }
        return writableRegistry;
    }

    public static int getBiomeVersionForGenerator(class_2794 generator) {
        if (generator == null) {
            return BCLBiomeSource.getVersionBiomeSource(null);
        }
        return BCLBiomeSource.getVersionBiomeSource(generator.method_12098());
    }

    public static Optional<class_6880<class_5363>> referenceStemForVersion(class_5321<class_5363> dimensionKey, int biomeSourceVersion, class_5455 registryAccess, long seed, boolean generateStructures, boolean generateBonusChest) {
        class_5285 referenceSettings = biomeSourceVersion == BCLBiomeSource.BIOME_SOURCE_VERSION_VANILLA ? class_5317.method_29077((class_5455)registryAccess, (long)seed, (boolean)generateStructures, (boolean)generateBonusChest) : (biomeSourceVersion == BCLBiomeSource.BIOME_SOURCE_VERSION_SQUARE ? LevelGenUtil.createWorldFromPreset(BCLWorldPresets.BCL_WORLD_17, registryAccess, seed, generateStructures, generateBonusChest) : LevelGenUtil.createDefaultWorldFromPreset(registryAccess, seed, generateStructures, generateBonusChest));
        return referenceSettings.method_28609().method_40264(dimensionKey);
    }

    public static int getBiomeVersionForCurrentWorld(class_5321<class_5363> key) {
        class_2487 settingsNbt = LevelGenUtil.getSettingsNbt();
        if (!settingsNbt.method_10545(key.method_29177().toString())) {
            return BCLBiomeSource.DEFAULT_BIOME_SOURCE_VERSION;
        }
        return settingsNbt.method_10550(key.method_29177().toString());
    }

    private static int getDimensionVersion(class_5285 settings, class_5321<class_5363> key) {
        Optional dimension = settings.method_28609().method_40264(key);
        if (dimension.isPresent()) {
            return LevelGenUtil.getBiomeVersionForGenerator(((class_5363)((class_6880)dimension.get()).comp_349()).method_29571());
        }
        return LevelGenUtil.getBiomeVersionForGenerator(null);
    }

    private static void writeDimensionVersion(class_5285 settings, class_2487 generatorSettings, class_5321<class_5363> key) {
        generatorSettings.method_10569(key.method_29177().toString(), LevelGenUtil.getDimensionVersion(settings, key));
    }

    public static void initializeWorldData(class_5285 settings) {
        LevelGenUtil.updateWorldData(LevelGenUtil.getDimensionVersion(settings, (class_5321<class_5363>)class_5363.field_25413), LevelGenUtil.getDimensionVersion(settings, (class_5321<class_5363>)class_5363.field_25414));
    }

    public static void updateWorldData(int netherVersion, int endVersion) {
        BCLWorldPresetSettings worldSettings = new BCLWorldPresetSettings(netherVersion, endVersion);
        class_5455.class_6893 registryAccess = class_5455.method_40314();
        class_6903 registryOps = class_6903.method_40414((DynamicOps)class_2509.field_11560, (class_5455)registryAccess);
        Codec codec = WorldPresetSettings.CODEC.orElse((Object)worldSettings);
        DataResult encodeResult = codec.encodeStart((DynamicOps)registryOps, (Object)worldSettings);
        if (encodeResult.result().isPresent()) {
            class_2487 settingsNbt = WorldDataAPI.getRootTag("worlds_together");
            settingsNbt.method_10566(TAG_GENERATOR, (class_2520)encodeResult.result().get());
        } else {
            BCLib.LOGGER.error("Unable to encode world generator settings generator for level.dat.");
        }
        WorldDataAPI.saveFile("worlds_together");
    }

    static class_2487 getSettingsNbt() {
        return WorldDataAPI.getCompoundTag("worlds_together", TAG_GENERATOR);
    }

    public static WorldPresetSettings getWorldSettings() {
        class_5455.class_6893 registryAccess = class_5455.method_40314();
        class_6903 registryOps = class_6903.method_40414((DynamicOps)class_2509.field_11560, (class_5455)registryAccess);
        Optional oLevelStem = WorldPresetSettings.CODEC.parse(new Dynamic((DynamicOps)registryOps, (Object)LevelGenUtil.getSettingsNbt())).resultOrPartial(BCLib.LOGGER::error);
        return oLevelStem.orElse(BCLWorldPresetSettings.DEFAULT);
    }

    public static void migrateGeneratorSettings() {
        class_2487 settingsNbt = LevelGenUtil.getSettingsNbt();
        if (settingsNbt.method_10546() == 0) {
            boolean isPre18;
            BCLib.LOGGER.info("Found World without generator Settings. Setting up data...");
            int biomeSourceVersion = BCLBiomeSource.DEFAULT_BIOME_SOURCE_VERSION;
            class_2487 bclRoot = WorldDataAPI.getRootTag("bclib");
            String bclVersion = "0.0.0";
            if (bclRoot.method_10545(TAG_VERSION)) {
                bclVersion = bclRoot.method_10558(TAG_VERSION);
            }
            boolean bl = isPre18 = !ModUtil.isLargerOrEqualVersion(bclVersion, "1.0.0");
            if (isPre18) {
                BCLib.LOGGER.info("World was create pre 1.18!");
                biomeSourceVersion = BCLBiomeSource.BIOME_SOURCE_VERSION_SQUARE;
            }
            if (WorldDataAPI.hasMod("betternether")) {
                BCLib.LOGGER.info("Found Data from BetterNether, using for migration.");
                class_2487 bnRoot = WorldDataAPI.getRootTag("betternether");
                biomeSourceVersion = "1.17".equals(bnRoot.method_10558(TAG_BN_GEN_VERSION)) ? BCLBiomeSource.BIOME_SOURCE_VERSION_SQUARE : BCLBiomeSource.BIOME_SOURCE_VERSION_HEX;
            }
            BCLib.LOGGER.info("Set world to BiomeSource Version " + biomeSourceVersion);
            LevelGenUtil.updateWorldData(biomeSourceVersion, biomeSourceVersion);
        }
    }

    public static class Context
    extends StemContext {
        public final class_2378<class_1959> biomes;

        public Context(class_2378<class_1959> biomes, class_6880<class_2874> dimension, class_2378<class_7059> structureSets, class_2378<class_5216.class_5487> noiseParameters, class_6880<class_5284> generatorSettings) {
            super(dimension, structureSets, noiseParameters, generatorSettings);
            this.biomes = biomes;
        }
    }

    public static class StemContext {
        public final class_6880<class_2874> dimension;
        public final class_2378<class_7059> structureSets;
        public final class_2378<class_5216.class_5487> noiseParameters;
        public final class_6880<class_5284> generatorSettings;

        public StemContext(class_6880<class_2874> dimension, class_2378<class_7059> structureSets, class_2378<class_5216.class_5487> noiseParameters, class_6880<class_5284> generatorSettings) {
            this.dimension = dimension;
            this.structureSets = structureSets;
            this.noiseParameters = noiseParameters;
            this.generatorSettings = generatorSettings;
        }
    }
}

