/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator.map;

import java.util.Random;
import net.minecraft.class_3532;
import org.apache.commons.lang3.function.TriFunction;
import org.betterx.bclib.api.v2.generator.BiomePicker;
import org.betterx.bclib.interfaces.BiomeChunk;
import org.betterx.bclib.interfaces.BiomeMap;
import org.betterx.bclib.interfaces.TriConsumer;
import org.betterx.bclib.noise.OpenSimplexNoise;

public class MapStack
implements BiomeMap {
    private final OpenSimplexNoise noise;
    private final BiomeMap[] maps;
    private final double layerDistortion;
    private final int worldHeight;
    private final int minValue;
    private final int maxValue;
    private final int maxIndex;

    public MapStack(long seed, int size, BiomePicker picker, int mapHeight, int worldHeight, TriFunction<Long, Integer, BiomePicker, BiomeMap> mapConstructor) {
        int mapCount = class_3532.method_15386((float)((float)worldHeight / (float)mapHeight));
        this.maxIndex = mapCount - 1;
        this.worldHeight = worldHeight;
        this.layerDistortion = (double)mapHeight * 0.1;
        this.minValue = class_3532.method_15375((float)((float)mapHeight * 0.5f + 0.5f));
        this.maxValue = class_3532.method_15375((float)((float)worldHeight - (float)mapHeight * 0.5f + 0.5f));
        this.maps = new BiomeMap[mapCount];
        Random random = new Random(seed);
        for (int i = 0; i < mapCount; ++i) {
            this.maps[i] = (BiomeMap)mapConstructor.apply((Object)random.nextLong(), (Object)size, (Object)picker);
            this.maps[i].setChunkProcessor(this::onChunkCreation);
        }
        this.noise = new OpenSimplexNoise(random.nextInt());
    }

    @Override
    public void clearCache() {
        for (BiomeMap map : this.maps) {
            map.clearCache();
        }
    }

    @Override
    public void setChunkProcessor(TriConsumer<Integer, Integer, Integer> processor) {
    }

    @Override
    public BiomeChunk getChunk(int cx, int cz, boolean update) {
        return null;
    }

    @Override
    public BiomePicker.ActualBiome getBiome(double x, double y, double z) {
        int mapIndex;
        if (y < (double)this.minValue) {
            mapIndex = 0;
        } else if (y > (double)this.maxValue) {
            mapIndex = this.maxIndex;
        } else {
            mapIndex = class_3532.method_15357((double)((y + this.noise.eval(x * 0.03, z * 0.03) * this.layerDistortion) / (double)this.worldHeight * (double)this.maxIndex + 0.5));
            mapIndex = class_3532.method_15340((int)mapIndex, (int)0, (int)this.maxIndex);
        }
        return this.maps[mapIndex].getBiome(x, y, z);
    }

    private void onChunkCreation(int cx, int cz, int side) {
        int z;
        int x;
        int i;
        BiomePicker.ActualBiome[][] biomeMap = new BiomePicker.ActualBiome[side][side];
        BiomeChunk[] chunks = new BiomeChunk[this.maps.length];
        boolean isNoEmpty = false;
        for (i = 0; i < this.maps.length; ++i) {
            chunks[i] = this.maps[i].getChunk(cx, cz, false);
            for (x = 0; x < side; ++x) {
                for (z = 0; z < side; ++z) {
                    if (biomeMap[x][z] != null) continue;
                    BiomePicker.ActualBiome biome = chunks[i].getBiome(x, z);
                    if (!biome.bclBiome.isVertical()) continue;
                    biomeMap[x][z] = biome;
                    isNoEmpty = true;
                }
            }
        }
        if (isNoEmpty) {
            for (i = 0; i < this.maps.length; ++i) {
                for (x = 0; x < side; ++x) {
                    for (z = 0; z < side; ++z) {
                        if (biomeMap[x][z] == null) continue;
                        chunks[i].setBiome(x, z, biomeMap[x][z]);
                    }
                }
            }
        }
    }
}

