/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.impl.biome.NetherBiomeData;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_6908;
import org.apache.commons.lang3.function.TriFunction;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.generator.BCLBiomeSource;
import org.betterx.bclib.api.v2.generator.BiomePicker;
import org.betterx.bclib.api.v2.generator.GeneratorOptions;
import org.betterx.bclib.api.v2.generator.map.MapStack;
import org.betterx.bclib.api.v2.generator.map.hex.HexBiomeMap;
import org.betterx.bclib.api.v2.generator.map.square.SquareBiomeMap;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.config.ConfigKeeper;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.interfaces.BiomeMap;

public class BCLibNetherBiomeSource
extends BCLBiomeSource {
    private static int lastWorldHeight;
    private static int worldHeight;
    public static final Codec<BCLibNetherBiomeSource> CODEC;
    private BiomeMap biomeMap;
    private final BiomePicker biomePicker;

    public BCLibNetherBiomeSource(class_2378<class_1959> biomeRegistry, Optional<Integer> version) {
        this(biomeRegistry, 0L, version, false);
    }

    public BCLibNetherBiomeSource(class_2378<class_1959> biomeRegistry, long seed, Optional<Integer> version) {
        this(biomeRegistry, seed, version, true);
    }

    private BCLibNetherBiomeSource(class_2378<class_1959> biomeRegistry, long seed, Optional<Integer> version, boolean initMaps) {
        this(biomeRegistry, BCLibNetherBiomeSource.getBiomes(biomeRegistry), seed, version, initMaps);
    }

    private BCLibNetherBiomeSource(class_2378<class_1959> biomeRegistry, List<class_6880<class_1959>> list, long seed, Optional<Integer> version, boolean initMaps) {
        super(biomeRegistry, list, seed, version);
        this.biomePicker = new BiomePicker(biomeRegistry);
        this.method_28443().forEach(biome -> {
            class_2960 key = ((class_5321)biome.method_40230().orElseThrow()).method_29177();
            if (!BiomeAPI.hasBiome(key)) {
                BCLBiome bclBiome = new BCLBiome(key, (class_1959)biome.comp_349());
                this.biomePicker.addBiome(bclBiome);
            } else {
                BCLBiome bclBiome = BiomeAPI.getBiome(key);
                if (bclBiome != BiomeAPI.EMPTY_BIOME && bclBiome.getParentBiome() == null) {
                    this.biomePicker.addBiome(bclBiome);
                }
            }
        });
        this.biomePicker.rebuild();
        if (initMaps) {
            this.initMap(seed);
        }
    }

    @Override
    protected BCLBiomeSource cloneForDatapack(Set<class_6880<class_1959>> datapackBiomes) {
        datapackBiomes.addAll(BCLibNetherBiomeSource.getBclBiomes((class_2378<class_1959>)this.biomeRegistry));
        return new BCLibNetherBiomeSource((class_2378<class_1959>)this.biomeRegistry, datapackBiomes.stream().toList(), this.currentSeed, Optional.of(this.biomeSourceVersion), true);
    }

    public static void setWorldHeight(int worldHeight) {
        BCLibNetherBiomeSource.worldHeight = worldHeight;
    }

    private static List<class_6880<class_1959>> getBclBiomes(class_2378<class_1959> biomeRegistry) {
        List include = (List)Configs.BIOMES_CONFIG.getEntry("force_include", "nether_biomes", ConfigKeeper.StringArrayEntry.class).getValue();
        List exclude = (List)Configs.BIOMES_CONFIG.getEntry("force_exclude", "nether_biomes", ConfigKeeper.StringArrayEntry.class).getValue();
        return BCLibNetherBiomeSource.getBiomes(biomeRegistry, exclude, include, BCLibNetherBiomeSource::isValidNonVanillaNetherBiome);
    }

    private static List<class_6880<class_1959>> getBiomes(class_2378<class_1959> biomeRegistry) {
        List include = (List)Configs.BIOMES_CONFIG.getEntry("force_include", "nether_biomes", ConfigKeeper.StringArrayEntry.class).getValue();
        List exclude = (List)Configs.BIOMES_CONFIG.getEntry("force_exclude", "nether_biomes", ConfigKeeper.StringArrayEntry.class).getValue();
        return BCLibNetherBiomeSource.getBiomes(biomeRegistry, exclude, include, BCLibNetherBiomeSource::isValidNetherBiome);
    }

    private static boolean isValidNetherBiome(class_6880<class_1959> biome, class_2960 location) {
        return NetherBiomeData.canGenerateInNether((class_5321)((class_5321)biome.method_40230().get())) || biome.method_40220(class_6908.field_36518) || BiomeAPI.wasRegisteredAsNetherBiome(location);
    }

    private static boolean isValidNonVanillaNetherBiome(class_6880<class_1959> biome, class_2960 location) {
        return !"minecraft".equals(location.method_12836()) && NetherBiomeData.canGenerateInNether((class_5321)((class_5321)biome.method_40230().get())) || BiomeAPI.wasRegisteredAs(location, BiomeAPI.BiomeType.BCL_NETHER);
    }

    public static <T> void debug(Object el, class_2378<T> reg) {
        System.out.println("Unknown " + el + " in " + reg);
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)BCLib.makeID("nether_biome_source"), CODEC);
    }

    public class_6880<class_1959> method_38109(int biomeX, int biomeY, int biomeZ, class_6544.class_6552 var4) {
        if (this.biomeMap == null) {
            return (class_6880)this.method_28443().stream().findFirst().get();
        }
        if (lastWorldHeight != worldHeight) {
            lastWorldHeight = worldHeight;
            this.initMap(this.currentSeed);
        }
        if ((biomeX & 0x3F) == 0 && (biomeZ & 0x3F) == 0) {
            this.biomeMap.clearCache();
        }
        BiomePicker.ActualBiome bb = this.biomeMap.getBiome(biomeX << 2, biomeY << 2, biomeZ << 2);
        return bb.biome;
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    @Override
    protected void onInitMap(long seed) {
        TriFunction mapConstructor = this.biomeSourceVersion != BIOME_SOURCE_VERSION_HEX ? SquareBiomeMap::new : HexBiomeMap::new;
        this.biomeMap = worldHeight > 128 && GeneratorOptions.useVerticalBiomes() ? new MapStack(seed, GeneratorOptions.getBiomeSizeNether(), this.biomePicker, GeneratorOptions.getVerticalBiomeSizeNether(), worldHeight, (TriFunction<Long, Integer, BiomePicker, BiomeMap>)mapConstructor) : (BiomeMap)mapConstructor.apply((Object)seed, (Object)GeneratorOptions.getBiomeSizeNether(), (Object)this.biomePicker);
    }

    public String toString() {
        return "BCLib - Nether BiomeSource (" + Integer.toHexString(((Object)((Object)this)).hashCode()) + ", version=" + this.biomeSourceVersion + ", seed=" + this.currentSeed + ", biomes=" + this.method_28443().size() + ")";
    }

    static {
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6903.method_40419((class_5321)class_2378.field_25114).forGetter(source -> source.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(source -> source.currentSeed), (App)Codec.INT.optionalFieldOf("version").stable().forGetter(source -> Optional.of(source.biomeSourceVersion))).apply((Applicative)instance, instance.stable(BCLibNetherBiomeSource::new)));
    }
}

